/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch.util;

import com.jsbsoft.jtf.textsearch.ResultatRecherche;
import com.jsbsoft.jtf.textsearch.Searcher;
import com.kportal.cms.objetspartages.Objetpartage;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ContexteUniv;
import com.univ.utils.ContexteUtil;
import com.univ.utils.sql.criterespecifique.ConditionHelper;
import com.univ.utils.sql.criterespecifique.CritereRubriquePublicationHelper;
import com.univ.utils.sql.criterespecifique.RequeteSQLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RechercheUtilBO {
    private static Logger LOG = LoggerFactory.getLogger(RechercheUtilBO.class);

    public static List<ResultatRecherche> traiterRecherche(AutorisationBean autorisation, String request) throws Exception {
        Searcher searcher = Searcher.getInstance();
        if (searcher.getSearcher() == null) {
            return new ArrayList<ResultatRecherche>();
        }
        return RechercheUtilBO.searchAll(autorisation, searcher, request);
    }

    private static List<ResultatRecherche> searchAll(AutorisationBean autorisation, Searcher searcher, String request) throws Exception {
        String codeObjet = "";
        String codeRubrique = "";
        String action = "M";
        BooleanQuery query = RechercheUtilBO.getQueryDsi(autorisation, "M", "", "");
        ArrayList<SortField> sortFields = new ArrayList<SortField>();
        sortFields.add(SortField.FIELD_SCORE);
        Sort sort = new Sort(sortFields.toArray(new SortField[sortFields.size()]));
        ArrayList<ResultatRecherche> listeFiches = new ArrayList<ResultatRecherche>();
        int maxDocs = searcher.getSearcher().maxDoc();
        if (maxDocs > 0) {
            TopFieldCollector tfc = TopFieldCollector.create((Sort)sort, (int)maxDocs, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
            searcher.getSearcher().search((Query)query, (Collector)tfc);
            int totalHits = tfc.getTotalHits();
            TopDocs results = tfc.topDocs();
            int nbHits = results.scoreDocs.length;
            Document doc = null;
            for (int i = 0; i < nbHits; ++i) {
                doc = searcher.getSearcher().doc(results.scoreDocs[i].doc);
                ResultatRecherche resultatRecherche = new ResultatRecherche();
                resultatRecherche.setObjet(doc.get("nom_objet"));
                resultatRecherche.setCodeFiche(doc.get("code"));
                resultatRecherche.setIdFiche(doc.get("id_fiche"));
                resultatRecherche.setLangue(doc.get("langue"));
                resultatRecherche.setCodeRubrique(doc.get("code_rubrique"));
                resultatRecherche.setCodeRattachement(doc.get("code_rattachement"));
                resultatRecherche.setPublicVise(doc.get("public_vise"));
                resultatRecherche.setModeRestriction(doc.get("mode_restriction"));
                resultatRecherche.setPublicViseRestriction(doc.get("public_vise_restriction"));
                resultatRecherche.setTitre(doc.get("title"));
                resultatRecherche.setUrl(doc.get("url"));
                resultatRecherche.setDateModification(doc.get("date_modification"));
                resultatRecherche.setDescription(doc.get("description"));
                resultatRecherche.setRank(i);
                resultatRecherche.setTotal(nbHits);
                resultatRecherche.setTotalHits(totalHits);
                listeFiches.add(resultatRecherche);
            }
        } else {
            LOG.warn("Aucun document dans l'index de recherche");
        }
        return listeFiches;
    }

    private static BooleanQuery getQueryDsi(AutorisationBean autorisation, String action, String codeObjet, String codeRubrique) throws Exception {
        BooleanQuery query = new BooleanQuery();
        if (StringUtils.isNotEmpty((CharSequence)codeObjet) && !"0000".equals(codeObjet)) {
            FicheUniv fiche = ReferentielObjets.instancierFiche(ReferentielObjets.getNomObjet(codeObjet));
            RechercheUtilBO.addQuery(query, RechercheUtilBO.traiterConditionDsiMeta(autorisation, fiche, action, codeRubrique), BooleanClause.Occur.MUST);
        } else {
            BooleanQuery queryAll = new BooleanQuery();
            for (Objetpartage objet : ReferentielObjets.getObjetsPartagesTries()) {
                FicheUniv fiche = ReferentielObjets.instancierFiche(objet.getNomObjet());
                if (objet.isStrictlyCollaboratif() || fiche == null) continue;
                fiche.setCodeRubrique(codeRubrique);
                RechercheUtilBO.addQuery(queryAll, RechercheUtilBO.traiterConditionDsiMeta(autorisation, fiche, action, codeRubrique), BooleanClause.Occur.SHOULD);
            }
            RechercheUtilBO.addQuery(query, queryAll, BooleanClause.Occur.MUST);
        }
        RechercheUtilBO.addQuery(query, RechercheUtilBO.getConditionRubPubSuivantAction(ContexteUtil.getContexteUniv(), action, codeRubrique), BooleanClause.Occur.MUST);
        return query;
    }

    private static BooleanQuery getConditionRubPubSuivantAction(ContexteUniv ctx, String action, String codeRubrique) throws Exception {
        Collection<String> listeCodeRubriques = CritereRubriquePublicationHelper.getCodesRubriquesSuivantAction(ctx, action, codeRubrique);
        BooleanQuery conditionRubPub = new BooleanQuery();
        for (String code : listeCodeRubriques) {
            conditionRubPub.add((Query)new TermQuery(new Term("code_rubrique", code)), BooleanClause.Occur.SHOULD);
        }
        return conditionRubPub;
    }

    private static BooleanQuery traiterConditionDsiMeta(AutorisationBean autorisation, FicheUniv fiche, String action, String rubriqueRecherche) throws Exception {
        BooleanQuery conditionComplete = new BooleanQuery();
        BooleanQuery conditionSurFiche = new BooleanQuery();
        boolean restriction = Boolean.FALSE;
        boolean aucuneRestriction = Boolean.FALSE;
        boolean aucunePermission = Boolean.TRUE;
        String codeObjet = ReferentielObjets.getCodeObjet(fiche);
        Hashtable<String, String> actionsPossibles = RequeteSQLHelper.recupererActionsPossibles(action);
        HashSet<String> codesEspacesCollab = new HashSet<String>();
        if (autorisation != null) {
            for (Map.Entry<String, String> actionPossible : actionsPossibles.entrySet()) {
                String lettreAction = actionPossible.getKey();
                for (Map.Entry<String, Vector<Perimetre>> permission : autorisation.getListePermissions().entrySet()) {
                    if (!RequeteSQLHelper.isPermissionValide(permission.getKey(), codeObjet, lettreAction)) continue;
                    aucunePermission = Boolean.FALSE;
                    for (Perimetre perimetre : permission.getValue()) {
                        BooleanQuery conditionPerimetre = new BooleanQuery();
                        if (RequeteSQLHelper.isAcuneRestriction(perimetre)) {
                            aucuneRestriction = Boolean.TRUE;
                        } else {
                            BooleanQuery conditionRubrique = RechercheUtilBO.traiterCodeRubriquePerimetre(perimetre.getCodeRubrique(), rubriqueRecherche);
                            BooleanQuery conditionStructure = RechercheUtilBO.traiterStructurePerimetre(perimetre.getCodeStructure(), fiche);
                            if (StringUtils.isNotEmpty((CharSequence)perimetre.getCodeEspaceCollaboratif())) {
                                codesEspacesCollab.add(perimetre.getCodeEspaceCollaboratif());
                            }
                            if (!conditionRubrique.clauses().isEmpty()) {
                                restriction = Boolean.TRUE;
                                conditionPerimetre.add((Query)conditionRubrique, BooleanClause.Occur.MUST);
                            }
                            if (!conditionStructure.clauses().isEmpty()) {
                                restriction = Boolean.TRUE;
                                conditionPerimetre.add((Query)conditionStructure, BooleanClause.Occur.MUST);
                            }
                        }
                        RechercheUtilBO.addQuery(conditionSurFiche, conditionPerimetre, BooleanClause.Occur.SHOULD);
                    }
                }
            }
        }
        if (!codesEspacesCollab.isEmpty()) {
            BooleanQuery conditionEspaceCollab = new BooleanQuery();
            conditionEspaceCollab.add((Query)new TermQuery(new Term("mode_restriction", "4")), BooleanClause.Occur.MUST);
            BooleanQuery conditionCode = new BooleanQuery();
            for (String codeEspace : codesEspacesCollab) {
                conditionCode.add((Query)new TermQuery(new Term("public_vise_restriction", codeEspace)), BooleanClause.Occur.SHOULD);
            }
            RechercheUtilBO.addQuery(conditionEspaceCollab, conditionCode, BooleanClause.Occur.MUST);
            RechercheUtilBO.addQuery(conditionSurFiche, conditionEspaceCollab, BooleanClause.Occur.SHOULD);
        }
        if (aucunePermission) {
            if (autorisation == null) {
                BooleanQuery conditionImpossible = new BooleanQuery();
                conditionImpossible.add((Query)new TermQuery(new Term("nom_objet", "0000")), BooleanClause.Occur.MUST);
                return conditionImpossible;
            }
            BooleanQuery ficheDeLUtilisateur = new BooleanQuery();
            ficheDeLUtilisateur.add((Query)new TermQuery(new Term("code_redacteur", autorisation.getCode())), BooleanClause.Occur.MUST);
            if (StringUtils.isNotBlank((CharSequence)codeObjet)) {
                ficheDeLUtilisateur.add((Query)new TermQuery(new Term("nom_objet", ReferentielObjets.getNomObjet(codeObjet))), BooleanClause.Occur.MUST);
            }
            return ficheDeLUtilisateur;
        }
        if (conditionSurFiche.clauses().isEmpty() && !aucuneRestriction) {
            conditionSurFiche.add((Query)new TermQuery(new Term("nom_objet", null)), BooleanClause.Occur.MUST_NOT);
            return conditionSurFiche;
        }
        if (aucuneRestriction && !restriction && !codesEspacesCollab.isEmpty()) {
            conditionSurFiche.add((Query)new TermQuery(new Term("mode_restriction", "4")), BooleanClause.Occur.MUST_NOT);
        }
        conditionComplete.add((Query)new TermQuery(new Term("nom_objet", ReferentielObjets.getNomObjet(codeObjet))), BooleanClause.Occur.MUST);
        RechercheUtilBO.addQuery(conditionComplete, conditionSurFiche, BooleanClause.Occur.MUST);
        return conditionComplete;
    }

    private static BooleanQuery traiterStructurePerimetre(String codeStructure, FicheUniv fiche) throws Exception {
        BooleanQuery conditionStructure = new BooleanQuery();
        if (StringUtils.isNotEmpty((CharSequence)codeStructure)) {
            if ("-".equals(codeStructure)) {
                conditionStructure.add((Query)new TermQuery(new Term("code_rattachement", "")), BooleanClause.Occur.MUST);
            } else {
                if (ConditionHelper.isStructureNoArbo(codeStructure = codeStructure.replaceAll("\\+", ";"))) {
                    codeStructure = StringUtils.substringBefore((String)codeStructure, (String)"_NOARBO");
                    conditionStructure.add((Query)new TermQuery(new Term("code_rattachement", codeStructure)), BooleanClause.Occur.MUST);
                    return conditionStructure;
                }
                Collection<String> listeDesCodesStructures = ConditionHelper.getListeDesCodesStructures(codeStructure);
                BooleanQuery conditionCode = new BooleanQuery();
                for (String code : listeDesCodesStructures) {
                    conditionCode.add((Query)new TermQuery(new Term("code_rattachement", code)), BooleanClause.Occur.SHOULD);
                }
                if (fiche instanceof StructureModele) {
                    conditionCode.add((Query)new TermQuery(new Term("code", codeStructure)), BooleanClause.Occur.SHOULD);
                }
                RechercheUtilBO.addQuery(conditionStructure, conditionCode, BooleanClause.Occur.MUST);
            }
        }
        return conditionStructure;
    }

    private static BooleanQuery traiterCodeRubriquePerimetre(String codeRubrique, String rubriqueRecherche) throws Exception {
        BooleanQuery conditionRubrique = new BooleanQuery();
        if (StringUtils.isNotEmpty((CharSequence)codeRubrique)) {
            if ("-".equals(codeRubrique)) {
                conditionRubrique.add((Query)new TermQuery(new Term("code_rubrique", "")), BooleanClause.Occur.MUST);
            } else {
                Collection<String> codesRubriquesValides = RequeteSQLHelper.recupererListeCodeRubriqueParRubriqueRecherche(codeRubrique, rubriqueRecherche);
                BooleanQuery conditionCode = new BooleanQuery();
                for (String code : codesRubriquesValides) {
                    conditionCode.add((Query)new TermQuery(new Term("code_rubrique", code)), BooleanClause.Occur.SHOULD);
                }
                RechercheUtilBO.addQuery(conditionRubrique, conditionCode, BooleanClause.Occur.MUST);
            }
        }
        return conditionRubrique;
    }

    private static void addQuery(BooleanQuery query, BooleanQuery queryToAdd, BooleanClause.Occur occur) {
        if (!queryToAdd.clauses().isEmpty()) {
            query.add((Query)queryToAdd, occur);
        }
    }
}

