/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.textsearch.util;

import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.utils.Chaine;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.search.Query;

public class SearchPropertiesHelper {
    public static final String KEY = "recherche";
    public static final String BOOST_TITRE = "boost_titre";
    public static final String BOOST_METAKEYWORDS = "boost_keywords";
    public static final String BOOST_METADESCRIPTION = "boost_description";
    public static final String BY_SITE = "by_site";
    public static final String BOOST_OBJETS = "boost_objets";
    public static final String BOOST_LIKE = "boost_like";
    public static final String BOOST_OR = "boost_or";
    public static final String BOOST_PHRASE = "boost_phrase";
    public static final String BOOST_AND = "boost_and";
    public static final String BOOST_DATE = "boost_date";
    public static final String LIKE = "like";
    public static final String OR = "or";

    public static boolean executeRechercheLIKE(String aliasSite) {
        return "1".equals(SearchPropertiesHelper.getPropertySite(aliasSite, LIKE));
    }

    public static boolean executeRechercheOR(String aliasSite) {
        return "1".equals(SearchPropertiesHelper.getPropertySite(aliasSite, OR));
    }

    public static boolean executeRechercheBySite() {
        return "1".equals(SearchPropertiesHelper.getProperty(BY_SITE));
    }

    public static int getBoostRechercheLIKE(String aliasSite) {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getPropertySite(aliasSite, BOOST_LIKE));
    }

    public static int getBoostRechercheOR(String aliasSite) {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getPropertySite(aliasSite, BOOST_OR));
    }

    public static int getBoostRecherchePhrase(String aliasSite) {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getPropertySite(aliasSite, BOOST_PHRASE));
    }

    public static int getBoostRechercheAND(String aliasSite) {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getPropertySite(aliasSite, BOOST_AND));
    }

    public static int getBoostTitre() {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getProperty(BOOST_TITRE));
    }

    public static int getBoostDate() {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getProperty(BOOST_DATE));
    }

    public static int getBoostMetaKeywords() {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getProperty(BOOST_METAKEYWORDS));
    }

    public static int getBoostMetaDescription() {
        return SearchPropertiesHelper.parseBoost(SearchPropertiesHelper.getProperty(BOOST_METADESCRIPTION));
    }

    public static int getBoostParObjet(String alias, String nomObjet) {
        String boost = "";
        List<String> lObjets = null;
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            InfosSite site = Site.renvoyerItemSite(alias);
            lObjets = site.getProprieteComplementaireListString("recherche_boost_objets");
        } else {
            lObjets = Chaine.getListCrochets(SearchPropertiesHelper.getProperty(BOOST_OBJETS));
        }
        for (String oBoost : lObjets) {
            if (!oBoost.startsWith(nomObjet + ",")) continue;
            boost = StringUtils.substringAfter((String)oBoost, (String)",");
        }
        return SearchPropertiesHelper.parseBoost(boost);
    }

    public static boolean hasBoostParObjet(String aliasSite) {
        return StringUtils.isNotEmpty((CharSequence)SearchPropertiesHelper.getPropertyBoostObjets(aliasSite));
    }

    private static String getPropertyBoostObjets(String aliasSite) {
        return SearchPropertiesHelper.getPropertySite(aliasSite, BOOST_OBJETS);
    }

    private static String getPropertySite(String alias, String key) {
        if (StringUtils.isEmpty((CharSequence)alias)) {
            return SearchPropertiesHelper.getProperty(key);
        }
        InfosSite site = Site.renvoyerItemSite(alias);
        return site.getProprieteComplementaireString("recherche_" + key);
    }

    private static String getProperty(String key) {
        return PropertyHelper.getCoreProperty("recherche." + key);
    }

    private static int parseBoost(String boost) {
        int res = 1;
        try {
            res = Integer.parseInt(boost);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    public static void setQueryBoost(Query query, int boost) {
        if (boost > 1) {
            query.setBoost((float)boost * 1.0f);
        }
    }
}

