/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.upload;

import com.jsbsoft.jtf.upload.UploadedFile;
import com.kportal.core.config.PropertyHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;

public class ExtendedRequest
implements HttpServletRequest {
    private final HttpServletRequest request;
    private HashMap<String, Object> params;

    public ExtendedRequest(HttpServletRequest req, HttpServletResponse res, File tmpDir) throws Exception {
        this.request = req;
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            long maxsize = 0L;
            DiskFileItemFactory fac = new DiskFileItemFactory();
            fac.setRepository(tmpDir);
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
            upload.setHeaderEncoding("UTF-8");
            List items = upload.parseRequest(req);
            for (FileItem fileItem : items) {
                if (!fileItem.isFormField() || !fileItem.getFieldName().equals("MAX_FILE_SIZE")) continue;
                try {
                    maxsize = Long.parseLong(fileItem.getString());
                    maxsize *= 1024L;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (maxsize == 0L) {
                try {
                    maxsize = Long.parseLong(PropertyHelper.getCoreProperty("fichiergw.maxsize"));
                    maxsize *= 1024L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (maxsize == 0L) {
                maxsize = 2000000L;
            }
            for (FileItem item : items) {
                Object fieldValue;
                if (this.params == null) {
                    this.params = new HashMap();
                }
                String fieldName = item.getFieldName();
                if (item.isFormField()) {
                    fieldValue = Streams.asString((InputStream)item.getInputStream(), (String)"UTF-8");
                } else {
                    String[] lstS;
                    fieldValue = null;
                    if (item.getName().equals("")) {
                        lstS = new String[]{"1"};
                        this.params.put("EXCEPTION_FILE_UPLOAD", lstS);
                    } else if (item.getSize() > maxsize) {
                        lstS = new String[]{"2", Long.toString(maxsize)};
                        this.params.put("EXCEPTION_FILE_UPLOAD", lstS);
                    } else {
                        File fichier = new File(tmpDir, "upl_" + UUID.randomUUID());
                        item.write(fichier);
                        UploadedFile upf = new UploadedFile(item.getContentType(), (int)fichier.length(), item.getName(), fichier);
                        fieldValue = upf;
                    }
                }
                if (fieldName == null || fieldValue == null) continue;
                Object[] fieldValues = (Object[])this.params.get(fieldName);
                if (fieldValues == null) {
                    fieldValues = new Object[1];
                } else {
                    Object[] newVals = new Object[fieldValues.length + 1];
                    for (int i = 0; i < fieldValues.length; ++i) {
                        newVals[i] = fieldValues[i];
                    }
                    fieldValues = newVals;
                }
                fieldValues[fieldValues.length - 1] = fieldValue;
                this.params.put(fieldName, fieldValues);
            }
        } else {
            this.params = null;
        }
    }

    public UploadedFile getFileParameter(String name) {
        Object[] vals;
        UploadedFile file = null;
        if (this.params != null && (vals = (Object[])this.params.get(name)) != null && vals[0] instanceof UploadedFile) {
            file = (UploadedFile)vals[0];
        }
        return file;
    }

    public UploadedFile[] getFileParameterValues(String name) {
        Object[] vals;
        UploadedFile[] files = null;
        if (this.params != null && (vals = (Object[])this.params.get(name)) != null) {
            files = new UploadedFile[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                files[i] = vals[i] instanceof UploadedFile ? (UploadedFile)vals[i] : null;
            }
        }
        return files;
    }

    public String getParameter(String name) {
        String parameter = null;
        if (this.params == null) {
            parameter = this.request.getParameter(name);
        } else {
            Object[] vals = (Object[])this.params.get(name);
            if (vals != null) {
                parameter = vals[0].toString();
            }
        }
        return parameter;
    }

    public Enumeration<String> getParameterNames() {
        if (this.params == null) {
            return this.request.getParameterNames();
        }
        return Collections.enumeration(this.params.keySet());
    }

    public String[] getParameterValues(String name) {
        String[] parameterValues = null;
        if (this.params == null) {
            parameterValues = this.request.getParameterValues(name);
        } else {
            Object[] vals = (Object[])this.params.get(name);
            if (vals != null) {
                parameterValues = new String[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    parameterValues[i] = vals[i].toString();
                }
            }
        }
        return parameterValues;
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public Enumeration<String> getHeaders(String arg0) {
        return this.request.getHeaders(arg0);
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.request.getLocales();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRealPath(String virtualPath) {
        return this.request.getRealPath(virtualPath);
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return this.request.getRequestDispatcher(arg0);
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public boolean isUserInRole(String arg0) {
        return this.request.isUserInRole(arg0);
    }

    public void removeAttribute(String arg0) {
        this.request.removeAttribute(arg0);
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public StringBuffer getRequestURL() {
        return this.request.getRequestURL();
    }

    public Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        this.request.setCharacterEncoding(arg0);
    }

    public String getLocalAddr() {
        return this.request.getLocalAddr();
    }

    public String getLocalName() {
        return this.request.getLocalName();
    }

    public int getLocalPort() {
        return this.request.getLocalPort();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public AsyncContext getAsyncContext() {
        return this.request.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.request.getDispatcherType();
    }

    public ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public boolean isAsyncStarted() {
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.request.isAsyncSupported();
    }

    public AsyncContext startAsync() {
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest arg0, ServletResponse arg1) {
        return this.request.startAsync(arg0, arg1);
    }

    public boolean authenticate(HttpServletResponse arg0) throws IOException, ServletException {
        return this.request.authenticate(arg0);
    }

    public Part getPart(String arg0) throws IOException, IllegalStateException, ServletException {
        return this.request.getPart(arg0);
    }

    public Collection<Part> getParts() throws IOException, IllegalStateException, ServletException {
        return this.request.getParts();
    }

    public void login(String arg0, String arg1) throws ServletException {
        this.request.login(arg0, arg1);
    }

    public void logout() throws ServletException {
        this.request.logout();
    }
}

