/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class UploadedFile {
    String contentType;
    String contentFilename;
    int contentLength;
    File file;
    boolean fileHasBeenDeleted = false;
    public static final String PARAM_JTF_EXCEPTION_FILE_UPLOAD = "EXCEPTION_FILE_UPLOAD";
    public static final String KEY_MAX_FILE_SIZE = "MAX_FILE_SIZE";
    public static final String KEY_FILE_EXTENSIONS = "KEY_FILE_EXTENSIONS";
    public static final long MAX_SIZE = 2000000L;
    public static final String EXCEPTION_FILE_UPLOAD_FICHIER_INEXISTANT = "1";
    public static final String EXCEPTION_FILE_UPLOAD_TAILLE_FICHIER = "2";

    public UploadedFile(String contentType, int contentLength, String contentFilename, File file) {
        this.contentType = contentType;
        this.contentLength = contentLength;
        this.contentFilename = contentFilename;
        this.file = file;
    }

    public void deleteTemporaryFile() {
        if (this.file != null && !this.fileHasBeenDeleted) {
            this.fileHasBeenDeleted = true;
            this.file.delete();
        }
    }

    public String getContentFilename() {
        if (this.contentFilename != null) {
            int i = this.contentFilename.lastIndexOf(92);
            if (i != -1) {
                return this.contentFilename.substring(i + 1);
            }
            i = this.contentFilename.lastIndexOf(47);
            if (i != -1) {
                return this.contentFilename.substring(i + 1);
            }
        }
        return this.contentFilename;
    }

    public String getContentFullFilename() {
        return this.contentFilename;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public Reader getReader() throws IOException {
        return new FileReader(this.file);
    }

    public File getTemporaryFile() {
        if (this.file == null) {
            throw new IllegalStateException("no temporary file");
        }
        return this.file;
    }

    public String toString() {
        return this.contentFilename;
    }
}

