/*
 * Decompiled with CFR 0.152.
 */
package com.jsbsoft.jtf.webutils;

import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.database.BasicPoolMgr;
import com.jsbsoft.jtf.database.OMContext;
import com.jsbsoft.jtf.database.RequeteMgr;
import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextePage
implements OMContext {
    private static final Logger LOG = LoggerFactory.getLogger(ContextePage.class);
    private Connection connection = null;
    private boolean connectionLongue = false;
    private Locale locale = null;
    private String idRequete = "";
    private final Map<String, Object> datas = new HashMap<String, Object>();
    private String langue = "";
    private InfosSite infosSite = null;
    private boolean secure = false;

    public ContextePage(String _uri, String _langue) {
        this.setIdRequete(RequeteMgr.creerRequete());
        RequeteMgr.ajouterEvenement(this.getIdRequete(), "cr\u00e9ation contexte jsp uri " + _uri + ", langue=" + _langue);
        if ("1".equals(PropertyHelper.getCoreProperty("dump.detection_boucle"))) {
            Throwable tCreation = new Throwable();
            tCreation.fillInStackTrace();
            StackTraceElement[] stackTraceElements = tCreation.getStackTrace();
            String trace = "";
            for (StackTraceElement stackTraceElement : stackTraceElements) {
                trace = trace + stackTraceElement + "\n";
            }
            RequeteMgr.ajouterEvenement(this.getIdRequete(), "*** trace creation contexte :\n\t" + trace + "\n***\n");
        }
        if (_uri.length() > 0) {
            LOG.debug(_uri);
        }
        try {
            this.locale = LangueUtil.getLocale(Integer.parseInt(_langue == null ? "0" : _langue));
        }
        catch (Exception e) {
            this.locale = LangueUtil.getDefaultLocale();
        }
        this.setLangue(LangueUtil.getLangueLocale(this.getLocale()));
    }

    public ContextePage(String _uri) {
        this(_uri, null);
    }

    public ContextePage() {
        this("", null);
    }

    @Override
    public Map<String, Object> getDatas() {
        return this.datas;
    }

    public Map getInfosSessionUserMetier(String nomApplicatif) {
        Map mapApplicatifs = (Map)this.getDatas().get("INFO_SESSION_APPLICATIFS_METIER");
        if (mapApplicatifs != null) {
            return (Map)mapApplicatifs.get(nomApplicatif);
        }
        return null;
    }

    @Override
    public Connection getConnection() {
        if (this.connection == null) {
            this.initConnection();
        }
        return this.connection;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    private void initConnection() {
        if (this.connection == null) {
            this.connection = BasicPoolMgr.getConnection(this.connectionLongue);
        }
    }

    public void release() {
        RequeteMgr.terminerRequete(this.getIdRequete());
        if (this.connection != null) {
            BasicPoolMgr.releaseConnection(this.connection);
            this.connection = null;
        }
    }

    public String getLangue() {
        return this.langue;
    }

    public void setLangue(String langue) {
        this.langue = langue;
    }

    @Deprecated
    public String getMessage(String key) {
        String res = null;
        if (this.infosSite != null) {
            try {
                res = LangueUtil.getMessage(this.locale, this.infosSite.getAlias() + "." + key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (res == null || res.equals("")) {
            try {
                res = LangueUtil.getMessage(this.locale, key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return res == null ? "" : res;
    }

    @Override
    public String getIdRequete() {
        return this.idRequete;
    }

    public void setIdRequete(String string) {
        this.idRequete = string;
    }

    public void setConnectionLongue(boolean connectionLongue) {
        this.connectionLongue = connectionLongue;
    }

    @Override
    public void setInfosSite(InfosSite infosSite) {
        this.infosSite = infosSite;
    }

    @Override
    public InfosSite getInfosSite() {
        return this.infosSite;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public void putData(String key, Object value) {
        this.datas.put(key, value);
    }

    public Object getData(String key) {
        return this.datas.get(key);
    }

    public String getDataAsString(String key) {
        if (this.getData(key) != null && this.getData(key) instanceof String) {
            return (String)this.getData(key);
        }
        return "";
    }
}

