/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.adapter;

import com.kosmos.adapter.Adapter;
import com.kosmos.adapter.converter.EnumConvertUtilsBean;
import com.univ.utils.json.NamingStrategyHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;
import org.apache.commons.beanutils.converters.IntegerConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMapAdapter
implements Adapter<Map<String, Object>> {
    public static final String DEFAULT_PREFIX = "registration.";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMapAdapter.class);
    private BeanUtilsBean beanUtilsBean;

    public AbstractMapAdapter() {
        DateConverter converter = new DateConverter(null);
        String[] patterns = new String[]{"dd/MM/yyyy", "dd/MM/yyyy HH:mm:ss"};
        converter.setPatterns(patterns);
        IntegerConverter integerConverter = new IntegerConverter(null);
        BeanUtilsBean.setInstance((BeanUtilsBean)new BeanUtilsBean((ConvertUtilsBean)new EnumConvertUtilsBean()));
        this.beanUtilsBean = BeanUtilsBean.getInstance();
        this.beanUtilsBean.getConvertUtils().register((Converter)converter, Date.class);
        this.beanUtilsBean.getConvertUtils().register((Converter)integerConverter, Integer.class);
    }

    @Override
    public <E> E retrieveData(Map<String, Object> dataSource, Class<E> clazz) {
        try {
            E registrationData = clazz.newInstance();
            Map<String, Object> relevantDatas = this.getRelevantData(dataSource, clazz);
            this.beanUtilsBean.populate(registrationData, relevantDatas);
            return registrationData;
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.error(String.format("Une erreur est survenue lors de la tentative d'instanciation d'un bean de type %s", clazz), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error(String.format("Une erreur est survenue lors de la tentative de population du bean de type %s", clazz), (Throwable)e);
        }
        return null;
    }

    protected Map<String, Object> getRelevantData(Map<String, Object> dataSource, Class<?> clazz) {
        HashMap<String, Object> relevantDatas = new HashMap<String, Object>();
        String classPrefix = this.getClassPrefix(clazz);
        for (Map.Entry<String, Object> currentEntry : dataSource.entrySet()) {
            String relevantKey;
            if (currentEntry.getKey().startsWith(classPrefix)) {
                relevantKey = currentEntry.getKey().replace(classPrefix, "");
                relevantKey = NamingStrategyHelper.translateUnderscoreToUppercase(relevantKey);
                relevantDatas.put(relevantKey, currentEntry.getValue());
                continue;
            }
            if (!currentEntry.getKey().startsWith(DEFAULT_PREFIX)) continue;
            relevantKey = StringUtils.removeStart((String)currentEntry.getKey(), (String)DEFAULT_PREFIX);
            if (relevantDatas.get(relevantKey = NamingStrategyHelper.translateUnderscoreToUppercase(relevantKey)) != null) continue;
            relevantDatas.put(relevantKey, currentEntry.getValue());
        }
        return relevantDatas;
    }

    protected String getClassPrefix(Class<?> clazz) {
        return String.format("%s.", NamingStrategyHelper.translateUppercaseToUnderscore(clazz.getSimpleName()));
    }
}

