/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.components.media.tag;

import com.kosmos.components.media.bean.ComponentMediaFile;
import com.kosmos.components.media.bean.ComponentMediaFileList;
import com.kosmos.components.media.bean.ComponentMediaType;
import com.kosmos.components.media.view.model.ComponentMediaViewModel;
import com.kosmos.components.tags.AbstractJspIncludeTag;
import com.kportal.core.config.MessageHelper;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ComponentMediaTag
extends AbstractJspIncludeTag
implements TryCatchFinally {
    public static final String VIEW_MODEL = "viewModel";
    private String name;
    private ComponentMediaType type;
    private String label;
    private boolean multiple;
    private ComponentMediaFileList medias;

    public ComponentMediaTag() {
        this.path = "/adminsite/components/media/media-component.jsp";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ComponentMediaType getType() {
        return this.type;
    }

    public void setType(ComponentMediaType type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public ComponentMediaFileList getMedias() {
        return this.medias;
    }

    public void setMedias(ComponentMediaFileList medias) {
        this.medias = medias;
    }

    @Override
    public int doStartTag() throws JspException {
        this.pageContext.getRequest().setAttribute(VIEW_MODEL, (Object)this.buildModel());
        return super.doStartTag();
    }

    private ComponentMediaViewModel buildModel() {
        String finalLabel;
        ComponentMediaViewModel viewModel = new ComponentMediaViewModel();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty((Collection)this.medias)) {
            for (ComponentMediaFile currentComponentMediaFile : this.medias) {
                ids.add(currentComponentMediaFile.getId());
            }
            viewModel.setMedias(this.medias);
        }
        viewModel.setIds(String.format("[%s]", StringUtils.join(ids.iterator(), (String)",")));
        viewModel.setMultiple(this.multiple);
        viewModel.setName(this.name);
        viewModel.setType(this.type);
        String defaultLabel = this.multiple ? MessageHelper.getCoreMessage("MEDIA_COMPONENT.LABEL.MULTIPLE") : MessageHelper.getCoreMessage("MEDIA_COMPONENT.LABEL.UNIQUE");
        String string = finalLabel = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.label}) ? MessageHelper.getCoreMessage(this.label) : defaultLabel;
        if (finalLabel.equals(this.label)) {
            finalLabel = defaultLabel;
        }
        viewModel.setLabel(finalLabel);
        return viewModel;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.name = null;
        this.type = null;
        this.medias = null;
        this.label = null;
        this.multiple = false;
    }
}

