/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.card.dao;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.utils.LayoutJacksonMapper;
import com.univ.utils.json.Views;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class CardDAO
extends AbstractCommonDAO<CardBean> {
    public CardDAO() {
        this.tableName = "CARD";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CardBean add(CardBean card) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("insert into CARD (DATAS_CARD, KEY_CARD) values (?, ?)", 1);){
                String datas = LayoutJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)card);
                stmt.setString(1, datas);
                stmt.setString(2, card.getKey().toString());
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\" : %d row(s) affected", card.toString(), this.tableName, rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                card.setId(rs.getLong(1));
            }
            if (rs == null) return card;
        }
        catch (Exception e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\"", card.toString(), this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return card;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occured closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return card;
        }
    }

    @Override
    public CardBean update(CardBean card) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update CARD set DATAS_CARD = ?, KEY_CARD = ? WHERE ID_CARD = ?");){
            String datas = LayoutJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)card);
            stmt.setString(1, datas);
            stmt.setString(2, card.getKey().toString());
            stmt.setLong(3, card.getId());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"%s\"", card.toString(), this.tableName), e);
        }
        return card;
    }

    @Override
    protected CardBean fill(ResultSet rs) throws DataSourceException {
        CardBean card = new CardBean();
        try {
            card = (CardBean)LayoutJacksonMapper.getMapper().readValue(rs.getString("DATAS_CARD"), CardBean.class);
            card.setId(rs.getLong("ID_CARD"));
            card.setKey(UUID.fromString(rs.getString("KEY_CARD")));
        }
        catch (Exception e) {
            LOG.error("An error occured trying to map card bean", (Throwable)e);
        }
        return card;
    }
}

