/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.card.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DeleteFromDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.kosmos.layout.Layout;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.card.dao.CardDAO;
import com.kosmos.layout.card.util.CardDescription;
import com.kosmos.layout.card.util.CardList;
import com.kosmos.layout.exception.CardNotFoundException;
import com.kosmos.layout.exception.CardsNotFoundException;
import com.kosmos.layout.meta.bean.CardMetaBean;
import com.kosmos.layout.meta.dao.CardMetaDAO;
import com.kosmos.layout.slot.Slot;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.AbstractBeanManager;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.FicheUnivMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCard
extends AbstractBeanManager {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCard.class);
    public static final String ID_BEAN = "serviceCard";
    private final CardList cardsPool;
    private Map<Class<? extends CardBean>, CardDescription> availableCards = new HashMap<Class<? extends CardBean>, CardDescription>();
    private CardDAO cardDao;
    private CardMetaDAO cardMetaDao;

    public ServiceCard() {
        this.cardsPool = new CardList();
    }

    public Map<Class<? extends CardBean>, CardDescription> getAvailableCards() {
        return this.availableCards;
    }

    public void setCardDao(CardDAO cardDao) {
        this.cardDao = cardDao;
    }

    public void setCardMetaDao(CardMetaDAO cardMetaDao) {
        this.cardMetaDao = cardMetaDao;
    }

    public CardList getAllowedCardsPool(Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes) {
        CardList allowedPool = new CardList();
        Collection<Class<? extends CardBean>> allowedCardTypesSet = this.getAllowedCardTypesSet(allowedCardTypes);
        for (CardBean currentCardBean : this.cardsPool) {
            if (!allowedCardTypesSet.contains(currentCardBean.getClass())) continue;
            allowedPool.add(currentCardBean);
        }
        return allowedPool;
    }

    private Collection<Class<? extends CardBean>> getAllowedCardTypesSet(Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes) {
        HashSet<Class<? extends CardBean>> allowedTypesSet = new HashSet<Class<? extends CardBean>>();
        for (Map.Entry<String, Collection<Class<? extends CardBean>>> currentEntry : allowedCardTypes.entrySet()) {
            allowedTypesSet.addAll(currentEntry.getValue());
        }
        return allowedTypesSet;
    }

    public Map<String, String> getAllowedCardBoView(Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes) {
        HashMap<String, String> allowedPool = new HashMap<String, String>();
        Collection<Class<? extends CardBean>> allowedCardTypesSet = this.getAllowedCardTypesSet(allowedCardTypes);
        for (CardBean currentCardBean : this.cardsPool) {
            if (!allowedCardTypesSet.contains(currentCardBean.getClass())) continue;
            allowedPool.put(currentCardBean.getClass().getName(), currentCardBean.getViewBo());
        }
        return allowedPool;
    }

    public void addCardForMeta(CardBean card, Metatag meta) throws DataSourceException {
        if (card.getId() != null) {
            this.cardDao.update(card);
        } else {
            this.cardDao.add(card);
        }
        CardMetaBean cardMeta = this.cardMetaDao.getCardMeta(card.getId(), meta.getIdMetatag());
        if (cardMeta == null) {
            cardMeta = new CardMetaBean();
            cardMeta.setIdCard(card.getId());
            cardMeta.setIdMeta(meta.getIdMetatag());
            this.cardMetaDao.add(cardMeta);
        }
    }

    public void deleteCardForMeta(CardBean card, Metatag meta) throws DeleteFromDataSourceException {
        this.cardDao.delete(card.getId());
        this.cardMetaDao.deleteCardMeta(card.getId(), meta.getIdMetatag());
    }

    public void updateCard(CardBean card) throws UpdateToDataSourceException {
        this.cardDao.update(card);
    }

    public void updateCardModel(Map<String, CardBean> model) throws UpdateToDataSourceException {
        for (CardBean currentCardBean : model.values()) {
            this.updateCard(currentCardBean);
        }
    }

    public Map<String, CardBean> getCards(FicheUniv fiche) throws CardsNotFoundException {
        try {
            Metatag meta = FicheUnivMgr.lireMeta(fiche);
            return this.getCards(meta.getIdMetatag());
        }
        catch (Exception e) {
            throw new CardsNotFoundException(String.format(MessageHelper.getCoreMessage("BO.CARD.EXCEPTION.NOT_FOUND_FICHE"), fiche.getCode()), e);
        }
    }

    public Map<String, CardBean> getCards(Long metaId) throws CardsNotFoundException {
        Collection<CardMetaBean> cardMeta = this.cardMetaDao.getByMeta(metaId);
        HashMap<String, CardBean> cards = new HashMap<String, CardBean>();
        for (CardMetaBean currentCardMeta : cardMeta) {
            try {
                CardBean currentCardBean = (CardBean)this.cardDao.getById(currentCardMeta.getIdCard());
                cards.put(currentCardBean.getKey().toString(), currentCardBean);
            }
            catch (DataSourceException e) {
                LOG.warn(String.format(MessageHelper.getCoreMessage("BO.CARD.EXCEPTION.NOT_FOUND_META"), metaId), (Throwable)e);
            }
        }
        return cards;
    }

    public CardBean getCardById(Long cardId) throws CardNotFoundException {
        try {
            return (CardBean)this.cardDao.getById(cardId);
        }
        catch (DataSourceException e) {
            throw new CardNotFoundException(String.format(MessageHelper.getCoreMessage("BO.CARD.EXCEPTION.NOT_FOUND_ID"), cardId), e);
        }
    }

    public Map<String, String> getAllowedEditFragments(Collection<CardBean> pool) {
        HashMap<String, String> editFragments = new HashMap<String, String>();
        for (CardBean currentCard : pool) {
            editFragments.put(currentCard.getClass().getName(), currentCard.getEditFragment());
        }
        return editFragments;
    }

    public void cleanUpModel(FicheUniv ficheUniv, Map<String, CardBean> providedModel) throws Exception {
        Metatag meta = FicheUnivMgr.lireMeta(ficheUniv);
        try {
            Map<String, CardBean> recordedModel = this.getCards(ficheUniv);
            for (Map.Entry<String, CardBean> currentEntry : recordedModel.entrySet()) {
                if (providedModel.containsKey(currentEntry.getKey())) continue;
                try {
                    CardMetaBean cardMeta = this.cardMetaDao.getCardMeta(currentEntry.getValue().getId(), meta.getIdMetatag());
                    this.cardMetaDao.delete(cardMeta.getId());
                    this.cardDao.delete(currentEntry.getValue().getId());
                }
                catch (DeleteFromDataSourceException e) {
                    LOG.error(String.format("La carte portant l'id \"%d\" n'a pas pu \u00eatre supprim\u00e9e.", currentEntry.getValue().getId()), (Throwable)e);
                }
            }
        }
        catch (CardsNotFoundException e) {
            LOG.info("Aucune carte trouv\u00e9e pour le nettoyage du mod\u00e8le.");
        }
    }

    @Override
    public void refresh() {
        Map<String, CardDescription> retrievedCardDescription = ApplicationContextManager.getAllBeansOfType(CardDescription.class);
        if (MapUtils.isNotEmpty(retrievedCardDescription)) {
            for (CardDescription currentCardDescription : retrievedCardDescription.values()) {
                this.availableCards.put(currentCardDescription.getType(), currentCardDescription);
                try {
                    this.cardsPool.add(currentCardDescription.getType().newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LOG.error("Une erreur est survenue lors de la cr\u00e9ation du pool de carte", (Throwable)e);
                }
            }
        }
    }

    public Map<String, Collection<Class<? extends CardBean>>> getAllowedCardTypes(Layout layout) {
        HashMap<String, Collection<Class<? extends CardBean>>> cardsAllowed = new HashMap<String, Collection<Class<? extends CardBean>>>();
        for (Slot currentSlot : layout.getSlots()) {
            ArrayList<Class<? extends CardBean>> allowedClasses = new ArrayList<Class<? extends CardBean>>();
            if (CollectionUtils.isEmpty(currentSlot.getAllowedCardTypes())) {
                if (CollectionUtils.isEmpty(layout.getAllowedCardTypes())) {
                    allowedClasses.addAll(this.getAllCardClasses());
                } else {
                    allowedClasses.addAll(layout.getAllowedCardTypes());
                }
            } else {
                allowedClasses.addAll(currentSlot.getAllowedCardTypes());
            }
            cardsAllowed.put(currentSlot.getKey().toString(), allowedClasses);
        }
        return cardsAllowed;
    }

    public Collection<CardDescription> getAllowedCardsDescriptions(Layout layout) {
        ArrayList<CardDescription> descriptions = new ArrayList<CardDescription>();
        Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes = this.getAllowedCardTypes(layout);
        for (Collection<Class<? extends CardBean>> cards : allowedCardTypes.values()) {
            for (Class<? extends CardBean> currentClass : cards) {
                CardDescription description = this.availableCards.get(currentClass);
                if (descriptions.contains(description)) continue;
                descriptions.add(description);
            }
        }
        Collections.sort(descriptions);
        return descriptions;
    }

    private Collection<Class<? extends CardBean>> getAllCardClasses() {
        return this.availableCards.keySet();
    }
}

