/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.card.util;

import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.utils.LayoutJacksonMapper;
import com.univ.utils.ContexteUtil;
import com.univ.utils.UnivWebFmt;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardUtil {
    public static final Logger LOG = LoggerFactory.getLogger(CardUtil.class);

    public static String getJsonModel(CardBean card) throws IOException {
        if (card != null) {
            return LayoutJacksonMapper.getMapper().writeValueAsString((Object)card);
        }
        return null;
    }

    public static CardBean getCardFromJson(String jsonCard) throws IOException {
        return (CardBean)LayoutJacksonMapper.getMapper().readValue(jsonCard, CardBean.class);
    }

    public static String getLink(String link) {
        String[] datas = StringUtils.split((String)StringUtils.substringBefore((String)link, (String)"|"), (String)",");
        if (datas.length == 3) {
            try {
                String code = datas[0];
                String langue = datas[1].replace("LANGUE=", "");
                String objet = datas[2].replace("TYPE=", "");
                return UnivWebFmt.determinerUrlFiche(ContexteUtil.getContexteUniv(), objet, code, langue, true, ContexteUtil.getContexteUniv().getCodeRubriqueFicheCourante());
            }
            catch (Exception e) {
                LOG.error(String.format("Une erreur est survenue lors du calcul de l'url %s", link), (Throwable)e);
                return "";
            }
        }
        return "";
    }
}

