/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.content.impl;

import com.kosmos.components.media.bean.ComponentMediaFile;
import com.kosmos.components.media.bean.ComponentMediaFileList;
import com.kosmos.layout.annotations.MediaContent;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.content.impl.AbstractContentHandler;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteDao;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaContentHandler
extends AbstractContentHandler<MediaContent> {
    public static final Logger LOG = LoggerFactory.getLogger(MediaContentHandler.class);

    @Override
    protected int handleModel(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas, int startIndex) {
        ComponentMediaFileList mediaFiles = this.getMediaFiles(inputedModel);
        int index = 0;
        for (ComponentMediaFile currentComponentMediaFile : mediaFiles) {
            this.synchronizeMedia(currentComponentMediaFile, ficheUniv);
            ++index;
        }
        return index;
    }

    @Override
    protected void handleSwitch(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas) {
        ComponentMediaFileList mediaFiles = this.getMediaFiles(inputedModel);
        for (ComponentMediaFile currentComponentMediaFile : mediaFiles) {
            this.switchRessource(currentComponentMediaFile, ficheUniv);
        }
    }

    private ComponentMediaFileList getMediaFiles(Map<String, CardBean> inputedModel) {
        ComponentMediaFileList mediaFiles = new ComponentMediaFileList();
        for (CardBean currentCard : inputedModel.values()) {
            Collection<Field> fields = this.getAnnotatedFields(currentCard);
            for (Field currentField : fields) {
                MediaContent contentType = currentField.getAnnotation(MediaContent.class);
                if (contentType.type() != 0) continue;
                try {
                    currentField.setAccessible(true);
                    Object fieldValue = currentField.get(currentCard);
                    if (fieldValue instanceof ComponentMediaFile) {
                        mediaFiles.add((ComponentMediaFile)fieldValue);
                        continue;
                    }
                    if (!(fieldValue instanceof ComponentMediaFileList)) continue;
                    mediaFiles.addAll((ComponentMediaFileList)fieldValue);
                }
                catch (IllegalAccessException e) {
                    LOG.error(String.format("An error occured trying to handle card %s", currentCard.toString()), (Throwable)e);
                }
            }
        }
        this.sortMediaFiles(mediaFiles);
        return mediaFiles;
    }

    private void sortMediaFiles(ComponentMediaFileList mediaFiles) {
        int index = this.getMaxIndex(mediaFiles);
        Collections.sort(mediaFiles, new Comparator<ComponentMediaFile>(){

            @Override
            public int compare(ComponentMediaFile o1, ComponentMediaFile o2) {
                return o2.getFileNumber() - o1.getFileNumber();
            }
        });
        for (ComponentMediaFile currentComponentMediaFile : mediaFiles) {
            if (currentComponentMediaFile.getFileNumber() != -1) continue;
            currentComponentMediaFile.setFileNumber(++index);
        }
    }

    private int getMaxIndex(ComponentMediaFileList componentMediaFileList) {
        int index = 0;
        for (ComponentMediaFile currentComponentMediaFile : componentMediaFileList) {
            if (index >= currentComponentMediaFile.getFileNumber()) continue;
            index = currentComponentMediaFile.getFileNumber();
        }
        return index;
    }

    private void synchronizeMedia(ComponentMediaFile componentMediaFile, FicheUniv ficheUniv) {
        try (ContexteDao ctx = new ContexteDao();){
            Ressource.synchroniserFichier(ctx, ficheUniv, componentMediaFile.toString(), "PHOTO", componentMediaFile.getFileNumber());
        }
        catch (Exception e) {
            LOG.error(String.format("An error occured trying to save mediaFile %s", componentMediaFile.toString()), (Throwable)e);
        }
    }

    private void switchRessource(ComponentMediaFile componentMediaFile, FicheUniv ficheUniv) {
        Ressource newRessource = Ressource.getFichier(ficheUniv, Integer.toString(componentMediaFile.getFileNumber()));
        if (newRessource != null && !Objects.equals(newRessource.getIdRessource(), componentMediaFile.getId())) {
            componentMediaFile.setId(newRessource.getIdRessource());
            componentMediaFile.setFormat(newRessource.getFormat());
            componentMediaFile.setLegende(newRessource.getLegende());
            componentMediaFile.setTitre(newRessource.getLibelle());
        }
    }
}

