/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.content.impl;

import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kosmos.layout.annotations.MediaContent;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.card.dao.CardDAO;
import com.kosmos.layout.content.impl.AbstractContentHandler;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Ressource;
import com.univ.utils.ContexteDao;
import com.univ.utils.ContexteUtil;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolboxContentHandler
extends AbstractContentHandler<MediaContent> {
    public static final Logger LOG = LoggerFactory.getLogger(ToolboxContentHandler.class);
    private static final Pattern imagePattern = Pattern.compile("(\\[id-image\\]([0-9]+)\\[/id-image\\])");
    private static final Pattern linkPattern = Pattern.compile("\\[id-fichier\\]([0-9]+)\\[/id-fichier\\]");
    private CardDAO cardDao;

    public void setCardDao(CardDAO cardDao) {
        this.cardDao = cardDao;
    }

    @Override
    protected void prepareModelContent(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas) {
        for (CardBean currentCard : inputedModel.values()) {
            this.prepareCardContent(currentCard);
        }
    }

    private void prepareCardContent(CardBean card) {
        HttpSession session = ContexteUtil.getContexteUniv().getRequeteHTTP().getSession();
        SessionUtilisateur sessionUtilisateur = (SessionUtilisateur)session.getAttribute("session");
        if (sessionUtilisateur != null) {
            Collection<Field> annotatedFields = this.getAnnotatedFields(card);
            for (Field currentField : annotatedFields) {
                try {
                    String content = this.getContent(currentField, card);
                    if (!StringUtils.isNotBlank((CharSequence)content)) continue;
                    Hashtable<String, Object> infosSession = sessionUtilisateur.getInfos();
                    Matcher m = imagePattern.matcher(content);
                    while (m.find()) {
                        infosSession.put(m.group(1), -1);
                    }
                    String replacePattern = "src=\"(http://)*([a-zA-Z0-9:]+)*(/servlet/com.univ.utils.LectureImageToolbox\\?TAG=)*\\[id-image\\]";
                    currentField.set(card, StringUtils.replacePattern((String)content, (String)"src=\"(http://)*([a-zA-Z0-9:]+)*(/servlet/com.univ.utils.LectureImageToolbox\\?TAG=)*\\[id-image\\]", (String)"src=\"/servlet/com.univ.utils.LectureImageToolbox?TAG=[id-image]"));
                }
                catch (IllegalAccessException e) {
                    LOG.error(String.format("An error occured trying to handle card %s", card.toString()), (Throwable)e);
                }
            }
        }
    }

    private String getContent(Field currentField, CardBean card) throws IllegalAccessException {
        MediaContent contentType = currentField.getAnnotation(MediaContent.class);
        if (contentType.type() == 1) {
            currentField.setAccessible(true);
            return (String)currentField.get(card);
        }
        return "";
    }

    @Override
    protected int handleModel(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas, int startIndex) {
        int index = startIndex;
        for (CardBean currentCard : inputedModel.values()) {
            Collection<Field> annotatedFields = this.getAnnotatedFields(currentCard);
            for (Field currentField : annotatedFields) {
                MediaContent contentType = currentField.getAnnotation(MediaContent.class);
                if (contentType.type() != 1) continue;
                try {
                    currentField.setAccessible(true);
                    CardBean recordedCard = this.getRecordedCard(currentCard);
                    Set<String> newResources = this.findResources(currentField, currentCard);
                    HashSet<String> oldResources = new HashSet<String>();
                    if (recordedCard != null) {
                        oldResources.addAll(this.findResources(currentField, recordedCard));
                        oldResources.removeAll(newResources);
                    }
                    datas.put("contentNewRessources", newResources);
                    datas.put("contentOldResources", oldResources);
                    try {
                        ContexteDao ctx = new ContexteDao();
                        Throwable throwable = null;
                        try {
                            Ressource.saveContentRessource(ctx, datas, ficheUniv);
                            index += newResources.size();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ctx == null) continue;
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ctx.close();
                        }
                    }
                    catch (Exception e) {
                        LOG.error(String.format("An error occurred trying to create ressource for toolbox on card %s", currentCard.toString()), (Throwable)e);
                    }
                }
                catch (IllegalAccessException e) {
                    LOG.error(String.format("An error occurred trying to handle card %s", currentCard.toString()), (Throwable)e);
                }
            }
        }
        return index;
    }

    private CardBean getRecordedCard(CardBean card) {
        CardBean recordedCard;
        try {
            recordedCard = (CardBean)this.cardDao.getById(card.getId());
        }
        catch (DataSourceException e) {
            return null;
        }
        return recordedCard;
    }

    private Set<String> findResources(Field field, CardBean card) throws IllegalAccessException {
        String content = (String)field.get(card);
        HashSet<String> newResources = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            Matcher linkMatcher = linkPattern.matcher(content);
            Matcher imageMatcher = imagePattern.matcher(content);
            while (imageMatcher.find()) {
                newResources.add(String.format("%s#IMG", imageMatcher.group(2)));
            }
            while (linkMatcher.find()) {
                newResources.add(String.format("%s#LIEN", linkMatcher.group(1)));
            }
        }
        return newResources;
    }
}

