/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.dao;

import com.jsbsoft.jtf.datasource.dao.impl.mysql.AbstractCommonDAO;
import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.kosmos.layout.Layout;
import com.kosmos.layout.impl.AbstractLayout;
import com.kosmos.layout.slot.util.SlotList;
import com.kosmos.layout.utils.LayoutJacksonMapper;
import com.univ.utils.json.Views;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class LayoutDAO
extends AbstractCommonDAO<Layout> {
    public LayoutDAO() {
        this.tableName = "LAYOUT";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Layout add(Layout layout) throws AddToDataSourceException {
        ResultSet rs = null;
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement("insert into LAYOUT (NAME_LAYOUT, HAS_CONTEXT_LAYOUT, DESCRIPTION_LAYOUT, SLOTS_LAYOUT, DATAS_LAYOUT) values (?, ?, ?, ?, ?)", 1);){
                String datas = LayoutJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)layout);
                stmt.setString(1, layout.getName());
                stmt.setBoolean(2, layout.hasContext());
                stmt.setString(3, layout.getDescription());
                stmt.setString(4, LayoutJacksonMapper.getMapper().writeValueAsString((Object)layout.getSlots()));
                stmt.setString(5, datas);
                int rowsAffected = stmt.executeUpdate();
                if (rowsAffected != 1) {
                    throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\" : %d row(s) affected", layout.toString(), this.tableName, rowsAffected));
                }
                rs = stmt.getGeneratedKeys();
                rs.next();
                layout.setId(rs.getLong(1));
            }
            if (rs == null) return layout;
        }
        catch (Exception e) {
            try {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"%s\"", layout.toString(), this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occurred closing Resultset during add() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return layout;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occurred closing Resultset during add() on table %s", this.tableName), (Throwable)e);
            return layout;
        }
    }

    @Override
    public Layout update(Layout layout) throws UpdateToDataSourceException {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update LAYOUT set DESCRIPTION_LAYOUT = ?, HAS_CONTEXT_LAYOUT = ?, SLOTS_LAYOUT = ?, DATAS_LAYOUT = ?  WHERE NAME_LAYOUT = ?");){
            String datas = LayoutJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)layout);
            stmt.setString(1, layout.getDescription());
            stmt.setBoolean(2, layout.hasContext());
            stmt.setString(3, LayoutJacksonMapper.getMapper().writeValueAsString((Object)layout.getSlots()));
            stmt.setString(4, datas);
            stmt.setString(5, layout.getName());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"%s\"", layout.toString(), this.tableName), e);
        }
        return layout;
    }

    @Override
    protected Layout fill(ResultSet rs) throws DataSourceException {
        AbstractLayout layout = null;
        try {
            layout = (AbstractLayout)LayoutJacksonMapper.getMapper().readValue(rs.getString("DATAS_LAYOUT"), AbstractLayout.class);
            layout.setSlots((SlotList)LayoutJacksonMapper.getMapper().readValue(rs.getString("SLOTS_LAYOUT"), SlotList.class));
            layout.setId(rs.getLong("ID_LAYOUT"));
            layout.setName(rs.getString("NAME_LAYOUT"));
            layout.setDescription(rs.getString("DESCRIPTION_LAYOUT"));
            layout.setContext(rs.getBoolean("HAS_CONTEXT_LAYOUT"));
        }
        catch (Exception e) {
            LOG.error("An error occurred trying to map layout bean", (Throwable)e);
        }
        return layout;
    }

    /*
     * Exception decompiling
     */
    public Layout getByName(String name) throws DataSourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Layout> getAllLayouts() throws DataSourceException {
        ResultSet rs = null;
        ArrayList<Layout> layouts = new ArrayList<Layout>();
        try {
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement stmt = connection.prepareStatement(String.format("select * from `%s`", this.tableName));){
                rs = stmt.executeQuery();
                while (rs.next()) {
                    layouts.add(this.fill(rs));
                }
            }
            if (rs == null) return layouts;
        }
        catch (SQLException e) {
            try {
                throw new DataSourceException(String.format("An error occurred retrieving objects from table %s", this.tableName), e);
            }
            catch (Throwable throwable) {
                if (rs == null) throw throwable;
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException e2) {
                    LOG.error(String.format("An error occurred closing ResultSet during getAllLayouts() on table %s", this.tableName), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            rs.close();
            return layouts;
        }
        catch (SQLException e) {
            LOG.error(String.format("An error occurred closing ResultSet during getAllLayouts() on table %s", this.tableName), (Throwable)e);
            return layouts;
        }
    }
}

