/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.grid.service;

import com.kosmos.layout.exception.DefaultLayoutNotFoundException;
import com.kosmos.layout.exception.GridNotFoundException;
import com.kosmos.layout.exception.LayoutNotFoundException;
import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.grid.managers.GridManager;
import com.kosmos.layout.service.ServiceLayout;
import com.univ.objetspartages.om.FicheUniv;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ServiceGrid {
    public static final String ID_BEAN = "serviceGrid";
    private ServiceLayout serviceLayout;

    public void setServiceLayout(ServiceLayout serviceLayout) {
        this.serviceLayout = serviceLayout;
    }

    public Collection<GridManager> getGridManagers() {
        return this.serviceLayout.getLayoutManagers(GridManager.class);
    }

    public Map<String, GridLayout> getAvailableGrids() {
        HashMap<String, GridLayout> availableGrids = new HashMap<String, GridLayout>();
        Collection<GridManager> gridManagers = this.serviceLayout.getLayoutManagers(GridManager.class);
        for (GridManager currentGridManager : gridManagers) {
            availableGrids.putAll(currentGridManager.getAvailableGrids());
        }
        return availableGrids;
    }

    public GridLayout getGrid(FicheUniv fiche) throws GridNotFoundException {
        try {
            GridLayout gridLayout = (GridLayout)this.serviceLayout.getLayout(fiche);
            if (gridLayout != null) {
                return gridLayout;
            }
        }
        catch (DefaultLayoutNotFoundException | LayoutNotFoundException erreurApplicative) {
            // empty catch block
        }
        return this.getDefaultGrid(fiche);
    }

    public GridLayout getGrid(String name) throws GridNotFoundException {
        GridManager currentGridManager;
        GridLayout foundGrid = null;
        Collection<GridManager> gridManagers = this.serviceLayout.getLayoutManagers(GridManager.class);
        Iterator<GridManager> iterator = gridManagers.iterator();
        while (iterator.hasNext() && (foundGrid = (GridLayout)(currentGridManager = iterator.next()).getGridByName(name)) == null) {
        }
        if (foundGrid == null) {
            throw new GridNotFoundException(String.format("La grille portant le nom \"%s\" n'a pas \u00e9t\u00e9 trouv\u00e9.", name));
        }
        return foundGrid;
    }

    public GridLayout getDefaultGrid(FicheUniv fiche) throws GridNotFoundException {
        return this.getDefaultGrid(fiche.getClass().getName());
    }

    public GridLayout getDefaultGrid(String classFiche) throws GridNotFoundException {
        String defaultId = this.serviceLayout.getDefaultLayouts().get(classFiche);
        if (StringUtils.isNotBlank((CharSequence)defaultId)) {
            return this.getGrid(defaultId);
        }
        throw new GridNotFoundException(String.format("La grille par d\u00e9faut pour les fiches de type \"%s\" n'a pas \u00e9t\u00e9 trouv\u00e9.", classFiche));
    }
}

