/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.manager.impl;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.kosmos.layout.Layout;
import com.kosmos.layout.dao.LayoutDAO;
import com.kosmos.layout.manager.LayoutManager;
import com.kportal.extension.module.AbstractBeanManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutManager<T extends Layout>
extends AbstractBeanManager
implements LayoutManager<T> {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractLayoutManager.class);
    private Class<T> actualClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private LayoutDAO layoutDao;
    private String id;
    private String name;
    private Map<String, T> layouts = new HashMap<String, T>();

    public void setLayoutDao(LayoutDAO layoutDao) {
        this.layoutDao = layoutDao;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, T> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(Map<String, T> layouts) {
        this.layouts = layouts;
    }

    @Override
    public void refresh() {
        Collection<T> beans = ApplicationContextManager.getAllBeansOfType(this.actualClass).values();
        for (Layout currentLayout : beans) {
            try {
                Layout layout = this.layoutDao.getByName(currentLayout.getName());
                if (layout != null) {
                    if (this.actualClass.isInstance(layout)) {
                        BeanUtils.copyProperties((Object)layout, (Object)currentLayout);
                        this.layouts.put(layout.getName(), this.layoutDao.update(layout));
                        continue;
                    }
                    this.layoutDao.delete(layout.getId());
                    this.layouts.put(currentLayout.getName(), this.layoutDao.add(currentLayout));
                    continue;
                }
                this.layouts.put(currentLayout.getName(), this.layoutDao.add(currentLayout));
            }
            catch (DataSourceException e) {
                LOG.error(String.format("An error occurred trying to persist layout with name %s", currentLayout.getName()), (Throwable)e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error(String.format("An error occurred trying to update layout with name %s", currentLayout.getName()), (Throwable)e);
            }
        }
    }
}

