/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.plugin;

import com.kosmos.layout.Layout;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.card.service.ServiceCard;
import com.kosmos.layout.content.ContentHandler;
import com.kosmos.layout.content.manager.ContentHandlerManager;
import com.kosmos.layout.plugin.LayoutFichePluginHelper;
import com.kosmos.layout.service.ServiceLayout;
import com.kportal.core.context.BeanUtil;
import com.kportal.extension.module.plugin.objetspartages.DefaultPluginFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.utils.ContexteUtil;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutFichePlugin
extends DefaultPluginFiche {
    public static final Logger LOG = LoggerFactory.getLogger(LayoutFichePlugin.class);
    private ContentHandlerManager contentHandlerManager;
    private ServiceCard serviceCard;
    private ServiceLayout serviceLayout;

    public void setContentHandlerManager(ContentHandlerManager contentHandlerManager) {
        this.contentHandlerManager = contentHandlerManager;
    }

    public void setServiceCard(ServiceCard serviceCard) {
        this.serviceCard = serviceCard;
    }

    public void setServiceLayout(ServiceLayout serviceLayout) {
        this.serviceLayout = serviceLayout;
    }

    @Override
    public void supprimerObjets(FicheUniv ficheUniv, Metatag meta, String classeObjetCible) throws Exception {
        Map<String, CardBean> cardModel = this.serviceCard.getCards(meta.getIdMetatag());
        for (CardBean currentCard : cardModel.values()) {
            this.serviceCard.deleteCardForMeta(currentCard, meta);
        }
        this.serviceLayout.deleteLayoutForMeta(meta.getIdMetatag());
    }

    @Override
    public void preparerPrincipal(Map<String, Object> datas, FicheUniv ficheUniv, Metatag meta) throws Exception {
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv);
    }

    @Override
    public void traiterPrincipal(Map<String, Object> datas, FicheUniv ficheUniv, Metatag meta) throws Exception {
        Long idFiche = Long.valueOf((String)StringUtils.defaultIfBlank((CharSequence)((String)datas.get("ID_FICHE")), (CharSequence)"0"));
        Long layoutId = Long.valueOf((String)StringUtils.defaultIfBlank((CharSequence)((String)datas.get("ID_LAYOUT")), (CharSequence)"0"));
        if (layoutId != 0L) {
            Layout layout = this.serviceLayout.getLayout(layoutId);
            this.serviceLayout.addLayoutForMeta(layout, meta.getIdMetatag());
            boolean resetModelIds = !Objects.equals(ficheUniv.getIdFiche(), idFiche);
            Map<String, CardBean> inputedModel = LayoutFichePluginHelper.retrieveModelFromDatas(datas, layout, resetModelIds);
            try {
                this.serviceCard.cleanUpModel(ficheUniv, inputedModel);
            }
            catch (Exception e) {
                LOG.warn("An error occurred trying to clean up recorded model.", (Throwable)e);
            }
            this.handleContent(inputedModel, ficheUniv, datas);
            for (Map.Entry<String, CardBean> currentEntry : inputedModel.entrySet()) {
                this.serviceCard.addCardForMeta(currentEntry.getValue(), meta);
            }
        }
    }

    private void handleContent(Map<String, CardBean> inputedModel, FicheUniv ficheUniv, Map<String, Object> datas) {
        int startIndex = 0;
        for (ContentHandler currentHandler : this.contentHandlerManager.getContentHandlers()) {
            startIndex += currentHandler.handleContent(inputedModel, ficheUniv, datas, startIndex);
        }
    }

    @Override
    public void setDataContexteUniv(FicheUniv ficheUniv, Metatag meta, String classeObjet) throws Exception {
        LayoutFichePluginHelper.prepareFoDatas(ContexteUtil.getContexteUniv().getDatas(), ficheUniv);
    }

    @Override
    public Object getDataContexteUniv() {
        return ContexteUtil.getContexteUniv().getData(BeanUtil.getBeanKey(this.getId(), this.getIdExtension()));
    }
}

