/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.plugin;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.kosmos.layout.Layout;
import com.kosmos.layout.card.bean.CardBean;
import com.kosmos.layout.card.service.ServiceCard;
import com.kosmos.layout.card.util.CardList;
import com.kosmos.layout.card.util.CardUtil;
import com.kosmos.layout.card.view.model.CardViewModel;
import com.kosmos.layout.content.ContentHandler;
import com.kosmos.layout.content.manager.ContentHandlerManager;
import com.kosmos.layout.service.ServiceLayout;
import com.kosmos.layout.slot.Slot;
import com.kosmos.layout.slot.util.SlotState;
import com.kosmos.layout.slot.view.model.SlotViewModel;
import com.kosmos.layout.utils.LayoutJacksonMapper;
import com.kosmos.layout.view.model.LayoutManagerViewModel;
import com.kosmos.layout.view.model.LayoutViewModel;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.utils.EscapeString;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutFichePluginHelper {
    public static final Logger LOG = LoggerFactory.getLogger(LayoutFichePluginHelper.class);
    public static final String LAYOUT_VIEW_MODEL = "LAYOUT_VIEW_MODEL";
    public static final String LAYOUT_MANAGER_VIEW_MODEL = "LAYOUT_MANAGER_VIEW_MODEL";
    public static final String CARD_VIEW_MODEL = "CARD_VIEW_MODEL";
    public static final String SLOT_VIEW_MODEL = "SLOT_VIEW_MODEL";
    private static ContentHandlerManager contentHandlerManager = (ContentHandlerManager)ApplicationContextManager.getBean("core", "contentHandlerManager");
    private static ServiceCard serviceCard = (ServiceCard)ApplicationContextManager.getBean("core", "serviceCard");
    private static ServiceLayout serviceLayout = (ServiceLayout)ApplicationContextManager.getBean("core", "serviceLayout");

    public static void prepareBoDatas(Map<String, Object> datas, FicheUniv ficheUniv) throws Exception {
        Layout layout = serviceLayout.getLayout(ficheUniv);
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv, layout);
    }

    public static void prepareBoDatas(Map<String, Object> datas, FicheUniv ficheUniv, Long layoutId) throws Exception {
        Layout layout = serviceLayout.getLayout(layoutId);
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv, layout);
    }

    public static void prepareBoDatas(Map<String, Object> data, FicheUniv ficheUniv, Layout layout) throws Exception {
        if (layout != null) {
            Map<String, CardBean> cardModel = serviceCard.getCards(ficheUniv);
            LayoutFichePluginHelper.prepareBoDatas(data, ficheUniv, layout, cardModel);
        }
    }

    public static void prepareBoDatas(Map<String, Object> datas, FicheUniv ficheUniv, Layout layout, Map<String, CardBean> cardModel) throws Exception {
        if (layout != null) {
            LayoutFichePluginHelper.prepareContent(cardModel, ficheUniv, datas);
            serviceCard.updateCardModel(cardModel);
            LayoutFichePluginHelper.assertModelConsistency(layout, cardModel);
            LayoutViewModel layoutViewModel = LayoutFichePluginHelper.prepareLayoutViewModel(layout, cardModel);
            LayoutManagerViewModel layoutManagerViewModel = LayoutFichePluginHelper.prepareLayoutManagerViewModel(layout);
            layoutManagerViewModel.setLayoutViewModel(layoutViewModel);
            datas.put(LAYOUT_MANAGER_VIEW_MODEL, layoutManagerViewModel);
        }
    }

    protected static void prepareFoDatas(Map<String, Object> datas, FicheUniv ficheUniv) throws Exception {
        Layout layout = serviceLayout.getLayout(ficheUniv);
        if (layout != null) {
            Map<String, CardBean> cardModel = serviceCard.getCards(ficheUniv);
            LayoutFichePluginHelper.prepareContent(cardModel, ficheUniv, datas);
            serviceCard.updateCardModel(cardModel);
            LayoutFichePluginHelper.assertModelConsistency(layout, cardModel);
            LayoutViewModel layoutViewModel = LayoutFichePluginHelper.prepareLayoutViewModel(layout, cardModel);
            datas.put(LAYOUT_VIEW_MODEL, layoutViewModel);
        }
    }

    private static LayoutManagerViewModel prepareLayoutManagerViewModel(Layout layout) throws Exception {
        LayoutManagerViewModel layoutManagerViewModel = new LayoutManagerViewModel();
        Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes = serviceCard.getAllowedCardTypes(layout);
        CardList cardPool = serviceCard.getAllowedCardsPool(allowedCardTypes);
        String jsonCardPool = LayoutJacksonMapper.getMapper().writeValueAsString((Object)cardPool);
        layoutManagerViewModel.setCardBoViewPool(serviceCard.getAllowedCardBoView(allowedCardTypes));
        layoutManagerViewModel.setAvailableLayouts(serviceLayout.getAvailableLayouts());
        layoutManagerViewModel.setCardsPool(EscapeString.escapeAttributHtml(jsonCardPool));
        layoutManagerViewModel.setEditFragments(serviceCard.getAllowedEditFragments(cardPool));
        layoutManagerViewModel.setCardsDescriptions(serviceCard.getAllowedCardsDescriptions(layout));
        layoutManagerViewModel.setAllowedCardTypes(allowedCardTypes);
        return layoutManagerViewModel;
    }

    private static LayoutViewModel prepareLayoutViewModel(Layout layout, Map<String, CardBean> cardModel) throws Exception {
        LayoutViewModel layoutViewModel = new LayoutViewModel();
        layoutViewModel.setLayout(layout);
        layoutViewModel.setSlotViewModels(LayoutFichePluginHelper.prepareSlotViewModels(layout, cardModel));
        return layoutViewModel;
    }

    private static Map<String, SlotViewModel> prepareSlotViewModels(Layout layout, Map<String, CardBean> cards) throws Exception {
        HashMap<String, SlotViewModel> slotViewModels = new HashMap<String, SlotViewModel>();
        Map<String, Collection<Class<? extends CardBean>>> allowedCardTypes = serviceCard.getAllowedCardTypes(layout);
        for (Slot currentSlot : layout.getSlots()) {
            String currentKey = currentSlot.getKey().toString();
            SlotViewModel currentSlotViewModel = new SlotViewModel();
            String jsonAllowedCardTypes = LayoutJacksonMapper.getMapper().writeValueAsString(allowedCardTypes.get(currentKey));
            CardViewModel cardViewModel = LayoutFichePluginHelper.prepareCardViewModel(cards.get(currentKey));
            currentSlot.setState(cardViewModel.getCardBean() == null ? SlotState.EMPTY : SlotState.FILLED);
            currentSlotViewModel.setSlot(currentSlot);
            currentSlotViewModel.setAllowedCardTypes(EscapeString.escapeAttributHtml(jsonAllowedCardTypes));
            currentSlotViewModel.setCardViewModel(cardViewModel);
            slotViewModels.put(currentKey, currentSlotViewModel);
        }
        return slotViewModels;
    }

    private static CardViewModel prepareCardViewModel(CardBean card) {
        CardViewModel cardViewModel = new CardViewModel();
        String jsonCardModel = "";
        try {
            jsonCardModel = (String)StringUtils.defaultIfBlank((CharSequence)CardUtil.getJsonModel(card), (CharSequence)"");
        }
        catch (IOException e) {
            LOG.error(String.format("Une erreur est survenue lors de la s\u00e9rialisation de la carte %s", card.getKey()), (Throwable)e);
        }
        cardViewModel.setCardBean(card);
        cardViewModel.setJsonCard(jsonCardModel);
        return cardViewModel;
    }

    private static void assertModelConsistency(Layout layout, Map<String, CardBean> cardModel) {
        for (Slot currentSlot : layout.getSlots()) {
            String currentKey = currentSlot.getKey().toString();
            if (!cardModel.containsKey(currentKey)) continue;
            CardBean currentCard = cardModel.get(currentKey);
            if (!CollectionUtils.isNotEmpty(currentSlot.getAllowedCardTypes()) || currentSlot.getAllowedCardTypes().contains(currentCard.getClass())) continue;
            cardModel.remove(currentKey);
        }
    }

    private static void prepareContent(Map<String, CardBean> cards, FicheUniv ficheUniv, Map<String, Object> datas) {
        for (ContentHandler currentHandler : contentHandlerManager.getContentHandlers()) {
            currentHandler.prepareContent(cards, ficheUniv, datas);
        }
    }

    public static Map<String, CardBean> retrieveModelFromDatas(Map<String, Object> datas, Layout layout, boolean resetIds) {
        HashMap<String, CardBean> inputedModel = new HashMap<String, CardBean>();
        for (Slot currentSlot : layout.getSlots()) {
            String currentModel = (String)datas.get(String.format("jsonModel-%s", currentSlot.getKey().toString()));
            if (!StringUtils.isNotBlank((CharSequence)currentModel)) continue;
            try {
                CardBean currentInputedCard = CardUtil.getCardFromJson(currentModel);
                if (resetIds) {
                    currentInputedCard.setId(null);
                }
                inputedModel.put(currentInputedCard.getKey().toString(), currentInputedCard);
            }
            catch (IOException e) {
                LOG.error(String.format("Une erreur est survenue lors de la r\u00e9cup\u00e9ration de la carte depuis le json \"%s\"", currentModel), (Throwable)e);
            }
        }
        return inputedModel;
    }

    public static void propagateInputedModel(Map<String, Object> datas, Long layoutId) throws Exception {
        Layout layout = serviceLayout.getLayout(layoutId);
        Map<String, CardBean> cardModel = LayoutFichePluginHelper.retrieveModelFromDatas(datas, layout, false);
        LayoutViewModel layoutViewModel = LayoutFichePluginHelper.prepareLayoutViewModel(layout, cardModel);
        LayoutManagerViewModel layoutManagerViewModel = LayoutFichePluginHelper.prepareLayoutManagerViewModel(layout);
        layoutManagerViewModel.setLayoutViewModel(layoutViewModel);
        datas.put(LAYOUT_MANAGER_VIEW_MODEL, layoutManagerViewModel);
    }
}

