/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.plugin;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.kosmos.layout.card.service.ServiceCard;
import com.kosmos.layout.plugin.LayoutFichePluginHelper;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.plugin.objetspartages.DefaultPluginSaisieFiche;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutSaisieFichePlugin
extends DefaultPluginSaisieFiche {
    public static final Logger LOG = LoggerFactory.getLogger(ServiceCard.class);
    private List<String> classes;

    public List<String> getClasses() {
        return this.classes;
    }

    public void setClasses(List<String> classes) {
        this.classes = classes;
    }

    @Override
    public void traiterAction(Map<String, Object> datas, FicheUniv ficheUniv, Metatag meta) throws Exception {
        if (this.isActive(ficheUniv.getClass().getName())) {
            String action = (String)datas.get("ACTION");
            if ("CHANGER_LAYOUT".equals(action)) {
                this.changeLayout(datas, ficheUniv);
            } else if ("ONGLET".equals(action)) {
                Long layoutId;
                Long l = layoutId = StringUtils.isNumeric((CharSequence)((String)datas.get("ID_LAYOUT"))) ? Long.valueOf(Long.parseLong((String)datas.get("ID_LAYOUT"))) : null;
                if (layoutId != null) {
                    LayoutFichePluginHelper.propagateInputedModel(datas, layoutId);
                }
            }
        }
    }

    private void changeLayout(Map<String, Object> datas, FicheUniv ficheUniv) throws Exception {
        Long idFiche = new Long((String)datas.get("ID_FICHE"));
        if (idFiche != 0L) {
            try {
                ficheUniv.setIdFiche(idFiche);
                ficheUniv.retrieve();
            }
            catch (Exception e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_FICHE_INEXISTANTE"));
            }
        }
        Long layoutId = Long.valueOf((String)StringUtils.defaultIfBlank((CharSequence)((String)datas.get("ID_LAYOUT")), (CharSequence)"0"));
        LayoutFichePluginHelper.prepareBoDatas(datas, ficheUniv, layoutId);
    }

    public boolean isActive(String classe) {
        if (this.classes == null) {
            return Boolean.TRUE;
        }
        if (this.classes.contains(classe)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

