/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.service;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.kosmos.layout.Layout;
import com.kosmos.layout.dao.LayoutDAO;
import com.kosmos.layout.exception.DefaultLayoutNotFoundException;
import com.kosmos.layout.exception.LayoutNotFoundException;
import com.kosmos.layout.manager.LayoutManager;
import com.kosmos.layout.meta.bean.LayoutMetaBean;
import com.kosmos.layout.meta.dao.LayoutMetaDAO;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.AbstractBeanManager;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.Metatag;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.utils.FicheUnivMgr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceLayout
extends AbstractBeanManager {
    public static final String ID_BEAN = "serviceLayout";
    private final Map<Class<?>, LayoutManager> layoutManagers = new HashMap();
    private LayoutDAO layoutDao;
    private LayoutMetaDAO layoutMetaDao;
    private Map<String, String> defaultLayouts = new HashMap<String, String>();

    public LayoutMetaDAO getLayoutMetaDao() {
        return this.layoutMetaDao;
    }

    public void setLayoutMetaDao(LayoutMetaDAO layoutMetaDao) {
        this.layoutMetaDao = layoutMetaDao;
    }

    public LayoutDAO getLayoutDao() {
        return this.layoutDao;
    }

    public void setLayoutDao(LayoutDAO layoutDao) {
        this.layoutDao = layoutDao;
    }

    public Map<String, String> getDefaultLayouts() {
        return this.defaultLayouts;
    }

    public void setDefaultLayouts(Map<String, String> defaultLayouts) {
        this.defaultLayouts = defaultLayouts;
    }

    @Override
    public void refresh() {
        Collection<LayoutManager> managers = ApplicationContextManager.getAllBeansOfType(LayoutManager.class).values();
        for (LayoutManager currentManager : managers) {
            this.layoutManagers.put(currentManager.getClass(), currentManager);
        }
    }

    public Collection<Layout> getAvailableLayouts() {
        try {
            return this.layoutDao.getAllLayouts();
        }
        catch (DataSourceException e) {
            return null;
        }
    }

    public Layout getLayout(Long layoutId) throws LayoutNotFoundException {
        try {
            Layout layout = (Layout)this.layoutDao.getById(layoutId);
            if (layout == null) {
                throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_ID"), layoutId));
            }
            return layout;
        }
        catch (DataSourceException e) {
            throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_ID"), layoutId), e);
        }
    }

    public Layout getLayout(String layoutName) throws LayoutNotFoundException {
        if (StringUtils.isNotBlank((CharSequence)layoutName)) {
            try {
                return this.layoutDao.getByName(layoutName);
            }
            catch (DataSourceException e) {
                throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_NAME"), layoutName), e);
            }
        }
        return null;
    }

    public Layout getLayout(FicheUniv fiche) throws DefaultLayoutNotFoundException, LayoutNotFoundException {
        Metatag meta;
        try {
            meta = FicheUnivMgr.lireMeta(fiche);
        }
        catch (Exception e) {
            throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_FICHE"), fiche.getCode()), e);
        }
        try {
            Layout layout = this.getLayoutForMeta(meta.getIdMetatag());
            return layout;
        }
        catch (LayoutNotFoundException e) {
            String classObject = ReferentielObjets.getClasseObjet(ReferentielObjets.getCodeObjet(fiche));
            String defaultLayout = this.defaultLayouts.get(classObject);
            Layout layout = this.getLayout(defaultLayout);
            if (layout == null) {
                throw new DefaultLayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.DEFAULT_NOT_FOUND"), classObject));
            }
            return layout;
        }
    }

    public Layout getLayoutForMeta(Long metaId) throws LayoutNotFoundException {
        try {
            LayoutMetaBean layoutMeta = this.layoutMetaDao.getByMetaId(metaId);
            if (layoutMeta != null) {
                return (Layout)this.layoutDao.getById(layoutMeta.getIdLayout());
            }
        }
        catch (DataSourceException e) {
            throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_META_ID"), metaId), e);
        }
        throw new LayoutNotFoundException(String.format(MessageHelper.getCoreMessage("BO.LAYOUT.EXCEPTION.NOT_FOUND_META_ID"), metaId));
    }

    public void addLayoutForMeta(Layout layout, Long metaId) throws DataSourceException {
        LayoutMetaBean layoutMeta = this.layoutMetaDao.getByMetaId(metaId);
        if (layoutMeta != null) {
            layoutMeta.setIdLayout(layout.getId());
            this.layoutMetaDao.update(layoutMeta);
        } else {
            layoutMeta = new LayoutMetaBean();
            layoutMeta.setIdLayout(layout.getId());
            layoutMeta.setIdMeta(metaId);
            this.layoutMetaDao.add(layoutMeta);
        }
    }

    public void deleteLayoutForMeta(Long metaId) throws DataSourceException {
        LayoutMetaBean layoutMeta = this.layoutMetaDao.getByMetaId(metaId);
        this.layoutMetaDao.delete(layoutMeta.getId());
    }

    public <T extends LayoutManager> Collection<T> getLayoutManagers(Class<T> managerClass) {
        ArrayList<T> managers = new ArrayList<T>();
        for (Map.Entry<Class<?>, LayoutManager> currentEntry : this.layoutManagers.entrySet()) {
            if (!ClassUtils.isAssignable(currentEntry.getKey(), managerClass)) continue;
            managers.add(managerClass.cast(currentEntry.getValue()));
        }
        return managers;
    }
}

