/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.slot.util;

import com.kosmos.layout.grid.GridLayout;
import com.kosmos.layout.slot.Slot;
import com.kosmos.layout.slot.impl.GridSlot;

public class GridSlotUtil {
    public static String getSlotKey(GridLayout grid, int row, int column) {
        for (Slot currentSlot : grid.getSlots()) {
            GridSlot gridSlot = (GridSlot)currentSlot;
            if (gridSlot.getRow() != row || gridSlot.getColumn() != column) continue;
            return gridSlot.getKey().toString();
        }
        return null;
    }

    public static String getClassName(GridSlot gridSlot) {
        if (gridSlot != null) {
            String classColSpan = gridSlot.getColSpan() > 1 ? String.format("layout__slot--columnspan%d", gridSlot.getColSpan()) : "";
            String classRowSpan = gridSlot.getRowSpan() > 1 ? String.format("layout__slot--rowspan%d", gridSlot.getRowSpan()) : "";
            String position = String.format("layout__slot--%dx%d", gridSlot.getRow(), gridSlot.getColumn());
            return String.format("%s %s %s", classColSpan, classRowSpan, position);
        }
        return "";
    }
}

