/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.layout.tag;

import com.jsbsoft.jtf.core.InfoBean;
import com.kportal.extension.ExtensionHelper;
import com.kportal.frontoffice.util.JSPIncludeHelper;
import com.univ.utils.ContexteUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutTag<T>
extends TagSupport
implements TryCatchFinally {
    public static final Logger LOG = LoggerFactory.getLogger(AbstractLayoutTag.class);
    public static final String ID_EXTENSION = "idExtension";
    public static final String VIEW_MODEL = "viewModel";
    protected String retrieveKey;
    protected T viewModel;
    protected boolean front = false;
    protected String extension;

    public void setViewModel(T viewModel) {
        this.viewModel = viewModel;
    }

    public void setFront(boolean front) {
        this.front = front;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public int doStartTag() throws JspException {
        if (this.viewModel == null) {
            this.viewModel = this.retrieveDataFromContext(this.retrieveKey);
        }
        this.pageContext.getRequest().setAttribute(VIEW_MODEL, this.viewModel);
        this.pageContext.getRequest().setAttribute(ID_EXTENSION, (Object)this.extension);
        return 0;
    }

    protected void includeJSP(String path) {
        String templatedPath = path;
        if (StringUtils.isNotBlank((CharSequence)templatedPath)) {
            if (StringUtils.isNotBlank((CharSequence)this.extension)) {
                templatedPath = ExtensionHelper.getTemplateExtension(this.extension, path, this.front);
            }
            JSPIncludeHelper.includeJsp(this.pageContext.getOut(), this.pageContext.getServletContext(), (HttpServletRequest)this.pageContext.getRequest(), (HttpServletResponse)this.pageContext.getResponse(), templatedPath);
        }
    }

    protected InfoBean retrieveInfoBean() {
        Object test = this.pageContext.getRequest().getAttribute("infoBean");
        if (test != null && test instanceof InfoBean) {
            return (InfoBean)test;
        }
        return null;
    }

    protected T retrieveDataFromContext(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            if (this.front) {
                return (T)ContexteUtil.getContexteUniv().getData(key);
            }
            InfoBean infoBean = this.retrieveInfoBean();
            if (infoBean != null) {
                return (T)infoBean.get(key);
            }
        }
        return null;
    }

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.viewModel = null;
    }
}

