/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.plansite;

import com.univ.objetspartages.om.InfosRubriques;
import com.univ.utils.ContexteUniv;
import com.univ.utils.UnivWebFmt;
import java.util.Collection;
import java.util.Iterator;

public class PlanSite {
    private ContexteUniv ctx = null;
    private InfosRubriques rubriqueMere = null;
    private int nbNiveaux = 0;

    public PlanSite(ContexteUniv ctx, InfosRubriques rubriqueMere, int nbNiveaux) {
        this.ctx = ctx;
        this.rubriqueMere = rubriqueMere;
        this.nbNiveaux = nbNiveaux;
    }

    public String getPlan() throws Exception {
        return this.buildPlan(this.rubriqueMere, 1);
    }

    private String buildPlan(InfosRubriques rubrique, int niveau) throws Exception {
        StringBuffer sb = new StringBuffer();
        Collection<InfosRubriques> cSousRubriques = rubrique.getListeSousRubriquesFront(this.ctx);
        if (!cSousRubriques.isEmpty()) {
            Iterator<InfosRubriques> it = cSousRubriques.iterator();
            InfosRubriques rubCourante = null;
            sb.append("<ul class=\"plan-site__" + niveau + "\">");
            String urlAccueil = "";
            while (it.hasNext()) {
                rubCourante = it.next();
                if (rubCourante == null) continue;
                sb.append("<li>");
                sb.append("<span class=\"plan-site__rubrique\">");
                urlAccueil = UnivWebFmt.renvoyerUrlAccueilRubrique(this.ctx, rubCourante.getCode());
                if (urlAccueil.length() > 0) {
                    sb.append("<a href=\"" + urlAccueil + "\">");
                }
                sb.append(rubCourante.getIntitule());
                if (urlAccueil.length() > 0) {
                    sb.append("</a>");
                }
                sb.append("</span>");
                if (niveau < this.nbNiveaux || this.nbNiveaux == 0) {
                    sb.append(this.buildPlan(rubCourante, niveau + 1));
                }
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }
}

