/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.adapter.impl;

import com.kosmos.adapter.AbstractMapAdapter;
import com.kosmos.registration.action.Action;
import com.kosmos.registration.action.ActionConfiguration;
import com.kosmos.registration.bean.Model;
import com.kosmos.registration.bean.ModelDescriptor;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.service.impl.ModelService;
import com.kosmos.registration.service.impl.RegistrationService;
import com.kosmos.registration.utils.ModelDescriptorUtils;
import com.kosmos.registration.utils.RegistrationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebRegistrationAdapter
extends AbstractMapAdapter {
    public static final String ID_BEAN = "webAdapter";
    private static final Logger LOG = LoggerFactory.getLogger(WebRegistrationAdapter.class);
    private ModelService modelService;
    private RegistrationService registrationService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void setRegistrationService(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    public Map<String, ActionConfiguration> retrieveActionConfigurationDatas(Map<String, Object> dataSource, String modelDescriptorId) throws Exception {
        ModelDescriptor modelDescriptor = ModelDescriptorUtils.getModelDescriptor(modelDescriptorId);
        if (modelDescriptor == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ActionConfiguration> data = new HashMap<String, ActionConfiguration>();
        for (Map.Entry<String, Action> actionEntry : modelDescriptor.getActions().entrySet()) {
            String actionId = actionEntry.getKey();
            Action action = actionEntry.getValue();
            ActionConfiguration configuration = this.getConfigurationData(dataSource, action);
            data.put(actionId, configuration);
        }
        return data;
    }

    public Map<String, RegistrationData> retrieveCreationData(Map<String, Object> dataSource, Long modelId) throws Exception {
        ModelDescriptor modelDescriptor = this.getModelDescriptorFromModel(modelId);
        if (modelDescriptor == null) {
            return Collections.emptyMap();
        }
        HashMap<String, RegistrationData> data = new HashMap<String, RegistrationData>();
        for (Map.Entry<String, Action> actionEntry : modelDescriptor.getActions().entrySet()) {
            String actionId = actionEntry.getKey();
            Action action = actionEntry.getValue();
            RegistrationData registrationData = this.getRegistrationData(dataSource, action);
            data.put(actionId, registrationData);
        }
        return data;
    }

    public Map<String, RegistrationData> retrieveUpdateData(Map<String, Object> dataSource, Long registrationId) throws Exception {
        Registration registration = this.registrationService.get(registrationId);
        Long modelId = registration.getModelId();
        Model model = this.modelService.get(modelId);
        String modelDescriptorId = model.getModelDescriptorId();
        ModelDescriptor modelDescriptor = ModelDescriptorUtils.getModelDescriptor(modelDescriptorId);
        Map<String, RegistrationData> data = new HashMap<String, RegistrationData>();
        if (registration.getState() == RegistrationState.ERROR || registration.getState() == RegistrationState.WAITING) {
            String lastActionId = RegistrationUtils.getLastActionIdFromHistory(registration);
            if (StringUtils.isNotBlank((CharSequence)lastActionId)) {
                Action action = modelDescriptor.getActions().get(lastActionId);
                registration.getDataByAction().put(lastActionId, this.getRegistrationData(dataSource, action));
                data = registration.getDataByAction();
            }
        } else {
            for (Map.Entry<String, Action> currentAction : modelDescriptor.getActions().entrySet()) {
                RegistrationData registrationData = this.getRegistrationData(dataSource, currentAction.getValue());
                data.put(currentAction.getKey(), registrationData);
            }
        }
        return data;
    }

    private ModelDescriptor getModelDescriptorFromModel(Long modelId) throws Exception {
        Model model = this.modelService.get(modelId);
        if (model == null) {
            return null;
        }
        String modelDescriptorId = model.getModelDescriptorId();
        ModelDescriptor modelDescriptor = ModelDescriptorUtils.getModelDescriptor(modelDescriptorId);
        return modelDescriptor;
    }

    private RegistrationData getRegistrationData(Map<String, Object> dataSource, Action action) {
        Class<RegistrationData> registrationDataType = RegistrationUtils.getActionDataType(action, RegistrationData.class);
        RegistrationData data = null;
        if (registrationDataType != null) {
            data = this.retrieveData(dataSource, registrationDataType);
        } else {
            LOG.error(String.format("Le type de RegistrationData pour l'action %s n'a pas pu \u00eatre r\u00e9solu.", action));
        }
        return data;
    }

    private ActionConfiguration getConfigurationData(Map<String, Object> dataSource, Action action) {
        Class<ActionConfiguration> configurationDataType = RegistrationUtils.getActionDataType(action, ActionConfiguration.class);
        ActionConfiguration data = null;
        if (configurationDataType != null) {
            data = this.retrieveData(dataSource, configurationDataType);
        } else {
            LOG.error(String.format("Le type de ConfigurationData pour l'action %s n'a pas pu \u00eatre r\u00e9solu.", action));
        }
        return data;
    }
}

