/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.dao.impl;

import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DeleteFromDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.kosmos.registration.bean.Model;
import com.kosmos.registration.dao.ModelDao;
import com.kosmos.registration.utils.RegistrationJacksonMapper;
import com.kosmos.registration.wrapper.ActionConfigurationMap;
import com.univ.utils.json.Views;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DefaultModelDao
implements ModelDao {
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Model getById(Long id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("select * from `MODEL` T1 WHERE T1.ID_MODEL = ?", new Object[0]));){
            stmt.setLong(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.first()) {
                    Model model = null;
                    return model;
                }
                Model result = this.fill(rs);
                return result;
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occured retrieving object with id %s from table MODEL", id.toString()), e);
        }
    }

    @Override
    public Collection<Model> getModelByDescriptorID(String modelDescriptorID) {
        ArrayList<Model> result = new ArrayList<Model>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("select * from `MODEL` T1 WHERE T1.MODEL_DESCRIPTOR_ID = ?", new Object[0]));){
            stmt.setString(1, modelDescriptorID);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    result.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occured retrieving object with descriptorID %s from table MODEL", modelDescriptorID), e);
        }
        return result;
    }

    @Override
    public Model add(Model model) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("insert into MODEL (MODEL_DESCRIPTOR_ID, MODEL_DATAS, ACTIONS_CONFIGURATIONS) values (?, ?, ?)", 1);){
            stmt.setString(1, model.getModelDescriptorId());
            stmt.setString(2, RegistrationJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)model));
            stmt.setString(3, this.serializeActionConfigurationMap(model));
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected != 1) {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"MODEL\" : %d row(s) affected", model.toString(), rowsAffected));
            }
            try (ResultSet rs = stmt.getGeneratedKeys();){
                rs.next();
                model.setId(rs.getLong(1));
            }
        }
        catch (Exception e) {
            throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"MODEL\"", model.toString()), e);
        }
        return model;
    }

    private String serializeActionConfigurationMap(Model model) throws IOException {
        ActionConfigurationMap actionMap = new ActionConfigurationMap();
        actionMap.putAll(model.getActionConfigurationById());
        return RegistrationJacksonMapper.getMapper().writeValueAsString((Object)actionMap);
    }

    @Override
    public Model update(Model model) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("update MODEL set MODEL_DESCRIPTOR_ID = ?, MODEL_DATAS = ?, ACTIONS_CONFIGURATIONS = ? WHERE ID_MODEL = ? ", 1);){
            stmt.setString(1, model.getModelDescriptorId());
            stmt.setString(2, RegistrationJacksonMapper.getMapper().writerWithView(Views.DaoView.class).writeValueAsString((Object)model));
            stmt.setString(3, this.serializeActionConfigurationMap(model));
            stmt.setLong(4, model.getId());
            stmt.executeUpdate();
        }
        catch (IOException | SQLException e) {
            throw new UpdateToDataSourceException(String.format("Unable to add [%s] to table \"MODEL\"", model.toString()), e);
        }
        return model;
    }

    @Override
    public void delete(Long id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("delete from MODEL WHERE ID_MODEL = ?");){
            stmt.setObject(1, (Object)id, -5);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DeleteFromDataSourceException(String.format("An error occured during deletion of row with id %d from table \"MODEL\"", id), e);
        }
    }

    @Override
    public List<Model> select(String request) {
        throw new UnsupportedOperationException("This operation can't be performed in this context.");
    }

    private Model fill(ResultSet rs) {
        Model model = new Model();
        try {
            model = (Model)RegistrationJacksonMapper.getMapper().readValue(rs.getString("MODEL_DATAS"), Model.class);
            model.setId(rs.getLong("ID_MODEL"));
            model.setModelDescriptorId(rs.getString("MODEL_DESCRIPTOR_ID"));
            model.setActionConfigurationById((Map)RegistrationJacksonMapper.getMapper().readValue(rs.getString("ACTIONS_CONFIGURATIONS"), ActionConfigurationMap.class));
        }
        catch (SQLException e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"REGISTRATION\"", model.toString()), e);
        }
        catch (IOException e) {
            throw new UpdateToDataSourceException("Unable to map the saved json values", e);
        }
        return model;
    }
}

