/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.dao.impl;

import com.jsbsoft.jtf.datasource.exceptions.AddToDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.DeleteFromDataSourceException;
import com.jsbsoft.jtf.datasource.exceptions.UpdateToDataSourceException;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.dao.RegistrationDao;
import com.kosmos.registration.utils.RegistrationJacksonMapper;
import com.kosmos.registration.wrapper.ActionHistoryByActionID;
import com.kosmos.registration.wrapper.ActionHistoryList;
import com.kosmos.registration.wrapper.RegistrationDataMap;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.JavaType;

public class DefaultRegistrationDao
implements RegistrationDao {
    private DataSource dataSource;

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Registration add(Registration registration) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("INSERT INTO REGISTRATION (MODEL_ID, REGISTRATIONS_DATA_BY_ACTION, ACTION_HISTORY, STATE, CREATION_IDENTITY, CREATION_DATE, LAST_UPDATE_IDENTITY, LAST_UPDATE_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", 1);){
            stmt.setLong(1, registration.getModelId());
            stmt.setString(2, this.serializeDataByAction(registration));
            stmt.setString(3, this.serializeHistory(registration));
            stmt.setString(4, registration.getState().name());
            stmt.setString(5, registration.getCreationIdentity());
            stmt.setTimestamp(6, new Timestamp(registration.getCreationDate().getTime()));
            stmt.setString(7, registration.getLastUpdateIdentity());
            stmt.setTimestamp(8, new Timestamp(registration.getLastUpdateDate().getTime()));
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected != 1) {
                throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"REGISTRATION\" : %d row(s) affected", registration.toString(), rowsAffected));
            }
            try (ResultSet rs = stmt.getGeneratedKeys();){
                rs.next();
                registration.setId(rs.getLong(1));
            }
        }
        catch (IOException | SQLException e) {
            throw new AddToDataSourceException(String.format("Unable to add [%s] to table \"REGISTRATION\"", registration.toString()), e);
        }
        return registration;
    }

    private String serializeDataByAction(Registration registration) throws IOException {
        RegistrationDataMap registrationDataMap = new RegistrationDataMap();
        registrationDataMap.putAll(registration.getDataByAction());
        return RegistrationJacksonMapper.getMapper().writeValueAsString((Object)registrationDataMap);
    }

    private String serializeHistory(Registration registration) throws IOException {
        ActionHistoryList actionHistories = new ActionHistoryList();
        actionHistories.addAll(registration.getActionHistory());
        return RegistrationJacksonMapper.getMapper().writeValueAsString((Object)actionHistories);
    }

    @Override
    public Registration update(Registration registration) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("UPDATE REGISTRATION SET MODEL_ID = ?, REGISTRATIONS_DATA_BY_ACTION = ?, ACTION_HISTORY = ?, STATE = ?, CREATION_IDENTITY = ?, CREATION_DATE= ?, LAST_UPDATE_IDENTITY = ?, LAST_UPDATE_DATE = ? WHERE ID_REGISTRATION = ?");){
            stmt.setString(1, registration.getModelId().toString());
            stmt.setString(2, this.serializeDataByAction(registration));
            stmt.setString(3, this.serializeHistory(registration));
            stmt.setString(4, registration.getState().name());
            stmt.setString(5, registration.getCreationIdentity());
            stmt.setTimestamp(6, new Timestamp(registration.getCreationDate().getTime()));
            stmt.setString(7, registration.getLastUpdateIdentity());
            stmt.setTimestamp(8, new Timestamp(registration.getLastUpdateDate().getTime()));
            stmt.setLong(9, registration.getId());
            stmt.executeUpdate();
        }
        catch (Exception e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"REGISTRATION\"", registration.toString()), e);
        }
        return registration;
    }

    @Override
    public void delete(Long id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("DELETE FROM REGISTRATION WHERE ID_REGISTRATION = ?");){
            stmt.setObject(1, (Object)id, -5);
            int rowsAffected = stmt.executeUpdate();
            if (rowsAffected == 0) {
                throw new DeleteFromDataSourceException(String.format("Table \"REGISTRATION\" doesn't contain any row width id %d", id));
            }
            if (rowsAffected > 1) {
                throw new DeleteFromDataSourceException(String.format("Table \"REGISTRATION\" contains more than one row width id %d", id));
            }
        }
        catch (SQLException e) {
            throw new DeleteFromDataSourceException(String.format("An error occured during deletion of row with id %d from table \"REGISTRATION\"", id), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Registration getById(Long id) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("select * from `REGISTRATION` T1 WHERE T1.ID_REGISTRATION = ?", new Object[0]));){
            stmt.setLong(1, id);
            try (ResultSet rs = stmt.executeQuery();){
                if (!rs.first()) {
                    Registration registration = null;
                    return registration;
                }
                Registration result = this.fill(rs);
                return result;
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occured retrieving object with id %d from table REGISTRATION", id), e);
        }
    }

    @Override
    public Collection<Registration> getByModel(Long modelId) {
        ArrayList<Registration> results = new ArrayList<Registration>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("select * from `REGISTRATION` T1 WHERE T1.MODEL_ID = ?", new Object[0]));){
            stmt.setLong(1, modelId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occured retrieving object with id %s from table REGISTRATION", modelId.toString()), e);
        }
        return results;
    }

    @Override
    public Collection<Registration> getByModelAndState(Long modelId, RegistrationState state) {
        ArrayList<Registration> results = new ArrayList<Registration>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement(String.format("select * from `REGISTRATION` T1 WHERE T1.MODEL_ID = ? AND STATE = ? ", new Object[0]));){
            stmt.setLong(1, modelId);
            stmt.setString(2, state.name());
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    results.add(this.fill(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DataSourceException(String.format("An error occured retrieving object with id %s from table REGISTRATION", modelId.toString()), e);
        }
        return results;
    }

    @Override
    public void deleteByModelId(Long modelId) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement stmt = connection.prepareStatement("DELETE FROM `REGISTRATION` WHERE MODEL_ID = ?");){
            stmt.setLong(1, modelId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new DeleteFromDataSourceException(String.format("An error occured during deletion of row with MODEL_ID %d from table \"REGISTRATION\"", modelId), e);
        }
    }

    @Override
    public List<Registration> select(String request) {
        throw new UnsupportedOperationException("this operation can't be performed in this context.");
    }

    private Registration fill(ResultSet rs) throws UpdateToDataSourceException {
        Registration registration = new Registration();
        String registrationDataStored = "";
        try {
            registration.setId(rs.getLong("ID_REGISTRATION"));
            registration.setModelId(rs.getLong("MODEL_ID"));
            registrationDataStored = rs.getString("REGISTRATIONS_DATA_BY_ACTION");
            ObjectMapper mapper = RegistrationJacksonMapper.getMapper();
            registration.setDataByAction((Map)mapper.readValue(registrationDataStored, (JavaType)mapper.getTypeFactory().constructMapLikeType(Map.class, String.class, RegistrationData.class)));
            registration.setActionHistory((List)mapper.readValue(rs.getString("ACTION_HISTORY"), (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, ActionHistoryByActionID.class)));
            registration.setState(RegistrationState.valueOf(rs.getString("STATE")));
            registration.setCreationIdentity(rs.getString("CREATION_IDENTITY"));
            registration.setCreationDate(rs.getTimestamp("CREATION_DATE"));
            registration.setCreationIdentity(rs.getString("LAST_UPDATE_IDENTITY"));
            registration.setLastUpdateDate(rs.getTimestamp("LAST_UPDATE_DATE"));
        }
        catch (SQLException e) {
            throw new UpdateToDataSourceException(String.format("Unable to update [%s] from table \"REGISTRATION\"", registration.toString()), e);
        }
        catch (IOException e) {
            throw new UpdateToDataSourceException(String.format("Unable to map RegistrationData from the saved value [%s]", registrationDataStored), e);
        }
        return registration;
    }
}

