/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.process;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurUtilisateurNonAuthentifie;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kosmos.registration.adapter.impl.WebRegistrationAdapter;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.exception.RegistrationException;
import com.kosmos.registration.exception.RegistrationViolationValidationException;
import com.kosmos.registration.service.RegistrationFlowService;
import com.kosmos.registration.service.impl.SimpleRegistrationFlowService;
import com.kosmos.registration.utils.RegistrationUtils;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.json.NamingStrategyHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRegistrationProcessus
extends ProcessusBean {
    public static final String REGISTRATION_ID = "REGISTRATION_ID";
    public static final String REGISTRATION_MODEL_ID = "REGISTRATION_MODEL";
    public static final String REGISTRATION_VIEW_MODEL = "REGISTRATION_VIEW_MODEL";
    public static final String CONSTRAINT_VIOLATION_INFOBEAN_SUFFIX = ".constraint";
    private final RegistrationFlowService registrationFlowService = ApplicationContextManager.getCoreContextBean("simpleRegistrationFlowService", SimpleRegistrationFlowService.class);
    private final WebRegistrationAdapter webAdapter = ApplicationContextManager.getCoreContextBean("webAdapter", WebRegistrationAdapter.class);
    public static final Logger LOG = LoggerFactory.getLogger(AbstractRegistrationProcessus.class);

    public AbstractRegistrationProcessus(InfoBean infoBean) {
        super(infoBean);
    }

    protected abstract boolean handlePostRegistration(String var1, Registration var2);

    protected abstract void handlePreRegistration(String var1) throws ErreurApplicative;

    @Override
    protected boolean traiterAction() throws Exception {
        Registration registration = null;
        try {
            Long modelId;
            Long registrationId;
            this.handlePreRegistration(this.infoBean.get("ACTION", String.class));
            try {
                registrationId = StringUtils.isNumeric((CharSequence)this.infoBean.get(REGISTRATION_ID, String.class)) ? Long.valueOf(this.infoBean.getString(REGISTRATION_ID)) : null;
                modelId = StringUtils.isNumeric((CharSequence)this.infoBean.get(REGISTRATION_MODEL_ID, String.class)) ? Long.valueOf(this.infoBean.getString(REGISTRATION_MODEL_ID)) : null;
            }
            catch (IllegalArgumentException e) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("BEAN_VALIDATION.ERROR"));
            }
            String identity = this.getConnectedUserIdentity();
            registration = registrationId != null || modelId != null ? (registrationId == null ? this.registrationFlowService.create(this.webAdapter.retrieveCreationData(this.infoBean.getValues(), modelId), modelId, identity) : this.registrationFlowService.update(this.webAdapter.retrieveUpdateData(this.infoBean.getValues(), registrationId), registrationId, identity)) : RegistrationUtils.newRegistrationInProgress(modelId, null, identity);
        }
        catch (RegistrationException e) {
            this.handleRegistrationException(e);
        }
        catch (ErreurApplicative e) {
            this.handleProcessusException(e);
        }
        return this.handlePostRegistration(this.infoBean.get("ACTION", String.class), registration);
    }

    protected String getConnectedUserIdentity() {
        SessionUtilisateur userSession = this.getGp().getSessionUtilisateur();
        if (userSession == null) {
            return "";
        }
        AutorisationBean authorization = (AutorisationBean)userSession.getInfos().get("AUTORISATIONS");
        if (authorization == null) {
            return "";
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)authorization.getCode(), (CharSequence)"");
    }

    protected void handleRegistrationException(RegistrationException e) {
        if (e instanceof RegistrationViolationValidationException) {
            HashMap constraintsVioldationByField = new HashMap();
            Set<ConstraintViolation<?>> violations = ((RegistrationViolationValidationException)e).getConstraintViolations();
            for (ConstraintViolation<?> constraintViolation : violations) {
                String errorKey = AbstractRegistrationProcessus.getErrorKey(constraintViolation);
                HashSet constraintViolationsForCurrentField = (HashSet)constraintsVioldationByField.get(errorKey);
                if (constraintViolationsForCurrentField == null) {
                    constraintViolationsForCurrentField = new HashSet();
                }
                constraintViolationsForCurrentField.add(constraintViolation);
                constraintsVioldationByField.put(errorKey, constraintViolationsForCurrentField);
            }
            for (Map.Entry entry : constraintsVioldationByField.entrySet()) {
                this.infoBean.set((String)entry.getKey(), entry.getValue());
            }
            this.infoBean.addMessageErreur(MessageHelper.getMessage(this.infoBean.getNomExtension(), e.getMessage()));
        } else {
            LOG.error("une exception s'est produite lors du traitement de la registration", (Throwable)e);
            this.infoBean.addMessageErreur(MessageHelper.getMessage(e.getExtensionId(), e.getMessage()));
        }
    }

    private static String getErrorKey(ConstraintViolation<?> constraintViolation) {
        String errorKey = constraintViolation.getRootBeanClass().getSimpleName();
        if (StringUtils.isNotEmpty((CharSequence)constraintViolation.getPropertyPath().toString())) {
            errorKey = errorKey + "." + constraintViolation.getPropertyPath();
        }
        errorKey = errorKey + CONSTRAINT_VIOLATION_INFOBEAN_SUFFIX;
        return NamingStrategyHelper.translateUppercaseToUnderscore(errorKey);
    }

    protected void handleProcessusException(ErreurApplicative e) {
        if (e instanceof ErreurUtilisateurNonAuthentifie) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            this.infoBean.setEcranLogique("LOGIN");
        } else {
            this.infoBean.addMessageErreur(e.getMessage());
        }
    }
}

