/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.service.impl;

import com.jsbsoft.jtf.datasource.exceptions.DataSourceException;
import com.kosmos.registration.action.Action;
import com.kosmos.registration.action.ActionConfiguration;
import com.kosmos.registration.action.ActionWithStep;
import com.kosmos.registration.action.history.ActionHistory;
import com.kosmos.registration.bean.Model;
import com.kosmos.registration.bean.ModelDescriptor;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.exception.RegistrationExecutionException;
import com.kosmos.registration.exception.RegistrationValidationException;
import com.kosmos.registration.exception.RegistrationViolationValidationException;
import com.kosmos.registration.service.RegistrationFlowService;
import com.kosmos.registration.service.impl.ModelService;
import com.kosmos.registration.service.impl.RegistrationService;
import com.kosmos.registration.utils.ModelDescriptorUtils;
import com.kosmos.registration.utils.RegistrationUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleRegistrationFlowService
implements RegistrationFlowService {
    public static final String ID_BEAN = "simpleRegistrationFlowService";
    private static final Logger LOG = LoggerFactory.getLogger(SimpleRegistrationFlowService.class);
    private RegistrationService registrationService;
    private ModelService modelService;

    public void setModelService(ModelService modelService) {
        this.modelService = modelService;
    }

    public void setRegistrationService(RegistrationService registrationService) {
        this.registrationService = registrationService;
    }

    @Override
    public Registration create(Map<String, RegistrationData> data, Long modelId, String identity) throws Exception {
        Registration registration = RegistrationUtils.newRegistrationInProgress(modelId, data, identity);
        Model model = this.modelService.get(modelId);
        String modelDescriptorId = model.getModelDescriptorId();
        ModelDescriptor modelDescriptor = this.getModelDescriptor(modelDescriptorId);
        this.processValidations(registration, model, modelDescriptor, identity);
        this.registrationService.create(registration);
        this.processActionsInCreation(registration, model, modelDescriptor, identity);
        this.updateRegistrationState(registration);
        this.registrationService.update(registration);
        return registration;
    }

    @Override
    public Registration update(Map<String, RegistrationData> data, Long registrationId, String identity) throws Exception {
        Registration registration = this.loadRegistration(registrationId);
        Long modelId = registration.getModelId();
        Model model = this.modelService.get(modelId);
        if (model == null) {
            return null;
        }
        String modelDescriptorId = model.getModelDescriptorId();
        ModelDescriptor modelDescriptor = this.getModelDescriptor(modelDescriptorId);
        if (modelDescriptor == null) {
            return null;
        }
        this.updateRegistrationInformation(registration, data, identity);
        this.registrationService.update(registration);
        this.processActionsInUpdate(registration, model, modelDescriptor, identity);
        this.updateRegistrationState(registration);
        this.registrationService.update(registration);
        return registration;
    }

    private void processValidations(Registration registration, Model model, ModelDescriptor modelDescriptor, String identity) throws DataSourceException, RegistrationValidationException {
        Map<String, Action> actionsById = modelDescriptor.getActions();
        HashSet violations = new HashSet();
        for (Map.Entry<String, Action> actionsByIdEntry : actionsById.entrySet()) {
            String actionId = actionsByIdEntry.getKey();
            Action action = actionsByIdEntry.getValue();
            try {
                this.processActionValidation(actionId, action, registration, model, identity);
            }
            catch (RegistrationViolationValidationException e) {
                violations.addAll(e.getConstraintViolations());
            }
        }
        if (CollectionUtils.isNotEmpty(violations)) {
            throw new RegistrationViolationValidationException("BEAN_VALIDATION.ERROR", violations);
        }
    }

    private void processActionValidation(String actionId, Action action, Registration registration, Model model, String identity) throws RegistrationValidationException {
        Map<String, ? extends ActionConfiguration> configurationsByAction = model.getActionConfigurationById();
        Map<String, RegistrationData> dataByAction = registration.getDataByAction();
        RegistrationData data = dataByAction.get(actionId);
        ActionConfiguration actionConfiguration = configurationsByAction.get(actionId);
        action.validatePrecondition(data, actionConfiguration, registration, identity, actionId);
    }

    private ModelDescriptor getModelDescriptor(String modelDescriptorId) throws Exception {
        return ModelDescriptorUtils.getModelDescriptor(modelDescriptorId);
    }

    private void processActionsInCreation(Registration registration, Model model, ModelDescriptor modelDescriptor, String identity) throws RegistrationExecutionException, DataSourceException {
        Map<String, Action> actions = modelDescriptor.getActions();
        this.processActions(actions, registration, model, identity);
    }

    private void processActions(Map<String, Action> actions, Registration registration, Model model, String identity) throws RegistrationExecutionException {
        for (Map.Entry<String, Action> actionEntry : actions.entrySet()) {
            String actionId = actionEntry.getKey();
            Action action = actionEntry.getValue();
            ActionHistory history = this.processAction(actionId, action, registration, model, identity);
            registration.getActionHistory().add((Pair<String, ActionHistory>)new ImmutablePair((Object)actionId, (Object)history));
            if (RegistrationState.FINISHED.equals((Object)history.getState())) continue;
            break;
        }
    }

    private ActionHistory processAction(String actionId, Action action, Registration registration, Model model, String identity) throws RegistrationExecutionException {
        Map<String, ? extends ActionConfiguration> configurationsByAction = model.getActionConfigurationById();
        Map<String, RegistrationData> dataByAction = registration.getDataByAction();
        RegistrationData data = dataByAction.get(actionId);
        ActionConfiguration actionConfiguration = configurationsByAction.get(actionId);
        return action.execute(data, actionConfiguration, registration, identity, actionId);
    }

    private void updateRegistrationState(Registration registration) {
        if (CollectionUtils.isNotEmpty(registration.getActionHistory())) {
            ActionHistory lastHistory = RegistrationUtils.getLastActionHistory(registration);
            registration.setState(lastHistory.getState());
        } else {
            registration.setState(RegistrationState.FINISHED);
        }
    }

    private Registration loadRegistration(Long registrationId) throws RegistrationExecutionException {
        Registration registration = this.registrationService.get(registrationId);
        if (!RegistrationState.WAITING.equals((Object)registration.getState())) {
            throw new RegistrationExecutionException("TODO");
        }
        return registration;
    }

    private void updateRegistrationInformation(Registration registration, Map<String, RegistrationData> data, String identity) {
        registration.setLastUpdateDate(new Date());
        registration.setLastUpdateIdentity(identity);
        registration.setDataByAction(data);
    }

    private void processActionsInUpdate(Registration registration, Model model, ModelDescriptor modelDescriptor, String identity) throws RegistrationExecutionException, RegistrationValidationException {
        if (!RegistrationState.WAITING.equals((Object)registration.getState())) {
            throw new RegistrationExecutionException("TODO");
        }
        String restartActionId = this.processFirstActionInUpdate(registration, model, modelDescriptor, identity);
        this.updateRegistrationState(registration);
        if (RegistrationState.FINISHED.equals((Object)registration.getState())) {
            Map<String, Action> actionsToProcess = ModelDescriptorUtils.getActionsAfterActionId(restartActionId, modelDescriptor);
            this.processActions(actionsToProcess, registration, model, identity);
        }
    }

    private String processFirstActionInUpdate(Registration registration, Model model, ModelDescriptor modelDescriptor, String identity) throws RegistrationExecutionException, RegistrationValidationException {
        String actionId = RegistrationUtils.getLastActionIdFromHistory(registration);
        Action action = modelDescriptor.getActions().get(actionId);
        if (action instanceof ActionWithStep) {
            ActionWithStep actionWithStep = (ActionWithStep)action;
            ActionHistory history = this.processActionWithStep(actionId, actionWithStep, registration, model, identity);
            registration.getActionHistory().add((Pair<String, ActionHistory>)new ImmutablePair((Object)actionId, (Object)history));
        } else {
            ActionHistory history = this.processAction(actionId, action, registration, model, identity);
            registration.getActionHistory().add((Pair<String, ActionHistory>)new ImmutablePair((Object)actionId, (Object)history));
        }
        return actionId;
    }

    private ActionHistory processActionWithStep(String actionId, ActionWithStep action, Registration registration, Model model, String identity) throws RegistrationExecutionException, RegistrationValidationException {
        Map<String, ? extends ActionConfiguration> configurationsByAction = model.getActionConfigurationById();
        Map<String, RegistrationData> dataByAction = registration.getDataByAction();
        RegistrationData data = dataByAction.get(actionId);
        ActionConfiguration actionConfiguration = configurationsByAction.get(actionId);
        action.validateStepPrecondition(data, actionConfiguration, registration, identity, actionId);
        return action.executeStep(data, actionConfiguration, registration, identity, actionId);
    }
}

