/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.registration.utils;

import com.kosmos.registration.action.Action;
import com.kosmos.registration.action.history.ActionHistory;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationData;
import com.kosmos.registration.bean.RegistrationState;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;

public class RegistrationUtils {
    public static ActionHistory getLastActionHistory(Registration registration) {
        List<Pair<String, ActionHistory>> actionsHistory = registration.getActionHistory();
        if (CollectionUtils.isNotEmpty(actionsHistory)) {
            return (ActionHistory)actionsHistory.get(actionsHistory.size() - 1).getValue();
        }
        return null;
    }

    public static String getLastActionIdFromHistory(Registration registration) {
        List<Pair<String, ActionHistory>> actionsHistory = registration.getActionHistory();
        if (CollectionUtils.isNotEmpty(actionsHistory)) {
            return (String)actionsHistory.get(actionsHistory.size() - 1).getKey();
        }
        return null;
    }

    public static ActionHistory getLastActionHistoryFromActionID(List<Pair<String, ActionHistory>> actionsHistory, final String actionId) {
        CollectionUtils.filter(actionsHistory, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((String)((Pair)object).getKey()).equals(actionId);
            }
        });
        return (ActionHistory)actionsHistory.get(actionsHistory.size() - 1).getValue();
    }

    public static Registration newRegistrationInProgress(Long modelId, Map<String, RegistrationData> data, String identity) {
        Registration registration = new Registration();
        registration.setCreationDate(new Date());
        registration.setCreationIdentity(identity);
        registration.setModelId(modelId);
        registration.setState(RegistrationState.IN_PROGRESS);
        registration.setActionHistory((List<Pair<String, ActionHistory>>)new ArrayList<Pair<String, ActionHistory>>(){});
        registration.setLastUpdateDate(new Date());
        registration.setLastUpdateIdentity(identity);
        registration.setDataByAction(data);
        return registration;
    }

    public static <T> Class<? extends T> getActionDataType(Action action, Class<T> clazz) {
        Map parametrizedType = TypeUtils.getTypeArguments(action.getClass(), Action.class);
        if (MapUtils.isNotEmpty((Map)parametrizedType)) {
            for (Type currentType : parametrizedType.values()) {
                if (!TypeUtils.isAssignable((Type)currentType, clazz)) continue;
                return (Class)currentType;
            }
        }
        return null;
    }
}

