/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.userfront.action;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.kosmos.registration.action.DefaultActionWithoutConfiguration;
import com.kosmos.registration.action.bean.EmptyActionConfiguration;
import com.kosmos.registration.action.history.ActionHistory;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.exception.RegistrationExecutionException;
import com.kosmos.registration.exception.RegistrationValidationException;
import com.kosmos.registration.service.impl.RegistrationService;
import com.kosmos.userfront.bean.UserRegistrationData;
import com.kosmos.userfront.history.EmailActionHistory;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.security.MySQLHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.ContexteDao;
import com.univ.utils.URLResolver;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.mail.MessagingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.mail.EmailException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserCreation
extends DefaultActionWithoutConfiguration<UserRegistrationData> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUserCreation.class);

    @Override
    public void validatePrecondition(UserRegistrationData data, EmptyActionConfiguration configuration, Registration registration, String identity, final String actionId) throws RegistrationValidationException {
        super.validatePrecondition(data, configuration, registration, identity, actionId);
        final String login = data.getLogin();
        Utilisateur utilisateurByLogin = null;
        try {
            utilisateurByLogin = Utilisateur.getUtilisateur(login);
        }
        catch (Exception e) {
            LOG.error("erreur lors de la r\u00e9cup\u00e9ration de l'utilisateur ayant pour login " + login);
        }
        if (utilisateurByLogin != null && utilisateurByLogin.getCode().equals(login)) {
            throw new RegistrationValidationException("ERROR.USERFRONT.LOGIN_ALREADY_EXIST");
        }
        try {
            data.setPassword(MySQLHelper.encodePassword(data.getPassword()));
            data.setPasswordConfirmation(data.getPassword());
        }
        catch (UnsupportedEncodingException e) {
            LOG.info("l'encodage du password n'a pas fonctionn\u00e9", (Throwable)e);
        }
        RegistrationService registrationService = ApplicationContextManager.getCoreContextBean("registrationService", RegistrationService.class);
        if (registration != null) {
            final Long registrationId = registration.getId();
            Collection<Registration> thisModelRegistrations = registrationService.getRegistrationsByModel(registration.getModelId());
            boolean existValues = CollectionUtils.exists(thisModelRegistrations, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    Registration registration = (Registration)object;
                    UserRegistrationData dataValues = (UserRegistrationData)registration.getDataByAction().get(actionId);
                    List<Pair<String, ActionHistory>> actionsHistory = registration.getActionHistory();
                    boolean isValid = this.isWaitingForValidEmailValidation(registration, actionsHistory);
                    return isValid && !RegistrationState.ERROR.equals((Object)registration.getState()) && !RegistrationState.FINISHED.equals((Object)registration.getState()) && !registration.getId().equals(registrationId) && login.equals(dataValues.getLogin());
                }

                private boolean isWaitingForValidEmailValidation(Registration registration, List<Pair<String, ActionHistory>> actionsHistory) {
                    boolean isValid = Boolean.TRUE;
                    DateTime now = DateTime.now();
                    DateTime yesterday = now.minusDays(1);
                    if (actionsHistory.get(actionsHistory.size() - 1).getValue() instanceof EmailActionHistory && RegistrationState.WAITING.equals((Object)registration.getState())) {
                        isValid = yesterday.isBefore(registration.getCreationDate().getTime());
                    }
                    return isValid;
                }
            });
            if (existValues) {
                throw new RegistrationValidationException("ERROR.USERFRONT.LOGIN_ALREADY_EXIST");
            }
        }
    }

    @Override
    public ActionHistory execute(UserRegistrationData data, EmptyActionConfiguration configuration, Registration registration, String identity, String actionId) throws RegistrationExecutionException {
        Utilisateur userToCreate = new Utilisateur();
        userToCreate.init();
        userToCreate.setCode(data.getLogin());
        userToCreate.setNom(data.getLastName());
        userToCreate.setPrenom(data.getName());
        userToCreate.setMotDePasse(data.getPassword());
        userToCreate.setAdresseMail(data.getEmail());
        this.setNotByDefaultValue(data, userToCreate);
        try (ContexteDao ctx = new ContexteDao();){
            userToCreate.setCtx(ctx);
            userToCreate.add();
        }
        catch (Exception e) {
            throw new RegistrationExecutionException("ERROR.USERFRONT.USER.CREATION", e);
        }
        ActionHistory history = new ActionHistory();
        Locale locale = LangueUtil.getLocale(data.getIdLocaleKportal());
        String emailConfirmationTitle = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL.ACCOUNT_CREAIED");
        InfosSite infosSite = Site.renvoyerItemSite(data.getAliasSite());
        String identificationUrl = URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=CONNECTER", infosSite, 1);
        String emailConfirmationContent = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL.ACCOUNT_CREATED_BODY");
        JSBMailbox mailbox = new JSBMailbox(false);
        try {
            mailbox.sendWmasterMsg(data.getEmail(), emailConfirmationTitle, String.format(emailConfirmationContent, identificationUrl));
        }
        catch (MessagingException | EmailException e) {
            LOG.error("impossible d'envoyer un email \u00e0 l'utilisateur ayant cr\u00e9\u00e9 un compte", e);
        }
        history.setCreationDate(new java.util.Date());
        history.setState(RegistrationState.FINISHED);
        return history;
    }

    private void setNotByDefaultValue(UserRegistrationData data, Utilisateur userToCreate) {
        if (data.getBirthdate() != null) {
            userToCreate.setDateNaissance(new Date(data.getBirthdate().getTime()));
        }
        if (data.getTitle() != null) {
            userToCreate.setCivilite(data.getTitle());
        }
        if (data.getInstitutionsCodes() != null) {
            userToCreate.setCodeRattachement(data.getInstitutionsCodes());
        }
        if (data.getGroups() != null) {
            userToCreate.setGroupes(data.getGroups());
        }
        if (data.getValidationRestriction() != null) {
            userToCreate.setRestrictionValidation(data.getValidationRestriction());
        }
        if (data.getEditionExtension() != null) {
            userToCreate.setExtensionModification(data.getEditionExtension());
        }
        if (data.getInterests() != null) {
            userToCreate.setCentresInteret(data.getInterests());
        }
        if (data.getProfiles() != null) {
            userToCreate.setProfilDsi(data.getProfiles());
        }
        if (data.getDsiGroups() != null) {
            userToCreate.setGroupesDsi(data.getDsiGroups());
        }
        if (data.getLdapCode() != null) {
            userToCreate.setCodeLdap(data.getLdapCode());
        }
        if (data.getDsiGroupsFromImport() != null) {
            userToCreate.setGroupesDsiImport(data.getDsiGroupsFromImport());
        }
        if (data.getRoles() != null) {
            userToCreate.setRoles(data.getRoles());
        }
        if (data.getDefaultProfile() != null) {
            userToCreate.setProfilDefaut(data.getDefaultProfile());
        }
        if (data.getMailFormat() != null) {
            userToCreate.setFormatEnvoi(data.getMailFormat());
        }
        if (data.getExpertMode() != null) {
            userToCreate.setModeSaisieExpert(data.getExpertMode());
        }
    }
}

