/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.userfront.action;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.LangueUtil;
import com.jsbsoft.jtf.email.JSBMailbox;
import com.kosmos.registration.action.ActionWithStep;
import com.kosmos.registration.action.bean.EmptyActionConfiguration;
import com.kosmos.registration.action.history.ActionHistory;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.exception.RegistrationExecutionException;
import com.kosmos.registration.exception.RegistrationValidationException;
import com.kosmos.registration.exception.RegistrationViolationValidationException;
import com.kosmos.userfront.bean.ModerationState;
import com.kosmos.userfront.bean.UserModerationData;
import com.kosmos.userfront.module.UserFrontModule;
import com.kosmos.userfront.service.UserModerationService;
import com.kosmos.validation.ValidationUtils;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.config.PropertyHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.objetspartages.om.PermissionBean;
import com.univ.objetspartages.om.Utilisateur;
import com.univ.utils.MailUtil;
import com.univ.utils.URLResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.MessagingException;
import javax.validation.ConstraintViolation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserModeration
implements ActionWithStep<UserModerationData, EmptyActionConfiguration> {
    public static final String ID_BEAN = "moderationAction";
    public static final String PROPERTY_IS_ACTIVE = "moderation.backoffice";
    private static final Logger LOG = LoggerFactory.getLogger(UserModeration.class);

    @Override
    public void validateConfiguration(EmptyActionConfiguration configuration) throws RegistrationViolationValidationException {
    }

    @Override
    public void validatePrecondition(UserModerationData data, EmptyActionConfiguration configuration, Registration registration, String identity, String actionId) throws RegistrationValidationException {
        Set<ConstraintViolation<UserModerationData>> violations;
        if (this.isModerationActive() && CollectionUtils.isNotEmpty(violations = ValidationUtils.validateBean(data))) {
            throw new RegistrationViolationValidationException("BEAN_VALIDATION.ERROR", violations);
        }
    }

    @Override
    public ActionHistory execute(UserModerationData data, EmptyActionConfiguration configuration, Registration registration, String identity, String actionId) throws RegistrationExecutionException {
        ActionHistory history = new ActionHistory();
        history.setCreationDate(new Date());
        if (this.isModerationActive()) {
            Locale locale = LangueUtil.getDefaultLocale();
            String confirmationEmail = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL_GESTIONNAIRE.CONFIRMATION_BODY");
            String titleConformation = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL_GESTIONNAIRE.CONFIRMATION_TITLE");
            InfosSite siteCourant = Site.getSitePrincipal();
            String urlBackOffice = URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER", siteCourant, 0);
            Collection<String> administratorsEmails = this.getAdminsitratorsEmails();
            JSBMailbox mailbox = new JSBMailbox(false);
            try {
                for (String email : administratorsEmails) {
                    if (!MailUtil.verifMail(email)) continue;
                    mailbox.sendWmasterMsg(email, String.format(titleConformation, siteCourant.getIntitule()), String.format(confirmationEmail, siteCourant.getIntitule(), urlBackOffice));
                }
            }
            catch (MessagingException | EmailException e) {
                LOG.error("Impossible d'envoyer un email aux adminsitrateurs de cr\u00e9ation de compte", e);
            }
            UserModerationService service = ApplicationContextManager.getCoreContextBean("userModerationService", UserModerationService.class);
            data.setCreationDate(registration.getCreationDate());
            data.setModerationState(ModerationState.NOT_MODERATED);
            data.setParentIdRegistration(registration.getId());
            service.create(data);
            history.setState(RegistrationState.WAITING);
        } else {
            data.setCreationDate(registration.getCreationDate());
            data.setParentIdRegistration(registration.getId());
            history.setState(RegistrationState.FINISHED);
        }
        return history;
    }

    private Collection<String> getAdminsitratorsEmails() {
        Collection<String> emailUtilisateurs;
        PermissionBean permission = UserFrontModule.getPermissionGestion();
        try {
            List<Utilisateur> utilisateurs = Utilisateur.getUtilisateursPossedantPermission(permission);
            emailUtilisateurs = CollectionUtils.collect(utilisateurs, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    Utilisateur user = (Utilisateur)input;
                    return user.getAdresseMail();
                }
            });
        }
        catch (Exception e) {
            LOG.error("impossible de r\u00e9cup\u00e9rer la liste des utilisateurs ayant la permiission de mod\u00e9ration", (Throwable)e);
            emailUtilisateurs = Collections.emptyList();
        }
        return emailUtilisateurs;
    }

    @Override
    public void validateStepPrecondition(UserModerationData data, EmptyActionConfiguration configuration, Registration registration, String identity, String actionID) throws RegistrationValidationException {
    }

    @Override
    public ActionHistory executeStep(UserModerationData data, EmptyActionConfiguration configuration, Registration registration, String identity, String actionID) throws RegistrationExecutionException {
        ActionHistory history = new ActionHistory();
        history.setCreationDate(new Date());
        history.setCreationId(identity);
        if (this.isModerationActive()) {
            UserModerationService service = ApplicationContextManager.getCoreContextBean("userModerationService", UserModerationService.class);
            if (ModerationState.REFUSED.equals((Object)data.getModerationState())) {
                history.setState(RegistrationState.ERROR);
                Locale locale = LangueUtil.getLocale(data.getIdLocaleKportal());
                String confirmationEmail = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL.REFUSED_BODY");
                if (StringUtils.isEmpty((CharSequence)data.getModerationMessage())) {
                    confirmationEmail = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL.REFUSED_BODY_EMPTY_MSG");
                }
                String titleConformation = MessageHelper.getCoreMessage(locale, "USERFRONT.EMAIL.REFUSED_TITLE");
                InfosSite siteCourant = Site.renvoyerItemSite(data.getAliasSite());
                JSBMailbox mailbox = new JSBMailbox(false);
                try {
                    mailbox.sendWmasterMsg(data.getEmail(), String.format(titleConformation, siteCourant.getIntitule()), String.format(confirmationEmail, data.getModerationMessage()));
                }
                catch (MessagingException | EmailException e) {
                    throw new RegistrationExecutionException("ERROR.USERFRONT.SENGING_MAIL", e);
                }
            } else if (ModerationState.VALIDATED.equals((Object)data.getModerationState())) {
                history.setState(RegistrationState.FINISHED);
            }
            service.update(data);
        } else {
            history.setState(RegistrationState.FINISHED);
        }
        return history;
    }

    private boolean isModerationActive() {
        return PropertyHelper.getCorePropertyAsBoolean(PROPERTY_IS_ACTIVE);
    }
}

