/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.userfront.processus;

import com.jsbsoft.jtf.core.ApplicationContextManager;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurActionNonAutorisee;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurUtilisateurNonAuthentifie;
import com.kosmos.registration.action.history.ActionHistory;
import com.kosmos.registration.bean.Registration;
import com.kosmos.registration.bean.RegistrationState;
import com.kosmos.registration.process.AbstractRegistrationProcessus;
import com.kosmos.registration.service.impl.RegistrationService;
import com.kosmos.registration.utils.RegistrationUtils;
import com.kosmos.userfront.bean.UserModerationData;
import com.kosmos.userfront.history.EmailActionHistory;
import com.kosmos.userfront.module.UserFrontModule;
import com.kosmos.userfront.service.UserModerationService;
import com.kportal.core.config.MessageHelper;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.utils.ContexteUtil;
import com.univ.utils.URLResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

public class UserFrontProcessus
extends AbstractRegistrationProcessus {
    public static final String ACTION_FRONT_CREATION = "CREATION";
    public static final String ACTION_FRONT_VALIDER_CREATION = "VALIDER_CREATION";
    public static final String ACTION_FRONT_CONFIRMATION = "CONFIRMATION";
    public static final String ACTION_ACCUEIL = "ACCUEIL";
    public static final String ACTION_DETAIL = "DETAIL";
    public static final String ACTION_VALIDER = "VALIDER";
    public static final String INFOBEAN_REGISTRATION = "REGISTRATIONS";
    public static final String INFOBEAN_ID_MODERATION_DATA = "ID_MODERATION_DATA";

    public UserFrontProcessus(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected void handlePreRegistration(String action) throws ErreurApplicative {
        this.etat = 1;
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (ACTION_ACCUEIL.equals(action) || ACTION_DETAIL.equals(action) || ACTION_VALIDER.equals(action)) {
            if (autorisations == null) {
                throw new ErreurUtilisateurNonAuthentifie();
            }
            if (!autorisations.possedePermission(UserFrontModule.getPermissionGestion())) {
                throw new ErreurActionNonAutorisee(MessageHelper.getCoreMessage("BO_OPERATION_INTERDITE"));
            }
        } else if (ACTION_FRONT_CONFIRMATION.equals(action)) {
            ActionHistory history;
            RegistrationService registrationService;
            Registration currentRegsitration;
            Long registrationId;
            Long l = registrationId = StringUtils.isNumeric((CharSequence)this.infoBean.get("REGISTRATION_ID", String.class)) ? Long.valueOf(this.infoBean.getString("REGISTRATION_ID")) : null;
            if (registrationId != null && (currentRegsitration = (registrationService = ApplicationContextManager.getCoreContextBean("registrationService", RegistrationService.class)).get(registrationId)) != null && !TypeUtils.isAssignable((history = RegistrationUtils.getLastActionHistory(currentRegsitration)).getClass(), EmailActionHistory.class)) {
                throw new ErreurApplicative(MessageHelper.getCoreMessage("FO.USERFRONT.EMAIL_VALIDATION_ALREADY_DONE"));
            }
        }
    }

    @Override
    protected boolean handlePostRegistration(String action, Registration registration) {
        AutorisationBean autorisations = (AutorisationBean)this.getGp().getSessionUtilisateur().getInfos().get("AUTORISATIONS");
        if (ACTION_FRONT_CREATION.equals(action)) {
            this.infoBean.setEcranLogique(ACTION_FRONT_CREATION);
            this.infoBean.set("REGISTRATION_MODEL", String.valueOf(UserFrontModule.getIdModelUserCreation()));
            this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("FO.USERFRONT.CREATION_TITLE"));
        } else if (ACTION_FRONT_VALIDER_CREATION.equals(action)) {
            if (registration != null) {
                String messageConfirm = MessageHelper.getCoreMessage("FO.USERFRONT.VALIDATE_BY_EMAIL");
                this.infoBean.set("MESSAGE_CONFIRMATION", messageConfirm);
                this.infoBean.setEcranLogique(ACTION_FRONT_CONFIRMATION);
            } else {
                this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("FO.USERFRONT.PAGE_HEADER"));
                this.infoBean.setEcranLogique(ACTION_FRONT_CREATION);
                this.infoBean.set("REGISTRATION_MODEL", String.valueOf(UserFrontModule.getIdModelUserCreation()));
            }
        } else if (ACTION_FRONT_CONFIRMATION.equals(action) && registration != null) {
            String messageConfirm = MessageHelper.getCoreMessage("FO.USERFRONT.REGISTRATION_CONFIRMATION");
            messageConfirm = String.format(messageConfirm, URLResolver.getAbsoluteUrl("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION_FRONT&ACTION=CONNECTER", ContexteUtil.getContexteUniv()));
            if (RegistrationState.WAITING.equals((Object)registration.getState())) {
                messageConfirm = MessageHelper.getCoreMessage("FO.USERFRONT.REGISTRATION_CONFIRMATION_VALIDATION");
            }
            this.infoBean.set("MESSAGE_CONFIRMATION", messageConfirm);
            this.infoBean.setEcranLogique(ACTION_FRONT_CONFIRMATION);
        } else if (this.isAuthorized(autorisations) && ACTION_ACCUEIL.equals(action)) {
            UserModerationService moderationService = ApplicationContextManager.getCoreContextBean("userModerationService", UserModerationService.class);
            this.infoBean.set(INFOBEAN_REGISTRATION, moderationService.getAllUserModerationOrderByCreation());
            this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("BO.USERFRONT.USER_CREATION_LIST"));
            this.infoBean.setEcranLogique(ACTION_ACCUEIL);
        } else if (this.isAuthorized(autorisations) && ACTION_DETAIL.equals(action)) {
            UserModerationService moderationService = ApplicationContextManager.getCoreContextBean("userModerationService", UserModerationService.class);
            UserModerationData data = moderationService.get(Long.valueOf(this.infoBean.getString("ID")));
            if (data == null) {
                this.infoBean.addMessageErreur(MessageHelper.getCoreMessage("ERROR.USERFRONT.DONNEES_NONTROUVE"));
            } else {
                this.infoBean.set(INFOBEAN_REGISTRATION, data);
                this.infoBean.set("REGISTRATION_ID", String.valueOf(data.getParentIdRegistration()));
                this.infoBean.setEcranLogique(ACTION_DETAIL);
                this.infoBean.setTitreEcran(data.getEmail());
            }
        } else if (ACTION_VALIDER.equals(action)) {
            this.infoBean.setEcranLogique(ACTION_ACCUEIL);
            this.etat = 2;
        }
        return this.etat == 2;
    }

    private boolean isAuthorized(AutorisationBean autorisations) {
        return autorisations != null && autorisations.possedePermission(UserFrontModule.getPermissionGestion());
    }
}

