/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.migration;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.migration.dao.impl.InfosSiteDaoMigrationProperties;
import com.kosmos.usinesite.migration.dao.impl.InfosSiteSauvegardeDaoImpl;
import com.kosmos.usinesite.service.impl.ServiceInfosSiteProcessus;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.service.ServiceTemplateSite;
import com.kosmos.usinesite.template.service.ServiceTemplateSiteFactory;
import com.kportal.core.config.PropertyHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.kportal.extension.IExtension;
import com.kportal.extension.IExtensionConfig;
import com.kportal.extension.Version;
import com.mysql.jdbc.exceptions.jdbc4.MySQLSyntaxErrorException;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.service.ServiceInfosSiteFactory;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationGestionDesSites
implements IExtensionConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationGestionDesSites.class);

    @Override
    public void init(IExtension extension, Version old) {
        if (this.isFichierAMigrer(old)) {
            this.migrerFichiersSite();
        }
        try {
            if (CollectionUtils.isEmpty(ServiceInfosSiteFactory.getServiceInfosSite().getListeTousInfosSites())) {
                this.lancementMigration();
            }
        }
        catch (Exception e) {
            LOG.error("erreur lors de la r\u00e9cup\u00e9ration des sites", (Throwable)e);
        }
    }

    private boolean isFichierAMigrer(Version old) {
        return new Version("6.00.01").greater(old) && StringUtils.isNotBlank((CharSequence)WebAppUtil.getConfDir());
    }

    private void lancementMigration() {
        LOG.info("*********** MIGRATION SITES");
        Collection<InfosSite> sitesAMigrer = null;
        try {
            try {
                sitesAMigrer = MigrationGestionDesSites.getListeInfosSiteDepuisBDD();
            }
            catch (MySQLSyntaxErrorException e1) {
                LOG.debug("l'usine a site n'\u00e9tait pas install\u00e9e");
                sitesAMigrer = MigrationGestionDesSites.getListeInfosSiteDepuisJtf();
            }
            MigrationGestionDesSites.enregsitrerDansPropertiesInfosSites(sitesAMigrer);
        }
        catch (Exception e) {
            LOG.error("impossible de migrer la d\u00e9claration de site", (Throwable)e);
        }
        LOG.info("*********** FIN MIGRATION SITES");
    }

    private void migrerFichiersSite() {
        String ancienCheminDossierUAS = StringUtils.defaultString((String)PropertyHelper.getCoreProperty("usinesite.fichiers"), (String)"/fichiers_usinesite");
        File ancienDossierUAS = new File(ancienCheminDossierUAS);
        if (!ancienDossierUAS.exists()) {
            ancienDossierUAS = new File(WebAppUtil.getAbsolutePath() + ancienCheminDossierUAS);
        }
        if (ancienDossierUAS.exists()) {
            File nouveauDossierUAS = new File(WebAppUtil.getAbsoluteFichiersSitesPath());
            try {
                FileUtils.moveDirectory((File)ancienDossierUAS, (File)nouveauDossierUAS);
            }
            catch (IOException e) {
                LOG.error("impossible de migrer les fichiers li\u00e9s aux sites", (Throwable)e);
            }
        }
    }

    private static Collection<InfosSite> getListeInfosSiteDepuisJtf() throws Exception {
        InfosSiteDaoMigrationProperties daoMigration = new InfosSiteDaoMigrationProperties();
        return daoMigration.getListeInfosSites();
    }

    private static Collection<InfosSite> getListeInfosSiteDepuisBDD() throws Exception {
        InfosSiteSauvegardeDaoImpl daoMigration = new InfosSiteSauvegardeDaoImpl();
        return daoMigration.getListeInfosSites();
    }

    private static void enregsitrerDansPropertiesInfosSites(Collection<InfosSite> listeSites) throws Exception {
        ServiceInfosSiteProcessus serviceClassique = (ServiceInfosSiteProcessus)ServiceInfosSiteFactory.getServiceInfosSite();
        ServiceTemplateSite serviceTemplateSite = ServiceTemplateSiteFactory.getServiceTemplateSite();
        for (InfosSite site : listeSites) {
            LOG.info("Traitement du site : " + site.getAlias());
            try {
                TemplateSite templateSite = null;
                templateSite = StringUtils.isNotEmpty((CharSequence)site.getCodeTemplate()) ? serviceTemplateSite.getTemplateSiteParCode(site.getCodeTemplate()) : serviceTemplateSite.getTemplateSiteParDossier(site.getJspFo());
                LOG.info(" - utilisation du template : " + templateSite.getCode());
                InfosSiteImpl infosSite = (InfosSiteImpl)site;
                infosSite.setCodeTemplate(templateSite.getCode());
                infosSite.setJspFo(templateSite.getDossierJSP());
                serviceClassique.creer(infosSite);
            }
            catch (ErreurDonneeNonTrouve e) {
                LOG.info(" - " + e.getMessage());
                serviceClassique.creer((InfosSiteImpl)site, null);
            }
            catch (Exception e) {
                LOG.info(" - ", (Throwable)e);
            }
            LOG.info(" - cr\u00e9ation termin\u00e9e");
            LOG.info("Fin traitement");
        }
    }

    @Override
    public void clean(IExtension extension) {
    }
}

