/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.migration.dao.impl;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kportal.core.config.PropertyConfigurer;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.dao.impl.InfosSiteDaoProperties;
import com.univ.multisites.helper.InfosSitePropertiesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class InfosSiteDaoMigrationProperties
extends InfosSiteDaoProperties {
    @Override
    public InfosSite getInfosSite(String code) throws Exception {
        String codeSitePrincipal;
        String codeTemplate;
        String jspFO;
        String sso;
        String siteRestriction;
        String siteRubrique;
        String httpsAction;
        String httpAction;
        String boSSLMode;
        String sslMode;
        String httpsPort;
        String httpPort;
        String listeAliasHostsSite;
        String httpsHost;
        String httpHost;
        this.verifierInfoSiteExiste(code);
        InfosSiteImpl infosSite = new InfosSiteImpl();
        infosSite.setAlias(code);
        String intitule = PropertyConfigurer.getProperty("site." + code + ".intitule");
        if (StringUtils.isNotEmpty((CharSequence)intitule)) {
            infosSite.setIntitule(intitule);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpHost = PropertyConfigurer.getProperty("site." + code + ".host")))) {
            infosSite.setHttpHostname(httpHost);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpsHost = PropertyConfigurer.getProperty("site." + code + ".https_host")))) {
            infosSite.setHttpsHostname(httpsHost);
        }
        if (StringUtils.isNotEmpty((CharSequence)(listeAliasHostsSite = PropertyConfigurer.getProperty("site." + code + ".alias")))) {
            Object[] tableauAliasHost = listeAliasHostsSite.split(String.valueOf(';'));
            HashSet<String> listeAliasHost = new HashSet<String>();
            CollectionUtils.addAll(listeAliasHost, (Object[])tableauAliasHost);
            infosSite.setListeHostAlias(listeAliasHost);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpPort = PropertyConfigurer.getProperty("site." + code + ".port"))) && StringUtils.isNumeric((CharSequence)httpPort)) {
            infosSite.setHttpPort(Integer.parseInt(httpPort));
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpsPort = PropertyConfigurer.getProperty("site." + code + ".https_port"))) && StringUtils.isNumeric((CharSequence)httpsPort)) {
            infosSite.setHttpsPort(Integer.parseInt(httpsPort));
        }
        if (StringUtils.isNotEmpty((CharSequence)(sslMode = PropertyConfigurer.getProperty("site." + code + ".ssl_mode"))) && StringUtils.isNumeric((CharSequence)sslMode)) {
            infosSite.setSslMode(Integer.parseInt(sslMode));
        }
        if (StringUtils.isNotEmpty((CharSequence)(boSSLMode = PropertyConfigurer.getProperty("site." + code + ".bo.ssl_mode"))) && StringUtils.isNumeric((CharSequence)boSSLMode)) {
            infosSite.setBoSslMode(Integer.parseInt(boSSLMode));
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpAction = PropertyConfigurer.getProperty("site." + code + ".http_actions")))) {
            SortedSet<Integer> listeActions = InfosSitePropertiesHelper.transformerActionsStringEnListe(httpAction);
            infosSite.setHttpActions(listeActions);
        }
        if (StringUtils.isNotEmpty((CharSequence)(httpsAction = PropertyConfigurer.getProperty("site." + code + ".https_actions")))) {
            SortedSet<Integer> listeActions = InfosSitePropertiesHelper.transformerActionsStringEnListe(httpsAction);
            infosSite.setHttpsActions(listeActions);
        }
        if (StringUtils.isNotEmpty((CharSequence)(siteRubrique = PropertyConfigurer.getProperty("site." + code + ".rubrique")))) {
            infosSite.setCodeRubrique(siteRubrique);
        } else {
            infosSite.setCodeRubrique("");
        }
        this.gestionReecritureUrl(code, infosSite);
        String siteURLAccueil = PropertyConfigurer.getProperty("site." + code + ".url_accueil");
        if (StringUtils.isNotEmpty((CharSequence)siteURLAccueil)) {
            infosSite.setUrlAccueil(siteURLAccueil);
        }
        if (StringUtils.isNotEmpty((CharSequence)(siteRestriction = PropertyConfigurer.getProperty("site." + code + ".restriction"))) && StringUtils.isNumeric((CharSequence)siteRestriction)) {
            infosSite.setRestriction(Integer.parseInt(siteRestriction));
        }
        if (StringUtils.isNotEmpty((CharSequence)(sso = PropertyConfigurer.getProperty("site." + code + ".sso")))) {
            infosSite.setSso("1".equals(sso));
        }
        if (StringUtils.isNotEmpty((CharSequence)(jspFO = PropertyConfigurer.getProperty("site." + code + ".jsp_fo")))) {
            infosSite.setJspFo(StringUtils.removeEnd((String)jspFO, (String)"/"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeTemplate = PropertyConfigurer.getProperty("site." + code + ".code_template")))) {
            infosSite.setCodeTemplate(codeTemplate);
        }
        if (StringUtils.isNotEmpty((CharSequence)(codeSitePrincipal = PropertyConfigurer.getProperty("site.principal")))) {
            infosSite.setSitePrincipal(codeSitePrincipal.equalsIgnoreCase(code));
        }
        infosSite.setActif(Boolean.TRUE);
        this.setListeProprietesComplementairesDansInfosSite(infosSite);
        return infosSite;
    }

    private void gestionReecritureUrl(String code, InfosSiteImpl infosSite) {
        String reecritureRubriqueMode = PropertyConfigurer.getProperty("site." + code + ".reecriture_rubrique_mode");
        if (StringUtils.isNotEmpty((CharSequence)reecritureRubriqueMode) && StringUtils.isNumeric((CharSequence)reecritureRubriqueMode)) {
            int valeurModeReecriture = Integer.parseInt(reecritureRubriqueMode);
            if (valeurModeReecriture > 0) {
                infosSite.setModeReecritureRubrique(1);
            } else {
                infosSite.setModeReecritureRubrique(0);
            }
        }
        if (infosSite.getModeReecritureRubrique() > 0) {
            String reecritureRubriqueMax;
            String reecritureRubriqueMin = PropertyConfigurer.getProperty("site." + code + ".reecriture_rubrique_min");
            if (StringUtils.isNotEmpty((CharSequence)reecritureRubriqueMin) && StringUtils.isNumeric((CharSequence)reecritureRubriqueMin)) {
                infosSite.setNiveauMinReecritureRubrique(Integer.parseInt(reecritureRubriqueMin));
            }
            if (StringUtils.isNotEmpty((CharSequence)(reecritureRubriqueMax = PropertyConfigurer.getProperty("site." + code + ".reecriture_rubrique_max"))) && StringUtils.isNumeric((CharSequence)reecritureRubriqueMax)) {
                infosSite.setNiveauMaxReecritureRubrique(Integer.parseInt(reecritureRubriqueMax));
            }
        }
    }

    private void verifierInfoSiteExiste(String code) throws ErreurDonneeNonTrouve {
        String host = PropertyConfigurer.getProperty("site." + code + ".host");
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new ErreurDonneeNonTrouve("Impossible de trouver le site \"" + code + "\"");
        }
    }

    private void setListeProprietesComplementairesDansInfosSite(InfosSiteImpl infosSite) {
        String debutCleProprieteSite = "site." + infosSite.getAlias() + ".";
        Properties toutesLesProprietes = PropertyConfigurer.getInstance().getProperties();
        for (Map.Entry<Object, Object> property : toutesLesProprietes.entrySet()) {
            String cleProprieteSite;
            String clePropriete = String.valueOf(property.getKey());
            if (!StringUtils.startsWithIgnoreCase((CharSequence)clePropriete, (CharSequence)debutCleProprieteSite) || InfosSitePropertiesHelper.FinNomProprieteSite.isProprieteSite(cleProprieteSite = StringUtils.removeStartIgnoreCase((String)clePropriete, (String)debutCleProprieteSite)) || !StringUtils.isNotEmpty((CharSequence)cleProprieteSite)) continue;
            String valeur = PropertyConfigurer.getProperty(clePropriete);
            infosSite.putProperty(cleProprieteSite, valeur);
        }
    }

    @Override
    public Collection<InfosSite> getListeInfosSites() throws Exception {
        ArrayList<InfosSite> listeInfosSites = new ArrayList<InfosSite>();
        Properties toutesLesProprietes = PropertyConfigurer.getInstance().getProperties();
        for (Map.Entry<Object, Object> property : toutesLesProprietes.entrySet()) {
            String[] cleProprieteSplitte;
            String clePropriete = String.valueOf(property.getKey());
            if (!StringUtils.startsWith((CharSequence)clePropriete, (CharSequence)"site.") || (cleProprieteSplitte = StringUtils.split((String)clePropriete, (char)'.')).length <= 2 || !cleProprieteSplitte[2].equals("host")) continue;
            String codeSite = cleProprieteSplitte[1];
            InfosSite infosSite = this.getInfosSite(codeSite);
            listeInfosSites.add(infosSite);
        }
        String sitePrincipal = toutesLesProprietes.getProperty("site.principal");
        if (StringUtils.isNotBlank((CharSequence)sitePrincipal)) {
            for (InfosSite site : listeInfosSites) {
                if (!sitePrincipal.equals(site.getAlias())) continue;
                ((InfosSiteImpl)site).setSitePrincipal(Boolean.TRUE);
            }
        }
        return listeInfosSites;
    }

    @Override
    public void miseAJour(InfosSite infosSite) throws Exception {
        throw new UnsupportedOperationException("ce DAO n'implemente pas de mise \u00e0 jour car il sert uniquement \u00e0 la migration du parametrage");
    }

    @Override
    public void supprimer(String code) throws Exception {
        throw new UnsupportedOperationException("ce DAO n'implemente pas de suppression ");
    }
}

