/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.migration.dao.impl;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.migration.bean.InfosSiteSauvegarde;
import com.kosmos.usinesite.migration.bean.ProprietesSite;
import com.kosmos.usinesite.migration.utils.InfosSiteCodec;
import com.univ.multisites.InfosSite;
import com.univ.multisites.dao.impl.InfosSiteDaoProperties;
import com.univ.utils.ContexteDao;
import com.univ.utils.json.CodecJSon;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfosSiteSauvegardeDaoImpl
extends InfosSiteDaoProperties {
    private static Logger LOG = LoggerFactory.getLogger(InfosSiteSauvegardeDaoImpl.class);
    private static final String SELECT_TOUT = "SELECT * FROM USINESITE_INFOSSITE;";
    private static final String SELECT_PAR_CODE = "SELECT * FROM USINESITE_INFOSSITE WHERE CODE = ? ORDER BY INTITULE;";
    private static final String SELECT_PAR_ID = "SELECT * FROM USINESITE_INFOSSITE WHERE ID_USINESITE_INFOSSITE = ? ORDER BY INTITULE;";
    private static final String DELETE_PAR_CODE = "DELETE FROM USINESITE_INFOSSITE WHERE CODE = ?;";

    protected ContexteDao instancierContexteDao() {
        return new ContexteDao();
    }

    protected void fermerAccesBD(ContexteDao ctx, PreparedStatement stmt) {
        this.fermerAccesBD(ctx, stmt, null);
    }

    protected void fermerAccesBD(ContexteDao ctx, PreparedStatement stmt, ResultSet res) {
        try {
            if (res != null) {
                res.close();
            }
        }
        catch (Exception e) {
            LOG.debug("Erreur lors de la fermeture du resultSet", (Throwable)e);
        }
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (Exception e) {
            LOG.debug("Erreur lors de la fermeture du statement", (Throwable)e);
        }
        if (ctx != null) {
            ctx.close();
        }
    }

    @Override
    public InfosSite getInfosSite(String code) throws Exception {
        InfosSiteSauvegarde infosSiteBDD = this.getInfosSiteSauvegarde(code);
        return InfosSiteCodec.decode(infosSiteBDD);
    }

    public InfosSiteSauvegarde getInfosSiteSauvegarde(String code) throws Exception {
        block3: {
            ContexteDao ctx = this.instancierContexteDao();
            PreparedStatement stmt = null;
            ResultSet res = null;
            try {
                stmt = ctx.getConnection().prepareStatement(SELECT_PAR_CODE);
                stmt.setString(1, code);
                res = stmt.executeQuery();
                if (!res.next()) break block3;
                InfosSiteSauvegarde infosSiteSauvegarde = this.genererInfosSiteDepuisResultSet(res);
                this.fermerAccesBD(ctx, stmt, res);
                return infosSiteSauvegarde;
            }
            catch (Throwable throwable) {
                this.fermerAccesBD(ctx, stmt, res);
                throw throwable;
            }
        }
        throw new ErreurDonneeNonTrouve("Aucune configuration infosSite ne correspond au code " + code);
    }

    public InfosSiteSauvegarde getInfosSiteSauvegarde(long idSite) throws Exception {
        block3: {
            ContexteDao ctx = this.instancierContexteDao();
            PreparedStatement stmt = null;
            ResultSet res = null;
            try {
                stmt = ctx.getConnection().prepareStatement(SELECT_PAR_ID);
                stmt.setLong(1, idSite);
                res = stmt.executeQuery();
                if (!res.next()) break block3;
                InfosSiteSauvegarde infosSiteSauvegarde = this.genererInfosSiteDepuisResultSet(res);
                this.fermerAccesBD(ctx, stmt, res);
                return infosSiteSauvegarde;
            }
            catch (Throwable throwable) {
                this.fermerAccesBD(ctx, stmt, res);
                throw throwable;
            }
        }
        throw new ErreurDonneeNonTrouve("Aucune configuration infosSite ne correspond \u00e0 l'identifiant " + idSite);
    }

    private InfosSiteSauvegarde genererInfosSiteDepuisResultSet(ResultSet res) throws Exception {
        InfosSiteSauvegarde sauvegarde = new InfosSiteSauvegarde();
        sauvegarde.idInfosSite = res.getLong("ID_USINESITE_INFOSSITE");
        sauvegarde.code = res.getString("CODE");
        sauvegarde.intitule = res.getString("INTITULE");
        sauvegarde.httpHostname = res.getString("HTTP_HOSTNAME");
        sauvegarde.httpPort = res.getInt("HTTP_PORT");
        sauvegarde.httpsHostname = res.getString("HTTPS_HOSTNAME");
        sauvegarde.httpsPort = res.getInt("HTTPS_PORT");
        sauvegarde.codeRubrique = res.getString("CODE_RUBRIQUE");
        sauvegarde.codeTemplate = res.getString("CODE_TEMPLATE");
        sauvegarde.isSitePrincipal = res.getBoolean("SITE_PRINCIPAL");
        sauvegarde.isActif = res.getBoolean("ETAT");
        sauvegarde.proprietesSites = CodecJSon.decodeStringJSonToClass(res.getString("PROPERIETES_SITE"), ProprietesSite.class);
        sauvegarde.proprietesTemplate = res.getString("PROPERIETES_TEMPLATE");
        sauvegarde.dateCreation = new Date(res.getTimestamp("DATE_CREATION").getTime());
        sauvegarde.dateDerniereModification = new Date(res.getTimestamp("DATE_DERNIERE_MODIFICATION").getTime());
        sauvegarde.codeCreateur = res.getString("CODE_CREATEUR");
        sauvegarde.codeDernierModificateur = res.getString("CODE_DERNIER_MODIFICATEUR");
        sauvegarde.historique = res.getString("HISTORIQUE");
        return sauvegarde;
    }

    @Override
    public Collection<InfosSite> getListeInfosSites() throws Exception {
        ArrayList<InfosSite> resultats = new ArrayList<InfosSite>();
        for (InfosSiteSauvegarde sauvegarde : this.getListeInfosSiteSauvegardes()) {
            resultats.add(InfosSiteCodec.decode(sauvegarde));
        }
        return resultats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InfosSiteSauvegarde> getListeInfosSiteSauvegardes() throws Exception {
        ContexteDao ctx = this.instancierContexteDao();
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            stmt = ctx.getConnection().prepareStatement(SELECT_TOUT);
            res = stmt.executeQuery();
            ArrayList<InfosSiteSauvegarde> listeSauvegardes = new ArrayList<InfosSiteSauvegarde>();
            while (res.next()) {
                InfosSiteSauvegarde sauvegarde = this.genererInfosSiteDepuisResultSet(res);
                listeSauvegardes.add(sauvegarde);
            }
            ArrayList<InfosSiteSauvegarde> arrayList = listeSauvegardes;
            this.fermerAccesBD(ctx, stmt, res);
            return arrayList;
        }
        catch (Throwable throwable) {
            this.fermerAccesBD(ctx, stmt, res);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void supprimer(String code) throws Exception {
        ContexteDao ctx = this.instancierContexteDao();
        PreparedStatement stmt = null;
        try {
            stmt = ctx.getConnection().prepareStatement(DELETE_PAR_CODE);
            stmt.setString(1, code);
            stmt.executeUpdate();
        }
        finally {
            this.fermerAccesBD(ctx, stmt);
        }
    }
}

