/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.migration.utils;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.migration.bean.InfosSiteSauvegarde;
import com.kosmos.usinesite.migration.bean.ProprietesSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.service.ServiceTemplateSiteFactory;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.utils.json.CodecJSon;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfosSiteCodec {
    private static Logger LOG = LoggerFactory.getLogger(InfosSiteCodec.class);

    public static InfosSite decode(InfosSiteSauvegarde sauvegarde) throws Exception {
        InfosSiteImpl infosSite = new InfosSiteImpl();
        InfosSiteCodec.mapperDonneesBasesDansInfosSite(infosSite, sauvegarde);
        InfosSiteCodec.mapperProprietesTemplateDansInfosSite(infosSite, sauvegarde);
        return infosSite;
    }

    private static void mapperDonneesBasesDansInfosSite(InfosSiteImpl infosSite, InfosSiteSauvegarde sauvegarde) {
        infosSite.setAlias(sauvegarde.code);
        infosSite.setIntitule(sauvegarde.intitule);
        infosSite.setHttpHostname(sauvegarde.httpHostname);
        infosSite.setHttpPort(sauvegarde.httpPort);
        infosSite.setHttpsHostname(sauvegarde.httpsHostname);
        infosSite.setHttpsPort(sauvegarde.httpsPort);
        infosSite.setCodeRubrique(sauvegarde.codeRubrique);
        infosSite.setActif(sauvegarde.isActif);
        infosSite.setCodeTemplate(sauvegarde.codeTemplate);
        ProprietesSite propSite = sauvegarde.proprietesSites;
        if (propSite == null) {
            return;
        }
        infosSite.setSslMode(propSite.sslMode);
        infosSite.setBoSslMode(propSite.boSslMode);
        infosSite.setRestriction(propSite.restriction);
        infosSite.setModeReecritureRubrique(propSite.modeReecritureRubrique);
        infosSite.setNiveauMaxReecritureRubrique(propSite.niveauMaxReecritureRubrique);
        infosSite.setNiveauMinReecritureRubrique(propSite.niveauMinReecritureRubrique);
        infosSite.setUrlAccueil(propSite.urlAccueil);
        infosSite.setSso(propSite.sso);
        infosSite.setSitePrincipal(propSite.sitePrincipal);
        infosSite.setHttpActions(new TreeSet<Integer>(propSite.httpActions));
        infosSite.setHttpsActions(new TreeSet<Integer>(propSite.httpsActions));
        infosSite.setListeHostAlias(propSite.listeHostAlias);
    }

    private static void mapperProprietesTemplateDansInfosSite(InfosSiteImpl infosSite, InfosSiteSauvegarde sauvegarde) throws Exception {
        String codeTemplate = sauvegarde.codeTemplate;
        if (StringUtils.isEmpty((CharSequence)codeTemplate)) {
            return;
        }
        try {
            TemplateSite template = ServiceTemplateSiteFactory.getServiceTemplateSite().getTemplateSiteParCode(codeTemplate);
            infosSite.setJspFo(template.getDossierJSP());
            InfosSiteCodec.mapperDonneesComplementairesTemplateDansInfosSite(infosSite, sauvegarde, template);
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.info("le template n'a pas \u00e9t\u00e9 trouv\u00e9 ", (Throwable)e);
        }
    }

    private static void mapperDonneesComplementairesTemplateDansInfosSite(InfosSiteImpl infosSite, InfosSiteSauvegarde sauvegarde, TemplateSite template) throws Exception {
        String propertiesJSonString = sauvegarde.proprietesTemplate;
        if (StringUtils.isEmpty((CharSequence)propertiesJSonString)) {
            return;
        }
        Map proprietesComplementaires = (Map)CodecJSon.decodeStringJSonToClass(propertiesJSonString, new HashMap().getClass());
        for (Map.Entry proprieteComplementaire : proprietesComplementaires.entrySet()) {
            infosSite.putProperty((String)proprieteComplementaire.getKey(), proprieteComplementaire.getValue());
        }
    }

    public static InfosSiteSauvegarde encode(InfosSite infosSite) throws Exception {
        return InfosSiteCodec.encode(infosSite, null);
    }

    public static InfosSiteSauvegarde encode(InfosSite infosSite, TemplateSite template) throws Exception {
        InfosSiteSauvegarde sauvegarde = new InfosSiteSauvegarde();
        InfosSiteCodec.mapperDonneesBasesDansSauvegarde(sauvegarde, infosSite);
        InfosSiteCodec.mapperProprietesComplementairesDansSauvegarde(sauvegarde, infosSite);
        InfosSiteCodec.mapperProprietesTemplateDansSauvegarde(sauvegarde, infosSite, template);
        return sauvegarde;
    }

    private static void mapperDonneesBasesDansSauvegarde(InfosSiteSauvegarde sauvegarde, InfosSite infosSite) {
        sauvegarde.code = infosSite.getAlias();
        sauvegarde.intitule = infosSite.getIntitule();
        sauvegarde.httpHostname = infosSite.getHttpHostname();
        sauvegarde.httpPort = infosSite.getHttpPort();
        sauvegarde.httpsHostname = infosSite.getHttpsHostname();
        sauvegarde.httpsPort = infosSite.getHttpsPort();
        sauvegarde.codeRubrique = infosSite.getCodeRubrique();
        sauvegarde.isSitePrincipal = infosSite.isSitePrincipal();
        sauvegarde.urlAccueil = infosSite.getUrlAccueil();
    }

    private static void mapperProprietesComplementairesDansSauvegarde(InfosSiteSauvegarde sauvegarde, InfosSite infosSite) {
        ProprietesSite propSite = new ProprietesSite();
        propSite.sslMode = infosSite.getSslMode();
        propSite.boSslMode = infosSite.getBoSslMode();
        propSite.restriction = infosSite.getRestriction();
        propSite.modeReecritureRubrique = infosSite.getModeReecritureRubrique();
        propSite.niveauMaxReecritureRubrique = infosSite.getNiveauMaxReecritureRubrique();
        propSite.niveauMinReecritureRubrique = infosSite.getNiveauMinReecritureRubrique();
        propSite.sso = infosSite.isSso();
        propSite.sitePrincipal = infosSite.isSitePrincipal();
        propSite.urlAccueil = infosSite.getUrlAccueil();
        propSite.httpActions = infosSite.getHttpActions();
        propSite.httpsActions = infosSite.getHttpsActions();
        propSite.listeHostAlias = infosSite.getListeHostAlias();
        sauvegarde.proprietesSites = propSite;
    }

    private static void mapperProprietesTemplateDansSauvegarde(InfosSiteSauvegarde sauvegarde, InfosSite infosSite, TemplateSite template) throws Exception {
        if (template == null) {
            return;
        }
        HashMap<String, Object> proprietesTemplate = new HashMap<String, Object>();
        for (TemplateSiteProperty property : template.getListeProprietesComplementaires()) {
            Object valeurProperty = infosSite.getProprieteComplementaire(property.getCode());
            if (valeurProperty == null) continue;
            proprietesTemplate.put(property.getCode(), valeurProperty);
        }
        sauvegarde.proprietesTemplate = CodecJSon.encodeObjectToJSonInString(proprietesTemplate);
        sauvegarde.codeTemplate = template.getCode();
    }
}

