/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurActionNonAutorisee;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.jsbsoft.jtf.exception.ErreurUtilisateurNonAuthentifie;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.processus.SaisieInfosSiteCommun;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.utils.InfosSiteHelper;
import com.kosmos.usinesite.utils.SaisieInfosSiteInfoBeanHelper;
import com.kosmos.usinesite.utils.UsineSiteComposantUtil;
import com.kportal.core.config.MessageHelper;
import com.kportal.extension.module.composant.ComposantUsineASite;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieInfosSite
extends SaisieInfosSiteCommun {
    public static final String CODE_SITE_DUPLIQUE = "CODE_SITE_DUPLIQUE";
    private static Logger LOG = LoggerFactory.getLogger(SaisieInfosSite.class);
    private ActionUtilisateur actionUtilisateur = ActionUtilisateur.AUCUNE;
    private EcranLogique ecranLogiqueHistorique = null;

    public SaisieInfosSite(InfoBean infoBean) {
        super(infoBean);
    }

    @Override
    protected boolean traiterAction() throws Exception {
        this.initialiserServices();
        this.actionUtilisateur = this.getActionUtilisateurDepuisInfosBean();
        this.ecranLogiqueHistorique = this.getEcranLogiqueHistorique();
        EcranLogique ecranDestination = null;
        try {
            this.verificationDroitUtilisateur();
            ecranDestination = this.traiterActionUtilisateur();
        }
        catch (ErreurApplicative e) {
            ecranDestination = this.traiterErreur(e);
        }
        return this.redirection(ecranDestination);
    }

    @Override
    protected void verificationDroitUtilisateur() throws ErreurUtilisateurNonAuthentifie, ErreurActionNonAutorisee {
        if (this.autorisations == null || StringUtils.isEmpty((CharSequence)this.autorisations.getCode())) {
            throw new ErreurUtilisateurNonAuthentifie();
        }
        if (!ComposantUsineASite.isAutoriseParActionProcessus(this.autorisations, this.actionUtilisateur.name())) {
            throw new ErreurActionNonAutorisee();
        }
    }

    private EcranLogique traiterErreur(ErreurApplicative e) throws Exception {
        if (e instanceof ErreurUtilisateurNonAuthentifie) {
            this.infoBean.setEcranRedirection("/servlet/com.jsbsoft.jtf.core.SG?PROC=IDENTIFICATION&ACTION=CONNECTER");
            return EcranLogique.LOGIN;
        }
        if (this.ecranLogiqueHistorique == EcranLogique.AUCUN) {
            this.infoBean.addMessageErreur(e.getMessage());
            return EcranLogique.ERREUR;
        }
        if (this.ecranLogiqueHistorique == EcranLogique.SAISIE) {
            if (e instanceof ErreursSaisieInfosSite) {
                ErreursSaisieInfosSite erreurs = (ErreursSaisieInfosSite)e;
                InfosSite infosSite = erreurs.getInfosSiteOrigineErreurs();
                TemplateSite template = erreurs.getTemplateInfossiteOrigineErreurs();
                if (infosSite == null) {
                    infosSite = new InfosSiteImpl();
                }
                this.setDonneesPourSaisieDansInfoBean(infosSite, template);
                this.infoBean.addMessageErreur(StringUtils.join(erreurs.getListeMessagesErreur(), (String)"\n"));
            } else {
                this.infoBean.addMessageErreur(e.getMessage());
            }
            if (ActionUtilisateur.VALIDER_AJOUTER.equals((Object)this.actionUtilisateur)) {
                this.infoBean.set("ETAT_INTERFACE_SAISIE", (Object)SaisieInfosSiteCommun.EtatInterfaceSaisie.CREATION);
            } else {
                this.infoBean.set("ETAT_INTERFACE_SAISIE", (Object)SaisieInfosSiteCommun.EtatInterfaceSaisie.MODIFICATION);
            }
            return this.ecranLogiqueHistorique;
        }
        this.infoBean.addMessageErreur(e.getMessage());
        return this.ecranLogiqueHistorique;
    }

    private ActionUtilisateur getActionUtilisateurDepuisInfosBean() {
        String actionString = this.infoBean.getActionUtilisateur();
        if (StringUtils.isEmpty((CharSequence)actionString)) {
            return ActionUtilisateur.AUCUNE;
        }
        try {
            actionString = actionString.toUpperCase();
            return ActionUtilisateur.valueOf(actionString);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("impossible de faire la correspondance entre le String et l ennumeration ActionUtilisateur", (Throwable)e);
            return ActionUtilisateur.AUCUNE;
        }
    }

    private EcranLogique getEcranLogiqueHistorique() {
        String ecranLogique = this.infoBean.getEcranLogique();
        if (StringUtils.isEmpty((CharSequence)ecranLogique)) {
            return EcranLogique.AUCUN;
        }
        try {
            ecranLogique = ecranLogique.toUpperCase();
            return EcranLogique.valueOf(ecranLogique);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("impossible de faire la correspondance entre le String et l ennumeration EcranLogique", (Throwable)e);
            return EcranLogique.AUCUN;
        }
    }

    @Override
    protected boolean possedePermissionModificationPourSite(InfosSite siteAVerifier) {
        PermissionBean permissionModification = UsineSiteComposantUtil.getPermissionModification();
        Perimetre perimetreFiche = new Perimetre("", siteAVerifier.getCodeRubrique(), "", "", "");
        boolean isAutorise = Boolean.FALSE;
        try {
            isAutorise = this.autorisations.isWebMaster() || this.autorisations.possedePermission(permissionModification, perimetreFiche);
        }
        catch (Exception e) {
            LOG.info("erreur lors de la r\u00e9cup\u00e9ration des droits par p\u00e9rim\u00e8tre", (Throwable)e);
        }
        return isAutorise;
    }

    @Override
    protected boolean possedePermissionGestionPourSite(InfosSite siteAVerifier) {
        PermissionBean permissionGestion = UsineSiteComposantUtil.getPermissionGestion();
        Perimetre perimetreFiche = new Perimetre("", siteAVerifier.getCodeRubrique(), "", "", "");
        boolean isAutorise = Boolean.FALSE;
        try {
            isAutorise = this.autorisations.isWebMaster() || this.autorisations.possedePermission(permissionGestion, perimetreFiche);
        }
        catch (Exception e) {
            LOG.info("erreur lors de la r\u00e9cup\u00e9ration des droits par p\u00e9rim\u00e8tre", (Throwable)e);
        }
        return isAutorise;
    }

    private EcranLogique traiterActionUtilisateur() throws Exception {
        if (this.actionUtilisateur == ActionUtilisateur.ACCUEIL) {
            this.listerInfosSite();
            return EcranLogique.LISTE;
        }
        if (this.actionUtilisateur == ActionUtilisateur.AJOUTER) {
            this.preparerAjoutInfosSite();
            return EcranLogique.SAISIE;
        }
        if (this.actionUtilisateur == ActionUtilisateur.DUPLIQUER) {
            this.preparerDuplicationInfosSite();
            return EcranLogique.SAISIE;
        }
        if (this.actionUtilisateur == ActionUtilisateur.MODIFIER) {
            this.preparerModificationInfosSite();
            return EcranLogique.SAISIE;
        }
        if (this.actionUtilisateur == ActionUtilisateur.VALIDER_AJOUTER) {
            this.validerAjouter();
            return EcranLogique.FIN;
        }
        if (this.actionUtilisateur == ActionUtilisateur.VALIDER_MODIFICATION) {
            this.validerModification();
            return EcranLogique.FIN;
        }
        if (this.actionUtilisateur == ActionUtilisateur.SUPPRIMER) {
            this.validerSuppression();
            return EcranLogique.FIN;
        }
        throw new ErreurActionNonAutorisee();
    }

    @Override
    protected void preparerDuplicationInfosSite() throws Exception {
        String code = this.getCodeDepuisInfoBean();
        try {
            InfosSiteImpl infosSiteADupliquer = (InfosSiteImpl)this.serviceInfosSite.getInfosSite(code);
            if (!this.possedePermissionGestionPourSite(infosSiteADupliquer)) {
                throw new ErreurActionNonAutorisee();
            }
            infosSiteADupliquer.setHttpHostname("");
            infosSiteADupliquer.setHttpsHostname("");
            infosSiteADupliquer.setAlias("");
            infosSiteADupliquer.setListeHostAlias(Collections.emptySet());
            infosSiteADupliquer.setSitePrincipal(Boolean.FALSE);
            infosSiteADupliquer.setActif(Boolean.FALSE);
            TemplateSite template = this.serviceTemplateSite.getTemplateSiteParCodeSite(code);
            this.setDonneesPourSaisieDansInfoBean(infosSiteADupliquer, template);
            this.infoBean.setTitreEcran(MessageHelper.getCoreMessage("USINESITE_DUPLICATION") + " " + infosSiteADupliquer.getIntitule());
            this.infoBean.set(CODE_SITE_DUPLIQUE, code);
        }
        catch (ErreurDonneeNonTrouve e) {
            this.setDonneesPourSaisieDansInfoBean(new InfosSiteImpl(), null);
        }
        this.infoBean.set("CODE", "");
        this.infoBean.set("ETAT_INTERFACE_SAISIE", (Object)SaisieInfosSiteCommun.EtatInterfaceSaisie.CREATION);
        this.infoBean.set("INFOSSITE_ACTIF", "0");
    }

    private boolean redirection(EcranLogique ecranDestination) {
        if (ecranDestination == EcranLogique.FIN) {
            this.etat = 2;
        } else {
            this.ecranLogique = ecranDestination.toString();
            this.infoBean.setEcranLogique(this.ecranLogique);
        }
        return this.etat == 2;
    }

    @Override
    protected void listerInfosSite() throws Exception {
        Collection<InfosSite> listeInfosSites = this.serviceInfosSite.getListeTousInfosSites();
        if (!this.autorisations.isWebMaster()) {
            CollectionUtils.filter(listeInfosSites, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    InfosSite siteCourant = (InfosSite)object;
                    return SaisieInfosSite.this.possedePermissionGestionPourSite(siteCourant) || SaisieInfosSite.this.possedePermissionModificationPourSite(siteCourant);
                }
            });
        }
        HashMap<String, TemplateSite> templatesParCodesTemplates = new HashMap<String, TemplateSite>();
        Collection codesTemplate = CollectionUtils.collect(listeInfosSites, (Transformer)new Transformer(){

            public String transform(Object input) {
                return ((InfosSite)input).getCodeTemplate();
            }
        });
        for (String codeTemplate : codesTemplate) {
            try {
                templatesParCodesTemplates.put(codeTemplate, this.serviceTemplateSite.getTemplateSiteParCode(codeTemplate));
            }
            catch (Exception e) {
                this.infoBean.addMessageAlerte(e.getMessage());
            }
        }
        this.infoBean.set("IS_GESTIONNAIRE_SITE", this.autorisations.possedePermission(UsineSiteComposantUtil.getPermissionGestion()) || this.autorisations.isWebMaster());
        this.infoBean.set("VALEURS_LISTE_TEMPLATE_INFOSSITE", templatesParCodesTemplates);
        this.infoBean.set("LISTE_INFOSSITES", listeInfosSites);
    }

    @Override
    protected void preparerAjoutInfosSite() throws Exception {
        InfosSiteImpl infosSiteVide = new InfosSiteImpl();
        this.setDonneesPourSaisieDansInfoBean(infosSiteVide, null);
        this.infoBean.set("ETAT_INTERFACE_SAISIE", (Object)SaisieInfosSiteCommun.EtatInterfaceSaisie.CREATION);
    }

    @Override
    protected void preparerModificationInfosSite() throws Exception {
        String code = this.getCodeDepuisInfoBean();
        InfosSite infosSite = this.serviceInfosSite.getInfosSite(code);
        try {
            if (!this.possedePermissionGestionPourSite(infosSite) && !this.possedePermissionModificationPourSite(infosSite)) {
                throw new ErreurActionNonAutorisee();
            }
            TemplateSite template = this.serviceTemplateSite.getTemplateSiteParCodeSite(code);
            this.setDonneesPourSaisieDansInfoBean(infosSite, template);
        }
        catch (ErreurDonneeNonTrouve e) {
            this.setDonneesPourSaisieDansInfoBean(infosSite, null);
        }
        this.infoBean.set("ETAT_INTERFACE_SAISIE", (Object)SaisieInfosSiteCommun.EtatInterfaceSaisie.MODIFICATION);
        this.infoBean.setTitreEcran(infosSite.getIntitule());
    }

    @Override
    protected void validerAjouter() throws Exception {
        InfosSiteImpl infosSite = new InfosSiteImpl();
        TemplateSite template = this.getTemplateDepuisInfosBean();
        SaisieInfosSiteInfoBeanHelper.peuplerInfosSiteDepuisInfoBean(this.infoBean, infosSite, template);
        SaisieInfosSite.verifierDonneesInfosSite(infosSite, template);
        if (!this.possedePermissionGestionPourSite(infosSite)) {
            throw new ErreurActionNonAutorisee();
        }
        String codeUtilisateur = this.autorisations.getCode();
        try {
            this.serviceInfosSite.creer(infosSite, codeUtilisateur);
            this.lancementTraitementsComplementairesTemplate(infosSite, template);
            this.updateFilesOnDuplication(infosSite);
        }
        catch (ErreurDonneeNonTrouve e) {
            throw new ErreursSaisieInfosSite(e.getMessage(), (InfosSite)infosSite, template);
        }
        this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_SITE"), infosSite.getIntitule()));
    }

    private void updateFilesOnDuplication(InfosSiteImpl infosSite) throws IOException {
        File oldSiteFilesDirectory;
        String codeSiteDuplique = this.infoBean.getString(CODE_SITE_DUPLIQUE);
        if (StringUtils.isNotBlank((CharSequence)codeSiteDuplique) && (oldSiteFilesDirectory = new File(InfosSiteHelper.getPathAbsoluFichiersTemplateDuSite(codeSiteDuplique))).exists()) {
            File newSiteFilesDirectory = new File(InfosSiteHelper.getPathAbsoluFichiersTemplateDuSite(infosSite.getAlias()));
            FileUtils.copyDirectory((File)oldSiteFilesDirectory, (File)newSiteFilesDirectory);
        }
    }

    @Override
    protected void validerSuppression() throws Exception {
        String code = this.getCodeDepuisInfoBean();
        InfosSiteImpl infosSite = (InfosSiteImpl)this.serviceInfosSite.getInfosSite(code);
        if (!this.possedePermissionGestionPourSite(infosSite)) {
            throw new ErreurActionNonAutorisee();
        }
        if (infosSite.isSitePrincipal()) {
            throw new ErreursSaisieInfosSite(MessageHelper.getCoreMessage("USINESITE_SAISIE_SUPPRESSION_SITE_PRINCIPAL"));
        }
        this.serviceInfosSite.supprimer(code);
        this.serviceInfosSite.supprimerTousFichiers(infosSite);
        this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage("CONFIRMATION_SUPPRESSION_SITE"), infosSite.getIntitule()));
    }

    @Override
    protected void preparerSuppressionInfosSite() throws Exception {
    }

    public static enum EcranLogique {
        ERREUR,
        LISTE,
        SAISIE,
        LOGIN,
        FIN,
        AUCUN;

    }

    public static enum ActionUtilisateur {
        AUCUNE,
        ACCUEIL,
        AJOUTER,
        MODIFIER,
        VALIDER_AJOUTER,
        VALIDER_MODIFICATION,
        SUPPRIMER,
        DUPLIQUER;

    }
}

