/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.processus;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.database.ProcessusBean;
import com.jsbsoft.jtf.exception.ErreurActionNonAutorisee;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.jsbsoft.jtf.exception.ErreurUtilisateurNonAuthentifie;
import com.jsbsoft.jtf.session.SessionUtilisateur;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty;
import com.kosmos.usinesite.template.property.service.ServiceTemplateSitePropertyFactory;
import com.kosmos.usinesite.template.property.traitement.TemplateSitePropertyTraitement;
import com.kosmos.usinesite.template.service.ServiceTemplateSite;
import com.kosmos.usinesite.template.service.ServiceTemplateSiteFactory;
import com.kosmos.usinesite.utils.InfosSiteHelper;
import com.kosmos.usinesite.utils.SaisieInfosSiteInfoBeanHelper;
import com.kosmos.usinesite.utils.UsineSiteComposantUtil;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.Site;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.service.ServiceInfosSite;
import com.univ.multisites.service.ServiceInfosSiteFactory;
import com.univ.objetspartages.om.AutorisationBean;
import com.univ.objetspartages.om.Perimetre;
import com.univ.objetspartages.om.PermissionBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SaisieInfosSiteCommun
extends ProcessusBean {
    private static Logger LOG = LoggerFactory.getLogger(SaisieInfosSiteCommun.class);
    protected static final String MESSAGE_ERREUR_CODE_NON_PRESENT_INFOBEAN = "BO_USINESITE_ERREUR_CODE_NON_PRESENT_INFOBEAN";
    public static final String INFOBEAN_LISTE_INFOSSITES = "LISTE_INFOSSITES";
    public static final String INFOBEAN_IS_GESTIONNAIRE_SITE = "IS_GESTIONNAIRE_SITE";
    public static final String INFOBEAN_INFOSSITE = "INFOSSITE";
    public static final String INFOBEAN_CONTENU_SOURCE = "CONTENU_SOURCE";
    public static final String INFOBEAN_ETAT_INTERFACE_SAISIE = "ETAT_INTERFACE_SAISIE";
    public static final String INFOBEAN_INFOSSITE_ACTIF = "INFOSSITE_ACTIF";
    public static final String INFOBEAN_ACTION = "ACTION";
    public static final String INFOBEAN_CODE = "CODE";
    public static final String INFOBEAN_INTITULE = "INTITULE";
    public static final String INFOBEAN_INTITULE_RUBRIQUE = "INTITULE_RUBRIQUE";
    public static final String INFOBEAN_CODE_RUBRIQUE = "CODE_RUBRIQUE";
    public static final String INFOBEAN_CODE_RUBRIQUE_SOURCE = "CODE_RUBRIQUE_SOURCE";
    public static final String INFOBEAN_PRINCIPAL = "PRINCIPAL";
    public static final String INFOBEAN_ACTIF = "ACTIF";
    public static final String INFOBEAN_HTTP_HOSTNAME = "HTTP_HOSTNAME";
    public static final String INFOBEAN_HTTP_PORT = "HTTP_PORT";
    public static final String INFOBEAN_HTTPS_HOSTNAME = "HTTPS_HOSTNAME";
    public static final String INFOBEAN_HTTPS_PORT = "HTTPS_PORT";
    public static final String INFOBEAN_MODE_SSL = "MODE_SSL";
    public static final String INFOBEAN_BO_MODE_SSL = "BO_MODE_SSL";
    public static final String INFOBEAN_ACTIONS_HTTP = "ACTIONS_HTTP";
    public static final String INFOBEAN_ACTIONS_HTTPS = "ACTIONS_HTTPS";
    public static final String INFOBEAN_ALIAS = "ALIAS";
    public static final String INFOBEAN_PAGE_ACCUEIL = "PAGE_ACCUEIL";
    public static final String INFOBEAN_MODE_REECRITURE = "MODE_REECRITURE";
    public static final String INFOBEAN_NIVEAU_REECRITURE_MIN = "NIVEAU_REECRITURE_MIN";
    public static final String INFOBEAN_NIVEAU_REECRITURE_MAX = "NIVEAU_REECRITURE_MAX";
    public static final String INFOBEAN_RESTREINT = "RESTREINT";
    public static final String INFOBEAN_SSO = "SSO";
    public static final String INFOBEAN_TEMPLATE = "TEMPLATE";
    public static final String INFOBEAN_VALEURS_MODE_SSL = "VALEURS_MODE_SSL";
    public static final String INFOBEAN_VALEURS_MODE_BO_SSL = "VALEURS_MODE_BO_SSL";
    public static final String INFOBEAN_VALEURS_ACTIONS_HTTP = "VALEURS_ACTIONS_HTTP";
    public static final String INFOBEAN_VALEURS_ACTIONS_HTTPS = "VALEURS_ACTIONS_HTTPS";
    public static final String INFOBEAN_VALEURS_MODE_REECRITURE_RUBRIQUE = "MODE_REECRITURE_RUBRIQUE";
    public static final String INFOBEAN_VALEURS_TEMPLATE_INFOSSITE = "VALEURS_TEMPLATE_INFOSSITE";
    public static final String INFOBEAN_VALEURS_LISTE_TEMPLATES_INFOSSITE = "VALEURS_LISTE_TEMPLATE_INFOSSITE";
    public static final String INFOBEAN_TYPE_SUPPRESSION = "TYPE_SUPPRESSION";
    public static final String INFOBEAN_SUPPRESSION_RUBRIQUE = "SUPPRESSION_RUBRIQUE";
    public static final String INFOBEAN_NO_ARBO = "NO_ARBO";
    public static final String INFOBEAN_WITH_ENCADRE = "WITH_ENCADRE";
    public static final String INFOBEAN_WITH_FORMULAIRE = "WITH_FORMULAIRE";
    public static final String INFOBEAN_WITH_NEWSLETTER = "WITH_NEWSLETTER";
    public static final String INFOBEAN_WITH_MEDIA = "WITH_MEDIA";
    public static final String INFOBEAN_WITH_FIL = "WITH_FIL";
    public static final String INFOBEAN_LISTE_CODE_OBJET = "LISTE_CODE_OBJET";
    public static final String INFOBEAN_CLE_CODE_OBJET_TOUS = "TOUSLESOBJETS";
    protected AutorisationBean autorisations = null;
    protected ServiceInfosSite serviceInfosSite = null;
    protected ServiceTemplateSite serviceTemplateSite = null;
    protected ServiceTemplateSiteProperty serviceTemplateSiteProperty = null;

    public SaisieInfosSiteCommun(InfoBean infoBean) {
        super(infoBean);
    }

    protected void initialiserServices() {
        SessionUtilisateur session = this.getGp().getSessionUtilisateur();
        if (session == null) {
            return;
        }
        this.autorisations = (AutorisationBean)session.getInfos().get("AUTORISATIONS");
        this.serviceInfosSite = ServiceInfosSiteFactory.getServiceInfosSite();
        this.serviceTemplateSite = ServiceTemplateSiteFactory.getServiceTemplateSite();
        this.serviceTemplateSiteProperty = ServiceTemplateSitePropertyFactory.getServiceTemplateSite();
    }

    protected abstract void verificationDroitUtilisateur() throws ErreurUtilisateurNonAuthentifie, ErreurActionNonAutorisee;

    protected boolean possedePermissionModificationPourSite(InfosSite siteAVerifier) {
        PermissionBean permissionModification = UsineSiteComposantUtil.getPermissionModification();
        Perimetre perimetreFiche = new Perimetre("", siteAVerifier.getCodeRubrique(), "", "", "");
        boolean isAutorise = Boolean.FALSE;
        try {
            isAutorise = this.autorisations.isWebMaster() || this.autorisations.possedePermission(permissionModification, perimetreFiche);
        }
        catch (Exception e) {
            LOG.info("erreur lors de la r\u00e9cup\u00e9ration des droits par p\u00e9rim\u00e8tre", (Throwable)e);
        }
        return isAutorise;
    }

    protected boolean possedePermissionGestionPourSite(InfosSite siteAVerifier) {
        PermissionBean permissionGestion = UsineSiteComposantUtil.getPermissionGestion();
        Perimetre perimetreFiche = new Perimetre("", siteAVerifier.getCodeRubrique(), "", "", "");
        boolean isAutorise = Boolean.FALSE;
        try {
            isAutorise = this.autorisations.isWebMaster() || this.autorisations.possedePermission(permissionGestion, perimetreFiche);
        }
        catch (Exception e) {
            LOG.info("erreur lors de la r\u00e9cup\u00e9ration des droits par p\u00e9rim\u00e8tre", (Throwable)e);
        }
        return isAutorise;
    }

    protected abstract void preparerDuplicationInfosSite() throws Exception;

    protected abstract void preparerSuppressionInfosSite() throws Exception;

    protected void listerInfosSite() throws Exception {
        Collection<InfosSite> listeInfosSites = this.serviceInfosSite.getListeTousInfosSites();
        if (!this.autorisations.isWebMaster()) {
            CollectionUtils.filter(listeInfosSites, (Predicate)new Predicate(){

                public boolean evaluate(Object object) {
                    InfosSite siteCourant = (InfosSite)object;
                    return SaisieInfosSiteCommun.this.possedePermissionGestionPourSite(siteCourant) || SaisieInfosSiteCommun.this.possedePermissionModificationPourSite(siteCourant);
                }
            });
        }
        HashMap<String, TemplateSite> templatesParCodesTemplates = new HashMap<String, TemplateSite>();
        Collection codesTemplate = CollectionUtils.collect(listeInfosSites, (Transformer)new Transformer(){

            public String transform(Object input) {
                return ((InfosSite)input).getCodeTemplate();
            }
        });
        for (String codeTemplate : codesTemplate) {
            templatesParCodesTemplates.put(codeTemplate, this.serviceTemplateSite.getTemplateSiteParCode(codeTemplate));
        }
        this.infoBean.set(INFOBEAN_IS_GESTIONNAIRE_SITE, this.autorisations.possedePermission(UsineSiteComposantUtil.getPermissionGestion()) || this.autorisations.isWebMaster());
        this.infoBean.set(INFOBEAN_VALEURS_LISTE_TEMPLATES_INFOSSITE, templatesParCodesTemplates);
        this.infoBean.set(INFOBEAN_LISTE_INFOSSITES, listeInfosSites);
    }

    protected void preparerAjoutInfosSite() throws Exception {
        InfosSiteImpl infosSiteVide = new InfosSiteImpl();
        this.setDonneesPourSaisieDansInfoBean(infosSiteVide, null);
        this.infoBean.set(INFOBEAN_ETAT_INTERFACE_SAISIE, (Object)EtatInterfaceSaisie.CREATION);
    }

    protected void setDonneesPourSaisieDansInfoBean(InfosSite infosSite, TemplateSite template) throws Exception {
        this.infoBean.set(INFOBEAN_INFOSSITE, infosSite);
        this.infoBean.set(INFOBEAN_VALEURS_TEMPLATE_INFOSSITE, template);
        this.infoBean.set(INFOBEAN_VALEURS_LISTE_TEMPLATES_INFOSSITE, this.serviceTemplateSite.getListeTemplatesSite());
        this.infoBean.set(INFOBEAN_VALEURS_MODE_SSL, InfosSiteHelper.SSL_MODE);
        this.infoBean.set(INFOBEAN_VALEURS_MODE_BO_SSL, InfosSiteHelper.BO_SSL_MODE);
        this.infoBean.set(INFOBEAN_VALEURS_ACTIONS_HTTP, InfosSiteHelper.HTTP_ACTIONS);
        this.infoBean.set(INFOBEAN_VALEURS_ACTIONS_HTTPS, InfosSiteHelper.HTTPS_ACTIONS);
        this.infoBean.set(INFOBEAN_VALEURS_MODE_REECRITURE_RUBRIQUE, InfosSiteHelper.MODE_REECRITURE_RUBRIQUE);
    }

    protected void preparerModificationInfosSite() throws Exception {
        String code = this.getCodeDepuisInfoBean();
        InfosSite infosSite = this.serviceInfosSite.getInfosSite(code);
        try {
            if (!this.possedePermissionGestionPourSite(infosSite) && !this.possedePermissionModificationPourSite(infosSite)) {
                throw new ErreurActionNonAutorisee();
            }
            TemplateSite template = this.serviceTemplateSite.getTemplateSiteParCodeSite(code);
            this.setDonneesPourSaisieDansInfoBean(infosSite, template);
        }
        catch (ErreurDonneeNonTrouve e) {
            this.setDonneesPourSaisieDansInfoBean(infosSite, null);
        }
        this.infoBean.set(INFOBEAN_ETAT_INTERFACE_SAISIE, (Object)EtatInterfaceSaisie.MODIFICATION);
        this.infoBean.setTitreEcran(infosSite.getIntitule());
    }

    protected void validerAjouter() throws Exception {
        InfosSiteImpl infosSite = new InfosSiteImpl();
        TemplateSite template = this.getTemplateDepuisInfosBean();
        SaisieInfosSiteInfoBeanHelper.peuplerInfosSiteDepuisInfoBean(this.infoBean, infosSite, template);
        SaisieInfosSiteCommun.verifierDonneesInfosSite(infosSite, template);
        if (!this.possedePermissionGestionPourSite(infosSite)) {
            throw new ErreurActionNonAutorisee();
        }
        String codeUtilisateur = this.autorisations.getCode();
        try {
            this.serviceInfosSite.creer(infosSite, codeUtilisateur);
            this.lancementTraitementsComplementairesTemplate(infosSite, template);
        }
        catch (ErreurDonneeNonTrouve e) {
            throw new ErreursSaisieInfosSite(e.getMessage(), (InfosSite)infosSite, template);
        }
        this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage("CONFIRMATION_CREATION_SITE"), infosSite.getIntitule()));
    }

    protected TemplateSite getTemplateDepuisInfosBean() throws Exception {
        String codeTemplate = this.infoBean.getString(INFOBEAN_TEMPLATE);
        if (StringUtils.isEmpty((CharSequence)codeTemplate)) {
            return null;
        }
        try {
            return this.serviceTemplateSite.getTemplateSiteParCode(codeTemplate);
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.debug("le template n'existe pas", (Throwable)e);
            return null;
        }
    }

    public static void verifierDonneesInfosSite(InfosSiteImpl infosSite, TemplateSite template) throws Exception {
        ArrayList<String> fluxMessagesErreurs = new ArrayList<String>();
        if (infosSite.getNiveauMinReecritureRubrique() > infosSite.getNiveauMaxReecritureRubrique()) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage("BO_USINESITE_ERREUR_NIVEAU_REECRITURE_INVALIDE"));
        }
        if (infosSite.isSitePrincipal() && !infosSite.isActif()) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage("BO_USINESITE_ERREUR_SITE_PRINCIPAL_INACTIF"));
        }
        if (!fluxMessagesErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxMessagesErreurs, (InfosSite)infosSite, template);
        }
    }

    protected void validerModification() throws Exception {
        String code = this.getCodeDepuisInfoBean();
        InfosSiteImpl infosSite = (InfosSiteImpl)this.serviceInfosSite.getInfosSite(code);
        if (!this.possedePermissionModificationPourSite(infosSite) && !this.possedePermissionGestionPourSite(infosSite)) {
            throw new ErreurActionNonAutorisee();
        }
        InfosSite sitePrincipal = Site.getSitePrincipal();
        TemplateSite template = this.getTemplateDepuisInfosBean();
        SaisieInfosSiteInfoBeanHelper.peuplerInfosSiteDepuisInfoBean(this.infoBean, infosSite, template);
        SaisieInfosSiteCommun.verifierDonneesInfosSite(infosSite, template);
        if (this.infoBean.get(INFOBEAN_PRINCIPAL) != null && sitePrincipal != null && !code.equals(sitePrincipal.getAlias())) {
            if (!this.possedePermissionModificationPourSite(sitePrincipal) && !this.possedePermissionGestionPourSite(sitePrincipal)) {
                throw new ErreurActionNonAutorisee();
            }
            InfosSiteImpl ancienSitePrincipal = (InfosSiteImpl)sitePrincipal;
            ancienSitePrincipal.setSitePrincipal(Boolean.FALSE);
            TemplateSite templateAncienSitePrincipal = this.serviceTemplateSite.getTemplateSiteParCode(ancienSitePrincipal.getCodeTemplate());
            this.serviceInfosSite.modifier(ancienSitePrincipal, templateAncienSitePrincipal);
        }
        String codeUtilisateur = this.autorisations.getCode();
        try {
            this.serviceInfosSite.modifier(infosSite, template, codeUtilisateur);
            this.lancementTraitementsComplementairesTemplate(infosSite, template);
            this.serviceInfosSite.cleanFichiers(infosSite);
        }
        catch (ErreurDonneeNonTrouve e) {
            throw new ErreursSaisieInfosSite(e.getMessage(), (InfosSite)infosSite, template);
        }
        this.infoBean.addMessageConfirmation(String.format(MessageHelper.getCoreMessage("CONFIRMATION_MODIFICATION_SITE"), infosSite.getIntitule()));
    }

    protected void lancementTraitementsComplementairesTemplate(InfosSiteImpl infosSite, TemplateSite template) throws Exception {
        if (template == null) {
            return;
        }
        for (TemplateSiteProperty property : template.getListeProprietesComplementaires()) {
            try {
                TemplateSitePropertyTraitement<TemplateSiteProperty> traitement = this.serviceTemplateSiteProperty.getTemplateSitePropertyTraitement(property);
                traitement.traiter(infosSite, template, property, this.infoBean);
            }
            catch (ErreurDonneeNonTrouve e) {
                LOG.debug("la propri\u00e9t\u00e9 n'a pas \u00e9t\u00e9 trouv\u00e9", (Throwable)e);
            }
        }
    }

    protected abstract void validerSuppression() throws Exception;

    protected String getCodeDepuisInfoBean() throws ErreurActionNonAutorisee {
        String code = this.infoBean.getString(INFOBEAN_CODE);
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new ErreurActionNonAutorisee(MessageHelper.getCoreMessage(MESSAGE_ERREUR_CODE_NON_PRESENT_INFOBEAN));
        }
        return code;
    }

    public static enum EtatInterfaceSaisie {
        CREATION,
        MODIFICATION;

    }
}

