/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.reference.impl;

import com.jsbsoft.jtf.database.JDBCUtils;
import com.kosmos.usinesite.exception.ErreurReferenceException;
import com.kosmos.usinesite.reference.BeanReference;
import com.kosmos.usinesite.reference.ModuleReferenceHelper;
import com.kosmos.usinesite.reference.ServiceBeanReference;
import com.kosmos.usinesite.reference.impl.MediaServiceBeanReference;
import com.kosmos.usinesite.reference.impl.RessourceServiceBeanReference;
import com.kosmos.usinesite.reference.impl.RubriquePublicationServiceBeanReference;
import com.kosmos.usinesite.reference.processor.ReferenceProcessor;
import com.kosmos.usinesite.utils.UASOmHelper;
import com.kportal.extension.module.bean.FicheBeanExport;
import com.univ.objetspartages.bean.AbstractPersistenceBean;
import com.univ.objetspartages.bean.MediaBean;
import com.univ.objetspartages.bean.RessourceBean;
import com.univ.objetspartages.bean.RubriquepublicationBean;
import com.univ.objetspartages.om.AbstractOm;
import com.univ.objetspartages.om.AnnuaireModele;
import com.univ.objetspartages.om.FicheUniv;
import com.univ.objetspartages.om.ReferentielObjets;
import com.univ.objetspartages.om.StructureModele;
import com.univ.utils.ContexteDao;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FicheServiceBeanReference
implements ServiceBeanReference {
    protected static final String ID_META_ON_CONTENT = "\"id_meta\":\"%1$s\"";
    protected static final String ID_METATAG_ON_META = "\"id_metatag\":\"%1$s\"";
    protected static final String CODE_ON_RUB_PUB = "\"code_fiche_orig\":\"%1$s\"";
    protected static final String CODE_ON_CODEPARENT = ",CODE=%1$s\"";
    protected static final String CODE_ON_FICHEUNIV = "\"code\":\"%1$s\"";
    protected static final String ID_ON_META_ID_FICHE = "\"meta_id_fiche\":\"%1$s\"";
    protected static final String CODE_ON_META_CODE = "\"meta_code\":\"%1$s\"";
    protected static final String CODE_RATTACHEMENT_ON_META_CODE_RATTACHEMENT = "\"meta_code_rattachement\":\"%1$s\"";
    protected static final String ID_ON_CODEPARENT = "\"%1$s,TYPE=";
    protected static final String CODE_RATTACHEMENT_ON_CONTENT = "\"(code_rattachement|code_structure)\":\"%1$s\"";
    protected static final String CODE_RATTACHEMENT_AUTRES_ON_CONTENT = "\"code_rattachement_autres\":\"(.*;)?%1$s(;.*)?\"";
    protected static final String CODE_RATTACHEMENT_ON_TOOLBOX = "(codeRattachement|CODE_RATTACHEMENT)=%1$s(#|&|;|\\]|\\[)";
    protected static final String ANNUAIRE_ON_TOOLBOX = "\\[mailto\\]email=annuaire;%1$s\\[\\/mailto\\]";

    @Override
    public synchronized Collection<BeanReference> check(Map<String, ? extends Serializable> beansOrig, ReferenceProcessor processor) throws ErreurReferenceException {
        Long maxIdMeta;
        Long maxIdFiche;
        ArrayList<BeanReference> referencesToUpdate = new ArrayList<BeanReference>();
        FicheBeanExport ficheBean = (FicheBeanExport)beansOrig.values().iterator().next();
        List<String> moduleToSearch = Arrays.asList(ficheBean.getIdModule());
        BeanReference referencesById = new BeanReference();
        referencesById.addModulesBySearchString(ID_ON_CODEPARENT, moduleToSearch);
        referencesById.addModulesBySearchString(ID_ON_META_ID_FICHE, moduleToSearch);
        BeanReference referencesByCode = new BeanReference();
        referencesByCode.addModulesBySearchString(CODE_ON_FICHEUNIV, moduleToSearch);
        referencesByCode.addModulesBySearchString(CODE_ON_CODEPARENT, moduleToSearch);
        referencesByCode.addModulesBySearchString(CODE_ON_RUB_PUB, moduleToSearch);
        referencesByCode.addModulesBySearchString(CODE_ON_META_CODE, moduleToSearch);
        BeanReference beanRefMetatag = new BeanReference();
        beanRefMetatag.addModulesBySearchString(ID_METATAG_ON_META, Collections.emptyList());
        beanRefMetatag.addModulesBySearchString(ID_META_ON_CONTENT, Collections.emptyList());
        if (ReferentielObjets.instancierFiche(ficheBean.getTypeObjet()) instanceof StructureModele) {
            referencesByCode.addModulesBySearchString(CODE_RATTACHEMENT_ON_META_CODE_RATTACHEMENT, Collections.emptyList());
            referencesByCode.addModulesBySearchString(CODE_RATTACHEMENT_ON_CONTENT, Collections.emptyList());
            referencesByCode.addModulesBySearchString(CODE_RATTACHEMENT_AUTRES_ON_CONTENT, Collections.emptyList());
            referencesByCode.addModulesBySearchString(CODE_RATTACHEMENT_ON_TOOLBOX, Collections.emptyList());
        }
        if (ReferentielObjets.instancierFiche(ficheBean.getTypeObjet()) instanceof AnnuaireModele) {
            referencesByCode.addModulesBySearchString(ANNUAIRE_ON_TOOLBOX, Collections.emptyList());
        }
        ModuleReferenceHelper.addAllModules(ficheBean.getIdModule(), referencesById, referencesByCode);
        String nomTableSql = ReferentielObjets.getNomTableSql(ReferentielObjets.getCodeObjet(ficheBean.getTypeObjet()));
        try (ContexteDao ctxUtils = new ContexteDao();){
            maxIdFiche = JDBCUtils.getNextAutoIncrement(ctxUtils.getConnection(), nomTableSql, beansOrig.keySet().size());
            maxIdMeta = JDBCUtils.getNextAutoIncrement(ctxUtils.getConnection(), "METATAG", beansOrig.keySet().size());
        }
        catch (Exception e) {
            throw new ErreurReferenceException("Une erreur est survenue lors de la r\u00e9servation des cl\u00e9s primaires.", e);
        }
        HashMap<String, MediaBean> medias = new HashMap<String, MediaBean>();
        HashMap ressources = new HashMap();
        HashMap rubPubs = new HashMap();
        for (String objetCodeLangue : beansOrig.keySet()) {
            ficheBean = (FicheBeanExport)beansOrig.get(objetCodeLangue);
            try {
                ContexteDao ctx = new ContexteDao();
                Throwable throwable = null;
                try {
                    HashMap<String, Serializable> map;
                    FicheUniv ficheUniv = this.updateFicheUnivValues(ficheBean);
                    ficheUniv.setCtx(ctx);
                    referencesById.addNewValueByOldValue(ficheUniv.getIdFiche().toString(), Long.toString(maxIdFiche));
                    referencesById.addModulesBySearchString("\"id_" + nomTableSql.toLowerCase() + "\":\"" + "%1$s" + "\"", moduleToSearch);
                    referencesByCode.addModulesBySearchString("\\[id-fiche\\]" + nomTableSql.toLowerCase() + ";{1,2}" + "%1$s" + "(;.)?\\[\\/id-fiche\\]", Collections.emptyList());
                    referencesByCode.addModulesBySearchString("\\[" + nomTableSql.toLowerCase() + ";" + "%1$s" + "(;.)?\\]", Collections.emptyList());
                    referencesByCode.addNewValueByOldValue(ficheUniv.getCode(), String.valueOf(System.nanoTime()));
                    beanRefMetatag.addNewValueByOldValue(String.valueOf(ficheBean.getMetatag().getIdMetatag()), String.valueOf(maxIdMeta));
                    if (processor != null) {
                        processor.process(ficheUniv.getCode(), ficheBean.getMetatag().getMetaCode(), ficheBean.getTypeObjet(), maxIdMeta, ficheBean.getMetatag().getIdMetatag());
                    }
                    if (MapUtils.isNotEmpty(ficheBean.getMedias())) {
                        medias.putAll(ficheBean.getMedias());
                    }
                    if (CollectionUtils.isNotEmpty(ficheBean.getRessources())) {
                        map = new HashMap<String, Serializable>();
                        for (RessourceBean ressourceBean : ficheBean.getRessources()) {
                            map.put(ressourceBean.getIdRessource().toString(), ressourceBean);
                        }
                        ressources.putAll(map);
                    }
                    if (CollectionUtils.isNotEmpty(ficheBean.getRubriquespublication())) {
                        map = new HashMap();
                        for (RubriquepublicationBean rubriquepublicationBean : ficheBean.getRubriquespublication()) {
                            map.put(rubriquepublicationBean.getIdRubriquepublication().toString(), rubriquepublicationBean);
                        }
                        rubPubs.putAll(map);
                    }
                    Long l = maxIdFiche;
                    maxIdFiche = maxIdFiche - 1L;
                    Object object = maxIdFiche;
                    l = maxIdMeta;
                    maxIdMeta = maxIdMeta - 1L;
                    object = maxIdMeta;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ctx == null) continue;
                    if (throwable != null) {
                        try {
                            ctx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ctx.close();
                }
            }
            catch (Exception e) {
                throw new ErreurReferenceException("erreur lors du calcul des r\u00e9f\u00e9rences", e);
            }
        }
        referencesToUpdate.add(referencesById);
        referencesToUpdate.add(referencesByCode);
        Collection<BeanReference> referencesByResources = this.checkExternalReferences(new RessourceServiceBeanReference(), ressources, "\"id_ressource\":\"%1$s\"", moduleToSearch, processor);
        referencesToUpdate.addAll(referencesByResources);
        MediaServiceBeanReference mediaServiceBeanRef = new MediaServiceBeanReference();
        mediaServiceBeanRef.addSearchStringForBean(ficheBean, moduleToSearch);
        Collection<BeanReference> referencesByMedia = this.checkExternalReferences(mediaServiceBeanRef, medias, "", Collections.emptyList(), processor);
        referencesToUpdate.addAll(referencesByMedia);
        referencesToUpdate.add(beanRefMetatag);
        Collection<BeanReference> referencesByRubPub = this.checkExternalReferences(new RubriquePublicationServiceBeanReference(), rubPubs, "\"id_rubriquepublication\":\"%1$s\"", moduleToSearch, processor);
        referencesToUpdate.addAll(referencesByRubPub);
        return referencesToUpdate;
    }

    private <T extends AbstractPersistenceBean> FicheUniv updateFicheUnivValues(FicheBeanExport<?> beanAMapper) throws IllegalAccessException, InvocationTargetException {
        FicheUniv ficheUniv = ReferentielObjets.instancierFiche(beanAMapper.getTypeObjet());
        ficheUniv.init();
        if (ficheUniv instanceof AbstractOm) {
            AbstractOm fiche = (AbstractOm)((Object)ficheUniv);
            Class<?> clazz = fiche.getPersistenceBean().getClass();
            fiche.setPersistenceBean((AbstractPersistenceBean)clazz.cast(beanAMapper.getBean()));
        } else {
            UASOmHelper.copyProperties(ficheUniv, beanAMapper.getBean());
        }
        return ficheUniv;
    }

    private Collection<BeanReference> checkExternalReferences(ServiceBeanReference serviceToCheck, Map<String, ? extends Serializable> beanstoCheck, String searchString, Collection<String> moduleToSearch, ReferenceProcessor processor) throws ErreurReferenceException {
        Collection<BeanReference> references = serviceToCheck.check(beanstoCheck, processor);
        if (StringUtils.isNotBlank((CharSequence)searchString)) {
            for (BeanReference beanRef : references) {
                beanRef.addModulesBySearchString(searchString, moduleToSearch);
            }
        }
        return references;
    }
}

