/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.service.impl;

import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.jsbsoft.jtf.exception.ErreurUniciteNonRespectee;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.utils.InfosSiteHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.multisites.dao.InfosSiteDao;
import com.univ.multisites.service.ServiceInfosSite;
import com.univ.objetspartages.cache.CacheInfosSiteManager;
import com.univ.url.CacheUrlManager;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInfosSiteProcessus
implements ServiceInfosSite {
    private static Logger LOG = LoggerFactory.getLogger(ServiceInfosSiteProcessus.class);
    protected InfosSiteDao infosSiteDao = null;

    public void setInfosSiteDao(InfosSiteDao infosSiteDao) {
        this.infosSiteDao = infosSiteDao;
    }

    @Override
    public void creer(InfosSiteImpl infosSite) throws Exception {
        this.creer(infosSite, null);
    }

    @Override
    public void creer(InfosSiteImpl infosSite, String codeUtilisateur) throws Exception {
        this.verfierUniciteCode(infosSite);
        this.checkHostUnicity(infosSite);
        this.peuplerDonneesSauvegardeEnCreation(infosSite, codeUtilisateur);
        this.infosSiteDao.creer(infosSite);
        this.flushAllCaches();
    }

    private void peuplerDonneesSauvegardeEnCreation(InfosSiteImpl nouvelleSauvegarde, String codeUtilisateur) {
        if (codeUtilisateur == null) {
            codeUtilisateur = "";
        }
        nouvelleSauvegarde.setCodeCreateur(codeUtilisateur);
        nouvelleSauvegarde.setDateCreation(new Date());
        nouvelleSauvegarde.setCodeDernierModificateur(codeUtilisateur);
        nouvelleSauvegarde.setDateDerniereModification(new Date());
    }

    @Override
    public void modifier(InfosSiteImpl infosSite, TemplateSite template) throws Exception {
        this.modifier(infosSite, template, null);
    }

    @Override
    public void modifier(InfosSiteImpl nouvelleSauvegarde, TemplateSite template, String codeUtilisateur) throws Exception {
        InfosSite sauvegardeOriginale = this.infosSiteDao.getInfosSite(nouvelleSauvegarde.getAlias());
        this.peuplerDonneesSauvegardeEnModification(nouvelleSauvegarde, sauvegardeOriginale, codeUtilisateur);
        this.verfierUniciteCode(nouvelleSauvegarde);
        this.checkHostUnicity(nouvelleSauvegarde);
        this.infosSiteDao.miseAJour(nouvelleSauvegarde);
        this.flushAllCaches();
    }

    @Override
    public void supprimer(String code) throws Exception {
        this.infosSiteDao.supprimer(code);
        this.flushAllCaches();
    }

    @Override
    public InfosSite getInfosSite(String code) throws Exception {
        return this.infosSiteDao.getInfosSite(code);
    }

    @Override
    public Collection<InfosSite> getListeTousInfosSites() throws Exception {
        return this.infosSiteDao.getListeInfosSites();
    }

    @Override
    public void enregistrerFichier(InfosSite infosSite, File fichierTemporaireSource, String nomPropertyTemplateSite) throws Exception {
        try {
            String pathFichier = InfosSiteHelper.getPathAbsoluFichierPropertyTemplate(infosSite, nomPropertyTemplateSite);
            File fichierUploade = new File(pathFichier);
            if (fichierUploade.exists()) {
                fichierUploade.delete();
            }
            FileUtils.moveFile((File)fichierTemporaireSource, (File)fichierUploade);
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.info("impossible de trouver le chemin du fichier", (Throwable)e);
        }
    }

    @Override
    public void supprimerFichier(InfosSite infosSite, String nomPropertyTemplateSite) throws Exception {
        try {
            String pathFichier = InfosSiteHelper.getPathAbsoluFichierPropertyTemplate(infosSite, nomPropertyTemplateSite);
            File fichierASupprimer = new File(pathFichier);
            if (fichierASupprimer.exists()) {
                fichierASupprimer.delete();
            }
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.info("impossible de trouver le chemin du fichier", (Throwable)e);
        }
    }

    @Override
    public void supprimerTousFichiers(InfosSite infosSite) throws IOException {
        String pathDossier = InfosSiteHelper.getPathAbsoluFichiersTemplateDuSite(infosSite);
        File dossierDepot = new File(pathDossier);
        if (dossierDepot.exists()) {
            FileUtils.deleteDirectory((File)dossierDepot);
        }
    }

    @Override
    public void cleanFichiers(InfosSite infosSite) throws IOException {
        String pathDossier = InfosSiteHelper.getPathAbsoluFichiersTemplateDuSite(infosSite);
        File dossierDepot = new File(pathDossier);
        if (!dossierDepot.exists()) {
            return;
        }
        for (File dossierPropertyTemplate : dossierDepot.listFiles()) {
            if (!dossierPropertyTemplate.isDirectory()) {
                dossierPropertyTemplate.delete();
                continue;
            }
            String nomPropertyTemplate = dossierPropertyTemplate.getName();
            Object valeurPropertyTemplate = infosSite.getProprieteComplementaire(nomPropertyTemplate);
            if (valeurPropertyTemplate == null || !(valeurPropertyTemplate instanceof String) || StringUtils.isEmpty((CharSequence)((String)valeurPropertyTemplate))) {
                FileUtils.deleteDirectory((File)dossierPropertyTemplate);
                continue;
            }
            String nomFichierAttendu = (String)valeurPropertyTemplate;
            for (File fichierContenuDansDossier : dossierPropertyTemplate.listFiles()) {
                if (fichierContenuDansDossier.isDirectory()) {
                    FileUtils.deleteDirectory((File)fichierContenuDansDossier);
                    continue;
                }
                String nomFichier = fichierContenuDansDossier.getName();
                if (StringUtils.equalsIgnoreCase((CharSequence)nomFichierAttendu, (CharSequence)nomFichier)) continue;
                fichierContenuDansDossier.delete();
            }
        }
        if (dossierDepot.listFiles().length == 0) {
            FileUtils.deleteDirectory((File)dossierDepot);
        }
    }

    private void peuplerDonneesSauvegardeEnModification(InfosSiteImpl nouvelleSauvegarde, InfosSite sauvegardeOriginale, String codeUtilisateur) {
        if (codeUtilisateur == null) {
            codeUtilisateur = "";
        }
        nouvelleSauvegarde.setIdInfosSite(sauvegardeOriginale.getIdInfosSite());
        nouvelleSauvegarde.setCodeCreateur(sauvegardeOriginale.getCodeCreateur());
        nouvelleSauvegarde.setDateCreation(sauvegardeOriginale.getDateCreation());
        nouvelleSauvegarde.setCodeDernierModificateur(codeUtilisateur);
        nouvelleSauvegarde.setDateDerniereModification(new Date());
        nouvelleSauvegarde.setHistorique(sauvegardeOriginale.toString());
    }

    private void verfierUniciteCode(InfosSite sauvegarde) throws Exception {
        String code = sauvegarde.getAlias();
        try {
            InfosSite sauvegardeBis = this.infosSiteDao.getInfosSite(code);
            if (sauvegarde.getIdInfosSite() == sauvegardeBis.getIdInfosSite()) {
                return;
            }
        }
        catch (ErreurDonneeNonTrouve e) {
            return;
        }
        throw new ErreurUniciteNonRespectee("Code '" + code + "' d\u00e9j\u00e0 utilis\u00e9 pour un autre site.");
    }

    private void checkHostUnicity(InfosSite infosSite) throws Exception {
        for (InfosSite currentInfosSite : this.getListeTousInfosSites()) {
            if (currentInfosSite.getAlias().equals(infosSite.getAlias())) continue;
            if (StringUtils.isNotBlank((CharSequence)infosSite.getHttpHostname()) && (infosSite.getHttpHostname().equals(currentInfosSite.getHttpHostname()) || infosSite.getHttpHostname().equals(currentInfosSite.getHttpsHostname()))) {
                throw new ErreursSaisieInfosSite("Le host http '" + infosSite.getHttpHostname() + "' est d\u00e9j\u00e0 utilis\u00e9 pour le site " + currentInfosSite.getAlias(), infosSite, null);
            }
            if (!StringUtils.isNotBlank((CharSequence)infosSite.getHttpsHostname()) || !infosSite.getHttpsHostname().equals(currentInfosSite.getHttpHostname()) && !infosSite.getHttpsHostname().equals(currentInfosSite.getHttpsHostname())) continue;
            throw new ErreursSaisieInfosSite("Le host https '" + infosSite.getHttpsHostname() + "' est d\u00e9j\u00e0 utilis\u00e9 pour le site " + currentInfosSite.getAlias(), infosSite, null);
        }
    }

    private void flushAllCaches() {
        CacheInfosSiteManager.getInstance().asyncRefresh();
        CacheUrlManager.getInstance().asyncRefresh();
    }
}

