/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.servlet;

import com.kportal.core.webapp.WebAppUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FichiersUASServlet
extends HttpServlet {
    private static final long serialVersionUID = -8038208278480906860L;
    private static final Logger LOG = LoggerFactory.getLogger(FichiersUASServlet.class);
    private static final int DEFAULT_BUFFER_SIZE = 10240;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestedFile = request.getPathInfo();
        if (requestedFile == null) {
            response.sendError(404);
            return;
        }
        File file = new File(WebAppUtil.getAbsoluteFichiersSitesPath(), URLDecoder.decode(requestedFile, "UTF-8"));
        if (!file.exists()) {
            response.sendError(404);
            return;
        }
        String contentType = this.getServletContext().getMimeType(file.getName());
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.reset();
        response.setBufferSize(10240);
        response.setContentType(contentType);
        response.setHeader("Content-Length", String.valueOf(file.length()));
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        BufferedInputStream input = null;
        BufferedOutputStream output = null;
        try {
            int length;
            input = new BufferedInputStream(new FileInputStream(file), 10240);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream(), 10240);
            byte[] buffer = new byte[10240];
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            FichiersUASServlet.close(output);
            FichiersUASServlet.close(input);
            throw throwable;
        }
        FichiersUASServlet.close(output);
        FichiersUASServlet.close(input);
    }

    private static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException e) {
                LOG.error("impossible de fermer la ressource", (Throwable)e);
            }
        }
    }
}

