/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.formateur.impl;

import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyMultiRubrique;
import com.kosmos.usinesite.template.property.formateur.TemplateSitePropertyHTMLFormateur;
import com.kosmos.usinesite.utils.FrontUASHelper;
import com.univ.multisites.InfosSite;
import com.univ.objetspartages.om.Rubrique;
import com.univ.tree.processus.RubriquesJsTree;
import com.univ.utils.EscapeString;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang3.StringUtils;

public class TemplateSitePropertyMultiRubriqueHTMLFormateur
implements TemplateSitePropertyHTMLFormateur<TemplateSitePropertyMultiRubrique> {
    @Override
    public String formater(InfosSite infosSite, TemplateSite template, TemplateSitePropertyMultiRubrique property, FormateurJSP fmt, InfoBean data) throws Exception {
        String nomComponsant = FrontUASHelper.genererNameInputProprieteTemplate(template, property);
        List<String> valeur = infosSite.getProprieteComplementaireListString(property.getCode());
        if (valeur == null) {
            valeur = property.getValeurDefaut();
        }
        StringBuilder kMultiSelect = new StringBuilder("<div>");
        kMultiSelect.append("<strong class=\"label colonne ").append(property.isObligatoire() ? "obligatoire" : "").append("\">").append(property.libelle).append(property.isObligatoire() ? " (*)" : "").append("</strong>");
        kMultiSelect.append("<div id=\"kmultiselect").append(nomComponsant).append("\" class=\"kmultiselect-ttl \" ").append("data-addAction=\"/adminsite/tree/tree.jsp?JSTREEBEAN=rubriquesJsTree&DISPLAY=full&SELECTED={0}&CODE={1}\" data-popintitle=\"LOCALE_BO.popin.title.rubrique.multi\" ").append("data-popinwidth=\"530\" data-popinvalidate=\"true\">");
        kMultiSelect.append("<input type=\"hidden\" id =\"").append(nomComponsant).append("\" name=\"").append(nomComponsant).append("\" value=\"").append(EscapeString.escapeAttributHtml(StringUtils.join(valeur, (String)";"))).append("\" ").append(property.isObligatoire() ? "required=\"required\"" : "").append("/>\n");
        kMultiSelect.append("<input type=\"hidden\" name=\"LIBELLE_").append(nomComponsant).append("\" value=\"").append(EscapeString.escapeAttributHtml(this.getLibelleSelection(valeur))).append("\"/>\n");
        kMultiSelect.append("<input type=\"hidden\" name=\"ARIANE_").append(nomComponsant).append("\" value=\"").append(EscapeString.escapeAttributHtml(this.getFilAriane(valeur))).append("\"/>\n");
        kMultiSelect.append("<div class=\"kscrollable\">");
        kMultiSelect.append("<ul class=\"ui-sortable kmultiselect-list kmultiselect-composition-list\">");
        kMultiSelect.append("</ul>");
        kMultiSelect.append("</div>");
        kMultiSelect.append("</div>");
        kMultiSelect.append("</div>");
        return kMultiSelect.toString();
    }

    private String getLibelleSelection(List<String> valeur) {
        return StringUtils.join((Iterable)CollectionUtils.collect(valeur, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String codeRubrique = (String)input;
                return Rubrique.getIntitule(codeRubrique);
            }
        }), (String)";");
    }

    private String getFilAriane(List<String> valeur) {
        return StringUtils.join((Iterable)CollectionUtils.collect(valeur, (Transformer)new Transformer(){

            public Object transform(Object input) {
                String codeRubrique = (String)input;
                return RubriquesJsTree.getPath("", codeRubrique, " > ");
            }
        }), (String)";");
    }
}

