/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.AbstractTemplateSiteProperty;
import com.univ.multisites.InfosSite;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractTemplateSitePropertyStringValidateur {
    protected static final String MSG_ERREUR_PROPRIETE_NON_AUTORISEE = "La propri\u00e9t\u00e9 '%s' du template contient une valeur non autoris\u00e9e : '%s'";
    protected static final String MSG_ERREUR_PROPRIETE_INVALIDE = "La propri\u00e9t\u00e9 '%s' du template contient une valeur invalide : '%s'";
    protected static final String MSG_ERREUR_PROPRIETE_TAILLE = "La propri\u00e9t\u00e9 '%s' du template d\u00e9passe les %d caract\u00e9res.";

    protected void testChampObligatoire(String valeur, AbstractTemplateSiteProperty property, ArrayList<String> fluxErreurs) {
        if (property.isObligatoire() && StringUtils.isEmpty((CharSequence)valeur)) {
            String messageErreur = String.format("La propri\u00e9t\u00e9 du template '%s' est obligatoire.", property.getLibelle());
            fluxErreurs.add(messageErreur);
        }
    }

    protected void testTailleMaximum(String valeur, int tailleMaximum, String libelle, ArrayList<String> fluxErreurs) {
        if (StringUtils.isEmpty((CharSequence)valeur) || tailleMaximum == 0) {
            return;
        }
        if (StringUtils.length((CharSequence)valeur) > tailleMaximum) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_TAILLE, libelle, tailleMaximum);
            fluxErreurs.add(messageErreur);
        }
    }

    protected void testRegExp(String valeur, String regExpValidation, String libelle, ArrayList<String> fluxErreurs) {
        if (StringUtils.isEmpty((CharSequence)valeur)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)regExpValidation)) {
            return;
        }
        if (!valeur.matches(regExpValidation)) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_INVALIDE, libelle, valeur);
            fluxErreurs.add(messageErreur);
        }
    }

    protected void testListeValeurs(String valeur, Collection<String> listeValeursAutorisees, String libelle, ArrayList<String> fluxErreurs) {
        if (StringUtils.isEmpty((CharSequence)valeur)) {
            return;
        }
        if (CollectionUtils.isEmpty(listeValeursAutorisees)) {
            return;
        }
        if (!listeValeursAutorisees.contains(valeur)) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_NON_AUTORISEE, libelle, valeur);
            fluxErreurs.add(messageErreur);
        }
    }

    protected void traiterFluxErreurs(ArrayList<String> fluxErreurs, InfosSite infosSite, TemplateSite template) throws ErreursSaisieInfosSite {
        if (!fluxErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxErreurs, infosSite, template);
        }
    }
}

