/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyChoixMultiple;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.template.utils.TemplateSiteHelper;
import com.univ.multisites.InfosSite;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class TemplateSitePropertyChoixMultipleValidateur
implements TemplateSitePropertyValidateur<TemplateSitePropertyChoixMultiple> {
    private static final String MSG_ERREUR_PROPRIETE_TAILLE_MIN = "La propri\u00e9t\u00e9 '%s' du template n'a pas le nombre minimal de valeurs souhait\u00e9 : %d";
    private static final String MSG_ERREUR_PROPRIETE_TAILLE_MAX = "La propri\u00e9t\u00e9 '%s' du template n'a pas le nombre maximal de valeurs souhait\u00e9 : %d";
    private static final String MSG_ERREUR_CODE_INEXISTANT = "Le code '%s' n'existe pas dans la liste des choix";

    @Override
    public void valider(InfosSite infosSite, TemplateSite template, TemplateSitePropertyChoixMultiple property, InfoBean data) throws Exception {
        ArrayList<String> fluxErreurs = new ArrayList<String>();
        Collection<String> valeurs = TemplateSiteHelper.getChoixMultipleTemplateSiteProperty(template, property, data);
        this.testerChampObligatoire(valeurs, property, fluxErreurs);
        this.testerNombreValeurs(valeurs, property, fluxErreurs);
        this.testerValiditeCodes(valeurs, property, fluxErreurs);
        this.traiterFluxErreurs(fluxErreurs, infosSite, template);
    }

    private void testerChampObligatoire(Collection<String> valeurs, TemplateSitePropertyChoixMultiple property, ArrayList<String> fluxErreurs) {
        if (property.isObligatoire() && CollectionUtils.isEmpty(valeurs)) {
            fluxErreurs.add(String.format("La propri\u00e9t\u00e9 du template '%s' est obligatoire.", property.getLibelle()));
        }
    }

    private void testerValiditeCodes(Collection<String> valeurs, TemplateSitePropertyChoixMultiple property, ArrayList<String> fluxErreurs) {
        for (String v : valeurs) {
            if (property.getValeurs().keySet().contains(v)) continue;
            fluxErreurs.add(String.format(MSG_ERREUR_CODE_INEXISTANT, v));
        }
    }

    private void testerNombreValeurs(Collection<String> valeurs, TemplateSitePropertyChoixMultiple property, ArrayList<String> fluxErreurs) {
        if (valeurs.size() < property.getNombreElementMin()) {
            fluxErreurs.add(String.format(MSG_ERREUR_PROPRIETE_TAILLE_MIN, property.getLibelle(), property.getNombreElementMin()));
        }
        if (valeurs.size() > property.getNombreElementMax()) {
            fluxErreurs.add(String.format(MSG_ERREUR_PROPRIETE_TAILLE_MAX, property.getLibelle(), property.getNombreElementMax()));
        }
    }

    protected void traiterFluxErreurs(ArrayList<String> fluxErreurs, InfosSite infosSite, TemplateSite template) throws ErreursSaisieInfosSite {
        if (!fluxErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxErreurs, infosSite, template);
        }
    }
}

