/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyChoixValeur;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.template.utils.TemplateSiteHelper;
import com.univ.multisites.InfosSite;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class TemplateSitePropertyChoixValeurValidateur
implements TemplateSitePropertyValidateur<TemplateSitePropertyChoixValeur> {
    protected static final String MSG_ERREUR_PROPRIETE_NON_AUTORISEE = "La propri\u00e9t\u00e9 '%s' du template contient une valeur non autoris\u00e9e : '%s'";

    @Override
    public void valider(InfosSite infosSite, TemplateSite template, TemplateSitePropertyChoixValeur property, InfoBean data) throws Exception {
        String valeur = TemplateSiteHelper.getStringTemplateSiteProperty(template, property, data);
        ArrayList<String> fluxErreurs = new ArrayList<String>();
        this.testChampObligatoire(valeur, property, fluxErreurs);
        this.testListeValeurs(valeur, property, fluxErreurs);
        this.traiterFluxErreurs(fluxErreurs, infosSite, template);
    }

    protected void testChampObligatoire(String valeur, TemplateSitePropertyChoixValeur property, ArrayList<String> fluxErreurs) {
        if (property.isObligatoire() && StringUtils.isEmpty((CharSequence)valeur)) {
            String messageErreur = String.format("La propri\u00e9t\u00e9 du template '%s' est obligatoire.", property.getLibelle());
            fluxErreurs.add(messageErreur);
        }
    }

    protected void testListeValeurs(String valeur, TemplateSitePropertyChoixValeur property, ArrayList<String> fluxErreurs) {
        if (StringUtils.isEmpty((CharSequence)valeur)) {
            return;
        }
        for (Map.Entry<String, String> choixPossible : property.getListeValeurs()) {
            if (!choixPossible.getKey().equals(valeur)) continue;
            return;
        }
        String messageErreur = String.format(MSG_ERREUR_PROPRIETE_NON_AUTORISEE, property.getLibelle(), valeur);
        fluxErreurs.add(messageErreur);
    }

    protected void traiterFluxErreurs(ArrayList<String> fluxErreurs, InfosSite infosSite, TemplateSite template) throws ErreursSaisieInfosSite {
        if (!fluxErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxErreurs, infosSite, template);
        }
    }
}

