/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyFichier;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.template.utils.FichierSimpleUpload;
import com.kosmos.usinesite.template.utils.TemplateSiteHelper;
import com.univ.multisites.InfosSite;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateSitePropertyFichierValidateur
implements TemplateSitePropertyValidateur<TemplateSitePropertyFichier> {
    private static final String MSG_ERREUR_PROPRIETE_EXTENTION = "Le fichier de la propri\u00e9t\u00e9 '%s' du template n'a pas une extention valide.";
    private static final String MSG_ERREUR_PROPRIETE_TAILLE = "Le fichier de la propri\u00e9t\u00e9 '%s' du template d\u00e9passe les %dko autoris\u00e9s.";

    @Override
    public void valider(InfosSite infosSite, TemplateSite template, TemplateSitePropertyFichier property, InfoBean data) throws Exception {
        FichierSimpleUpload fichierSimpleUpload = TemplateSiteHelper.getFichierSimpleUploadTemplateSiteProperty(template, property, data);
        this.testerFichier(fichierSimpleUpload, infosSite, template, property);
    }

    private void testerFichier(FichierSimpleUpload fichierSimpleUpload, InfosSite infosSite, TemplateSite template, TemplateSitePropertyFichier property) throws ErreursSaisieInfosSite {
        ArrayList<String> fluxErreurs = new ArrayList<String>();
        this.testChampObligatoire(fichierSimpleUpload, property, fluxErreurs);
        this.testExtention(fichierSimpleUpload, property, fluxErreurs);
        this.testTaille(fichierSimpleUpload, property, fluxErreurs);
        this.traiterFluxErreurs(fluxErreurs, infosSite, template);
    }

    private void testChampObligatoire(FichierSimpleUpload fichierSimpleUpload, TemplateSitePropertyFichier property, ArrayList<String> fluxErreurs) {
        if (property.isObligatoire() && (fichierSimpleUpload == null || fichierSimpleUpload.isSansFichier || StringUtils.isEmpty((CharSequence)fichierSimpleUpload.intituleFichier))) {
            String messageErreur = String.format("La propri\u00e9t\u00e9 du template '%s' est obligatoire.", property.getLibelle());
            fluxErreurs.add(messageErreur);
        }
    }

    private void testExtention(FichierSimpleUpload fichierSimpleUpload, TemplateSitePropertyFichier property, ArrayList<String> fluxErreurs) {
        if (CollectionUtils.isEmpty(property.getListeExtensionsAutorisees())) {
            return;
        }
        if (fichierSimpleUpload == null || fichierSimpleUpload.isSansFichier || StringUtils.isEmpty((CharSequence)fichierSimpleUpload.intituleFichier)) {
            return;
        }
        String nomFichier = fichierSimpleUpload.intituleFichier;
        boolean isExtentionOk = Boolean.FALSE;
        for (String extention : property.getListeExtensionsAutorisees()) {
            if (!StringUtils.endsWith((CharSequence)nomFichier, (CharSequence)("." + extention))) continue;
            isExtentionOk = Boolean.TRUE;
            break;
        }
        if (!isExtentionOk) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_EXTENTION, property.getLibelle());
            fluxErreurs.add(messageErreur);
        }
    }

    private void testTaille(FichierSimpleUpload fichierSimpleUpload, TemplateSitePropertyFichier property, ArrayList<String> fluxErreurs) {
        if (fichierSimpleUpload == null || fichierSimpleUpload.isSansFichier || StringUtils.isEmpty((CharSequence)fichierSimpleUpload.intituleFichier)) {
            return;
        }
        if (!fichierSimpleUpload.isNouveauFichier || fichierSimpleUpload.fichierUploade == null || !fichierSimpleUpload.fichierUploade.exists()) {
            return;
        }
        if (fichierSimpleUpload.fichierUploade.length() > property.getTailleMaximumFichier() * 1024L) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_TAILLE, property.getLibelle(), property.getTailleMaximumFichier());
            fluxErreurs.add(messageErreur);
        }
    }

    protected void traiterFluxErreurs(ArrayList<String> fluxErreurs, InfosSite infosSite, TemplateSite template) throws ErreursSaisieInfosSite {
        if (!fluxErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxErreurs, infosSite, template);
        }
    }
}

