/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.property.validateur.impl;

import com.jsbsoft.jtf.core.InfoBean;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.impl.TemplateSitePropertyListeString;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.template.property.validateur.impl.AbstractTemplateSitePropertyStringValidateur;
import com.kosmos.usinesite.template.utils.TemplateSiteHelper;
import com.univ.multisites.InfosSite;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;

public class TemplateSitePropertyListeStringValidateur
extends AbstractTemplateSitePropertyStringValidateur
implements TemplateSitePropertyValidateur<TemplateSitePropertyListeString> {
    private static final String MSG_ERREUR_PROPRIETE_TAILLE_MIN = "La propri\u00e9t\u00e9 '%s' du template n'a pas le nombre minimal de valeurs souhait\u00e9 : %d";
    private static final String MSG_ERREUR_PROPRIETE_TAILLE_MAX = "La propri\u00e9t\u00e9 '%s' du template n'a pas le nombre maximal de valeurs souhait\u00e9 : %d";
    protected static final String MSG_ERREUR_PROPRIETE_NON_AUTORISEE = "La propri\u00e9t\u00e9 '%s' du template contient une valeur non autoris\u00e9e : '%s'";
    protected static final String MSG_ERREUR_PROPRIETE_INVALIDE = "La propri\u00e9t\u00e9 '%s' du template contient une valeur invalide : '%s'";
    protected static final String MSG_ERREUR_PROPRIETE_TAILLE = "La propri\u00e9t\u00e9 '%s' du template d\u00e9passe les %d caract\u00e9res.";

    @Override
    public void valider(InfosSite infosSite, TemplateSite template, TemplateSitePropertyListeString property, InfoBean data) throws Exception {
        Collection<String> listeValeurs = TemplateSiteHelper.getListeStringTemplateSiteProperty(template, property, data);
        this.testerListeValeursString(listeValeurs, infosSite, template, property);
    }

    private void testerListeValeursString(Collection<String> listeValeurs, InfosSite infosSite, TemplateSite template, TemplateSitePropertyListeString property) throws Exception, ErreursSaisieInfosSite {
        ArrayList<String> fluxErreurs = new ArrayList<String>();
        this.testChampObligatoire(listeValeurs, property, fluxErreurs);
        this.testTailleListe(listeValeurs, property, fluxErreurs);
        for (String valeur : listeValeurs) {
            this.testTailleMaximum(valeur, property.getTailleMaximum(), property.getLibelle(), fluxErreurs);
            this.testRegExp(valeur, property.getRegExpValidation(), property.getLibelle(), fluxErreurs);
            this.testListeValeurs(valeur, property.getListeValeursAutorisees(), property.getLibelle(), fluxErreurs);
        }
        this.traiterFluxErreurs(fluxErreurs, infosSite, template);
    }

    private void testChampObligatoire(Collection<String> listeValeurs, TemplateSitePropertyListeString property, ArrayList<String> fluxErreurs) {
        if (property.isObligatoire() && CollectionUtils.isEmpty(listeValeurs)) {
            String messageErreur = String.format("La propri\u00e9t\u00e9 du template '%s' est obligatoire.", property.getLibelle());
            fluxErreurs.add(messageErreur);
        }
    }

    private void testTailleListe(Collection<String> listeValeurs, TemplateSitePropertyListeString property, ArrayList<String> fluxErreurs) {
        if (CollectionUtils.isEmpty(listeValeurs)) {
            return;
        }
        if (CollectionUtils.size(listeValeurs) < property.getNombreElementMin()) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_TAILLE_MIN, property.getLibelle(), property.getNombreElementMin());
            fluxErreurs.add(messageErreur);
        } else if (CollectionUtils.size(listeValeurs) > property.getNombreElementMax()) {
            String messageErreur = String.format(MSG_ERREUR_PROPRIETE_TAILLE_MAX, property.getLibelle(), property.getNombreElementMax());
            fluxErreurs.add(messageErreur);
        }
    }
}

