/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.template.utils;

import com.jsbsoft.jtf.core.FormateurJSP;
import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.upload.UploadedFile;
import com.kosmos.usinesite.template.utils.FichierSimpleUpload;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.utils.EscapeString;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ComposantFichierSimpleUpload {
    private static final String SUFFIXE_FILEUPLOAD = "_FILE";
    private static final String SUFFIXE_NOM_FICHIER_ORIGINAL = "_ORI";

    public static void initialiserInfoBean(String nomComponsant, String intituleFichierOrginal, InfoBean data) {
        if (StringUtils.isNotEmpty((CharSequence)intituleFichierOrginal)) {
            String nameInputFichierOriginal = ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComponsant);
            data.set(nameInputFichierOriginal, intituleFichierOrginal);
        }
    }

    public static FichierSimpleUpload getFichierSimpleUploadDepuisInfoBean(String nomComposant, InfoBean data) {
        FichierSimpleUpload fichierSimpleUpload = new FichierSimpleUpload();
        fichierSimpleUpload.code = nomComposant;
        UploadedFile uploadedFile = (UploadedFile)data.get(ComposantFichierSimpleUpload.getNameInputFichier(nomComposant));
        if (uploadedFile != null) {
            String intituleFichierUploade = uploadedFile.toString();
            String nomFichierUploadePhysique = uploadedFile.getTemporaryFile().getName();
            ComposantFichierSimpleUpload.setDonneesDansFichierSimpleUploadPourFichierUploade(fichierSimpleUpload, intituleFichierUploade, nomFichierUploadePhysique);
        } else if (data.get(ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant)) != null) {
            String nameInputFichierOriginal = ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant);
            fichierSimpleUpload.intituleFichier = data.getString(nameInputFichierOriginal);
            fichierSimpleUpload.isNouveauFichier = Boolean.FALSE;
            fichierSimpleUpload.isSansFichier = Boolean.FALSE;
        } else {
            fichierSimpleUpload.isNouveauFichier = Boolean.FALSE;
            fichierSimpleUpload.isSansFichier = Boolean.TRUE;
        }
        return fichierSimpleUpload;
    }

    private static void setDonneesDansFichierSimpleUploadPourFichierUploade(FichierSimpleUpload fichierSimpleUpload, String intituleFichierUploade, String nomFichierUploadePhysique) {
        fichierSimpleUpload.isNouveauFichier = Boolean.TRUE;
        fichierSimpleUpload.isSansFichier = Boolean.FALSE;
        fichierSimpleUpload.intituleFichier = intituleFichierUploade;
        String pathAbsoluFichier = WebAppUtil.getUploadDefaultPath() + File.separator + nomFichierUploadePhysique;
        fichierSimpleUpload.fichierUploade = new File(pathAbsoluFichier);
    }

    public static String genererChampsHTMLFichierSimpleUpload(String nomComposant, String libelle, FormateurJSP fmt, InfoBean data, boolean obligatoire) {
        StringBuilder out = new StringBuilder();
        out.append("<div class=\"fichier_simple\" id=\"");
        out.append(nomComposant);
        out.append("\">");
        ComposantFichierSimpleUpload.ecrireLabel(out, nomComposant, libelle, obligatoire);
        boolean existeFichier = ComposantFichierSimpleUpload.existeFichierUploade(nomComposant, data);
        ComposantFichierSimpleUpload.ecrireInputHiddenFormatKPortal(out, fmt, nomComposant, libelle, obligatoire);
        String nomFichierOriginal = "";
        String classFichierExiste = "fileupload-new";
        if (existeFichier) {
            String nameInputFichierOriginal = ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant);
            nomFichierOriginal = data.getString(nameInputFichierOriginal);
            classFichierExiste = "fileupload-exists";
        }
        out.append("<div class=\"fileupload ").append(classFichierExiste).append("\" data-name=\"").append(nomComposant).append(SUFFIXE_FILEUPLOAD).append("\">");
        out.append("<div class=\"input-append\">");
        out.append("<div class=\"uneditable-input span3\"><span class=\"fileupload-preview\">").append(nomFichierOriginal).append("</span></div>");
        out.append("<span class=\"btn btn-file\">");
        out.append("<span class=\"fileupload-new\">").append(MessageHelper.getCoreMessage("ST_AJOUT_FICHIER")).append("</span>");
        out.append("<span class=\"fileupload-exists\">").append(MessageHelper.getCoreMessage("JTF_BOUTON_MODIFIER")).append("</span>");
        out.append("<input type=\"file\" />");
        out.append("</span>");
        ComposantFichierSimpleUpload.ecrireInputHidden(out, ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant), nomFichierOriginal);
        out.append("<button type=\"button\" class=\"btn fileupload-exists\" data-hiddeninputname=\"").append(ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant)).append("\" data-dismiss=\"fileupload\">").append(MessageHelper.getCoreMessage("JTF_BOUTON_SUPPRIMER")).append("</button>");
        out.append("</div></div>");
        out.append("</div>");
        return out.toString();
    }

    private static void ecrireLabel(StringBuilder out, String nomComposant, String libelle, boolean obligatoire) {
        if (obligatoire) {
            out.append("<label for=\"").append(StringUtils.lowerCase((String)nomComposant)).append("\" class=\"colonne\" >");
            out.append("<span class=\"obligatoire\">").append(libelle).append(" *</span>");
            out.append("</label>");
        } else {
            out.append("<label for=\"").append(StringUtils.lowerCase((String)nomComposant)).append("\"  class=\"colonne\" >").append(libelle).append("</label>");
        }
    }

    private static void ecrireInputHiddenFormatKPortal(StringBuilder out, FormateurJSP fmt, String nomComposant, String libelle, boolean obligatoire) {
        int indiceChamp = fmt.getIndiceChamp();
        ++indiceChamp;
        out.append("<div class=\"masquer\">");
        out.append("<input type=\"hidden\" value=\"");
        if (obligatoire) {
            out.append(2);
        } else {
            out.append(1);
        }
        out.append(";9;0;0;LIB=");
        out.append(EscapeString.escapeAttributHtml(libelle));
        out.append(";");
        out.append(indiceChamp);
        out.append("\" name=\"#FORMAT_");
        out.append(nomComposant);
        out.append("\"/>");
        out.append("</div>");
        fmt.setIndiceChamp(indiceChamp);
    }

    private static String getNameInputFichier(String nomComposant) {
        return nomComposant + SUFFIXE_FILEUPLOAD;
    }

    private static boolean existeFichierUploade(String nomComposant, InfoBean data) {
        return data.get(ComposantFichierSimpleUpload.getNameInputFichier(nomComposant)) != null || data.get(ComposantFichierSimpleUpload.getNameInputFichierOriginal(nomComposant)) != null;
    }

    private static String getNameInputFichierOriginal(String nameInput) {
        return nameInput + SUFFIXE_NOM_FICHIER_ORIGINAL;
    }

    private static void ecrireInputHidden(StringBuilder out, String nameInput, String valueInput) {
        out.append("<input id=\"");
        out.append(nameInput);
        out.append("\" type=\"hidden\" name=\"");
        out.append(nameInput);
        out.append("\" value=\"");
        out.append(EscapeString.escapeAttributHtml(valueInput));
        out.append("\"/>");
    }
}

