/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.utils;

import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kportal.core.config.MessageHelper;
import com.univ.utils.EscapeString;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FrontUASHelper {
    public static <T> String genererSelect(String inputName, Collection<Map.Entry<T, String>> listeValeursLibelles, T valeurSelectionnee) {
        if (CollectionUtils.isEmpty(listeValeursLibelles)) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append("<select id=\"").append(inputName).append("\" name=\"").append(inputName).append("\">");
        for (Map.Entry<T, String> valeurLibelle : listeValeursLibelles) {
            T valeur = valeurLibelle.getKey();
            String valeurRadioProperties = MessageHelper.getCoreMessage(valeurLibelle.getValue());
            String libelle = (String)StringUtils.defaultIfBlank((CharSequence)valeurRadioProperties, (CharSequence)EscapeString.escapeHtml(valeurLibelle.getValue()));
            out.append("<option value=\"").append(valeur).append("\"");
            if (valeurSelectionnee != null && valeurSelectionnee.equals(valeur)) {
                out.append(" selected=\"selected\"");
            }
            out.append(">");
            out.append(libelle);
            out.append("</option>");
        }
        out.append("</select>");
        return out.toString();
    }

    public static <T> String genererListeRadio(String inputName, Collection<Map.Entry<T, String>> listeValeursLibelles, T valeurSelectionnee) {
        if (CollectionUtils.isEmpty(listeValeursLibelles)) {
            return "";
        }
        StringBuilder out = new StringBuilder("<ul class=\"en_ligne\" >");
        for (Map.Entry<T, String> valeurLibelle : listeValeursLibelles) {
            T valeurRadio = valeurLibelle.getKey();
            String idRadio = inputName + valeurRadio;
            String valeurRadioProperties = MessageHelper.getCoreMessage(valeurLibelle.getValue());
            String libelleRadio = (String)StringUtils.defaultIfBlank((CharSequence)valeurRadioProperties, (CharSequence)EscapeString.escapeHtml(valeurLibelle.getValue()));
            out.append("<li><input type=\"radio\" name=\"").append(inputName).append("\" value=\"").append(valeurRadio).append("\" id=\"").append(idRadio).append("\"");
            if (valeurSelectionnee != null && valeurSelectionnee.equals(valeurRadio)) {
                out.append(" checked=\"checked\"");
            }
            out.append("/>");
            out.append("<label for=\"").append(idRadio).append("\">").append(libelleRadio).append("</label></li>");
        }
        out.append("</ul>");
        return out.toString();
    }

    public static <T> String genererListeCheckbox(String inputNamePrefixe, Collection<Map.Entry<T, String>> listeValeursLibelles, Collection<T> valeursSelectionnees) {
        if (CollectionUtils.isEmpty(listeValeursLibelles)) {
            return "";
        }
        StringBuilder out = new StringBuilder("<ul class=\"en_ligne\" >");
        for (Map.Entry<T, String> valeurLibelle : listeValeursLibelles) {
            T valeurCheckbox = valeurLibelle.getKey();
            String nameCheckbox = inputNamePrefixe + "_" + valeurCheckbox;
            String valeurRadioProperties = MessageHelper.getCoreMessage(valeurLibelle.getValue());
            String libelleCheckbox = (String)StringUtils.defaultIfBlank((CharSequence)valeurRadioProperties, (CharSequence)EscapeString.escapeHtml(valeurLibelle.getValue()));
            out.append("<li><input type=\"checkbox\" name=\"").append(nameCheckbox).append("\" value=\"").append(valeurCheckbox).append("\" id=\"").append(nameCheckbox).append("\"");
            if (valeursSelectionnees != null && valeursSelectionnees.contains(valeurCheckbox)) {
                out.append(" checked=\"checked\"");
            }
            out.append("/>");
            out.append("<label for=\"").append(nameCheckbox).append("\">").append(libelleCheckbox).append("</label></li>");
        }
        out.append("</ul>");
        return out.toString();
    }

    public static String genererMessageInformatif(String message) {
        if (StringUtils.isEmpty((CharSequence)message)) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        out.append("<button type=\"button\" class=\"infobulle\" data-original-title=\"").append(EscapeString.escapeAttributHtml(message)).append("\"></button>");
        return out.toString();
    }

    public static String genererInputHTML(String type, String name, String id, String value, String classCss) {
        return FrontUASHelper.genererInputHTML(type, name, id, value, -1, 0, classCss, Boolean.FALSE);
    }

    public static String genererInputHTML(String type, String name, String id, String value, int maxLength, String classCss, boolean readOnly) {
        return FrontUASHelper.genererInputHTML(type, name, id, value, maxLength, 0, classCss, "", readOnly);
    }

    public static String genererInputHTML(String type, String name, String id, String value, int maxLength, int size, String classCss, boolean readOnly) {
        return FrontUASHelper.genererInputHTML(type, name, id, value, maxLength, size, classCss, "", readOnly);
    }

    public static String genererTexteareaHTML(String name, String id, String value, int maxLength, String classCss, String placeHolder, boolean readOnly) {
        StringBuilder out = new StringBuilder();
        out.append("<textarea ");
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            out.append(" name=\"");
            out.append(EscapeString.escapeAttributHtml(name));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            out.append(" id=\"");
            out.append(EscapeString.escapeAttributHtml(id));
            out.append("\"");
        }
        if (maxLength > 0) {
            out.append(" maxlength=\"");
            out.append(maxLength);
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)classCss)) {
            out.append(" class=\"");
            out.append(EscapeString.escapeAttributHtml(classCss));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)placeHolder)) {
            out.append(" placeHolder=\"");
            out.append(EscapeString.escapeAttributHtml(placeHolder));
            out.append("\"");
        }
        if (readOnly) {
            out.append(" readonly=\"readonly\"");
        }
        out.append(">");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            out.append(EscapeString.escapeHtml(value));
        }
        out.append("</textarea>");
        return out.toString();
    }

    public static String genererInputHTML(String type, String name, String id, String value, int maxLength, int size, String classCss, String placeHolder, boolean readOnly) {
        StringBuilder out = new StringBuilder();
        out.append("<input");
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            out.append(" type=\"");
            out.append(EscapeString.escapeAttributHtml(type));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            out.append(" name=\"");
            out.append(EscapeString.escapeAttributHtml(name));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            out.append(" id=\"");
            out.append(EscapeString.escapeAttributHtml(id));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            out.append(" value=\"");
            out.append(EscapeString.escapeAttributHtml(value));
            out.append("\"");
        }
        if (maxLength > 0) {
            out.append(" maxlength=\"");
            out.append(maxLength);
            out.append("\"");
        }
        if (size > 0) {
            out.append(" size=\"");
            out.append(size);
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)classCss)) {
            out.append(" class=\"");
            out.append(EscapeString.escapeAttributHtml(classCss));
            out.append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)placeHolder)) {
            out.append(" placeHolder=\"");
            out.append(EscapeString.escapeAttributHtml(placeHolder));
            out.append("\"");
        }
        if (readOnly) {
            out.append(" readonly=\"readonly\"");
        }
        out.append("/>");
        return out.toString();
    }

    public static final String genererNameInputProprieteTemplate(TemplateSite template, TemplateSiteProperty propriete) {
        return FrontUASHelper.genererNameInputProprieteTemplate(template.getCode(), propriete.getCode());
    }

    public static final String genererNameInputProprieteTemplate(String codeTemplate, String codePropriete) {
        return "template_" + codeTemplate + "_" + codePropriete;
    }
}

