/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.utils;

import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kportal.core.config.MessageHelper;
import com.kportal.core.webapp.WebAppUtil;
import com.univ.multisites.InfosSite;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class InfosSiteHelper {
    private static final Pattern codeMetierPattern = Pattern.compile("[a-zA-Z0-9\\-_@\\.]+");
    private static final String URL_SEPARATEUR = "/";
    public static final Collection<Map.Entry<Integer, String>> SSL_MODE;
    public static final Collection<Map.Entry<Integer, String>> BO_SSL_MODE;
    public static final Collection<Map.Entry<Integer, String>> HTTP_ACTIONS;
    public static final Collection<Map.Entry<Integer, String>> HTTPS_ACTIONS;
    public static final List<Map.Entry<Integer, String>> MODE_REECRITURE_RUBRIQUE;

    public static boolean isHttpHostNameParDefaut(InfosSite infosSite) {
        return infosSite.getHttpHostname() == null;
    }

    public static boolean isHttpsHostNameParDefaut(InfosSite infosSite) {
        return infosSite.getHttpsHostname() == null;
    }

    public static boolean isHttpPortParDefaut(InfosSite infosSite) {
        return infosSite.getHttpPort() == -1;
    }

    public static boolean isHttpsPortParDefaut(InfosSite infosSite) {
        return infosSite.getHttpsPort() == -1;
    }

    public static boolean isSslModeValide(int sslMode) {
        return InfosSiteHelper.isCleContenuDansListeValeursAutorisee(sslMode, SSL_MODE);
    }

    public static boolean isBoSslModeValide(int boSslMode) {
        return InfosSiteHelper.isCleContenuDansListeValeursAutorisee(boSslMode, BO_SSL_MODE);
    }

    public static boolean isHttpActionValide(int valeuHttpAction) {
        return InfosSiteHelper.isCleContenuDansListeValeursAutorisee(valeuHttpAction, HTTP_ACTIONS);
    }

    public static boolean isHttpsActionValide(int valeuHttpsAction) {
        return InfosSiteHelper.isCleContenuDansListeValeursAutorisee(valeuHttpsAction, HTTPS_ACTIONS);
    }

    public static boolean isModeReecritureValide(int valeuModeReecriture) {
        return InfosSiteHelper.isCleContenuDansListeValeursAutorisee(valeuModeReecriture, MODE_REECRITURE_RUBRIQUE);
    }

    public static String getPathAbsoluFichiersTemplateDuSite(InfosSite infosSite) {
        return InfosSiteHelper.getPathAbsoluFichiersTemplateDuSite(infosSite.getAlias());
    }

    public static String getPathAbsoluFichiersTemplateDuSite(String codeSite) {
        return WebAppUtil.getAbsoluteFichiersSitesPath() + File.separator + codeSite + File.separator;
    }

    public static String getPathAbsoluFichierPropertyTemplate(InfosSite infosSite, String nomPropertyTemplate) throws ErreurDonneeNonTrouve {
        if (infosSite == null) {
            throw new ErreurDonneeNonTrouve("Impossible de r\u00e9cup\u00e9rer la propri\u00e9t\u00e9 : " + nomPropertyTemplate + " sur un InfosSite null");
        }
        String codeSite = infosSite.getAlias();
        String intituleFichier = infosSite.getProprieteComplementaireString(nomPropertyTemplate);
        if (StringUtils.isEmpty((CharSequence)intituleFichier)) {
            throw new ErreurDonneeNonTrouve("Intitul\u00e9 de fichier introuvable pour la property de template : " + nomPropertyTemplate + ", du site : " + codeSite);
        }
        return WebAppUtil.getAbsoluteFichiersSitesPath() + File.separator + codeSite + File.separator + nomPropertyTemplate + File.separator + intituleFichier;
    }

    public static String getURLRelativeFichierPropertyTemplate(InfosSite infosSite, String nomPropertyTemplate) throws ErreurDonneeNonTrouve {
        if (infosSite == null) {
            throw new ErreurDonneeNonTrouve("Impossible de r\u00e9cup\u00e9rer la propri\u00e9t\u00e9 : " + nomPropertyTemplate + " sur un InfosSite null");
        }
        String codeSite = infosSite.getAlias();
        String intituleFichier = infosSite.getProprieteComplementaireString(nomPropertyTemplate);
        if (StringUtils.isEmpty((CharSequence)intituleFichier)) {
            throw new ErreurDonneeNonTrouve("Intitul\u00e9 de fichier introuvable pour la property de template : " + nomPropertyTemplate + ", du site : " + codeSite);
        }
        return WebAppUtil.getRelatifFichiersSitesPath() + codeSite + URL_SEPARATEUR + nomPropertyTemplate + URL_SEPARATEUR + intituleFichier;
    }

    private static boolean isCleContenuDansListeValeursAutorisee(int cle, Collection<Map.Entry<Integer, String>> listeValeurs) {
        for (Map.Entry<Integer, String> valeurValide : listeValeurs) {
            if (valeurValide.getKey() != cle) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void controlerCode(String code) throws ErreurApplicative {
        Matcher matcher = codeMetierPattern.matcher(code);
        if (!matcher.matches()) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage("BO_USINESITE_ERREUR_CODE_INCORRECT"));
        }
    }

    static {
        ArrayList<ImmutablePair> modeSsl = new ArrayList<ImmutablePair>(3);
        modeSsl.add(new ImmutablePair((Object)0, (Object)"BO_DESACTIVE"));
        modeSsl.add(new ImmutablePair((Object)1, (Object)"BO_USINESITE_ACTIVE_CONTEXTUEL"));
        modeSsl.add(new ImmutablePair((Object)2, (Object)"BO_USINESITE_ACTIVE_TOUT_SITE"));
        SSL_MODE = Collections.unmodifiableList(modeSsl);
        ArrayList<ImmutablePair> boSslMode = new ArrayList<ImmutablePair>(2);
        boSslMode.add(new ImmutablePair((Object)0, (Object)"BO_DESACTIVE"));
        boSslMode.add(new ImmutablePair((Object)1, (Object)"BO_ACTIVE"));
        BO_SSL_MODE = Collections.unmodifiableList(boSslMode);
        ArrayList<ImmutablePair> actionsHTTP = new ArrayList<ImmutablePair>(1);
        actionsHTTP.add(new ImmutablePair((Object)5, (Object)"ST_DSI_DECONNEXION"));
        HTTP_ACTIONS = Collections.unmodifiableList(actionsHTTP);
        ArrayList<ImmutablePair> actionsHTTPS = new ArrayList<ImmutablePair>(4);
        actionsHTTPS.add(new ImmutablePair((Object)1, (Object)"ST_DSI_PREFIDENTIFICATION"));
        actionsHTTPS.add(new ImmutablePair((Object)2, (Object)"BO_USINESITE_PERSONNALISATION_INFOS"));
        actionsHTTPS.add(new ImmutablePair((Object)3, (Object)"BO_USINESITE_DEMANDE_MDP"));
        actionsHTTPS.add(new ImmutablePair((Object)4, (Object)"BO_USINESITE_PRESENTATION_MDP"));
        HTTPS_ACTIONS = Collections.unmodifiableList(actionsHTTPS);
        ArrayList<ImmutablePair> reecritureRubrique = new ArrayList<ImmutablePair>(4);
        reecritureRubrique.add(new ImmutablePair((Object)0, (Object)"BO_USINESITE_UNIQUEMENT_NOM_PAGE"));
        reecritureRubrique.add(new ImmutablePair((Object)1, (Object)"BO_USINESITE_NOM_PAGE_RUBRIQUE"));
        MODE_REECRITURE_RUBRIQUE = Collections.unmodifiableList(reecritureRubrique);
    }
}

