/*
 * Decompiled with CFR 0.152.
 */
package com.kosmos.usinesite.utils;

import com.jsbsoft.jtf.core.InfoBean;
import com.jsbsoft.jtf.exception.ErreurApplicative;
import com.jsbsoft.jtf.exception.ErreurDonneeNonTrouve;
import com.kosmos.usinesite.exception.ErreursSaisieInfosSite;
import com.kosmos.usinesite.template.bean.TemplateSite;
import com.kosmos.usinesite.template.property.bean.TemplateSiteProperty;
import com.kosmos.usinesite.template.property.extracteur.TemplateSitePropertyExtracteur;
import com.kosmos.usinesite.template.property.service.ServiceTemplateSiteProperty;
import com.kosmos.usinesite.template.property.service.ServiceTemplateSitePropertyFactory;
import com.kosmos.usinesite.template.property.validateur.TemplateSitePropertyValidateur;
import com.kosmos.usinesite.utils.InfosSiteHelper;
import com.kportal.core.config.MessageHelper;
import com.univ.multisites.InfosSite;
import com.univ.multisites.bean.impl.InfosSiteImpl;
import com.univ.objetspartages.om.InfosRubriques;
import com.univ.objetspartages.om.Rubrique;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaisieInfosSiteInfoBeanHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SaisieInfosSiteInfoBeanHelper.class);
    private static final String MESSAGE_ERREUR_CODE_OBLIGATOIRE = "BO_USINESITE_ERREUR_CODE_OBLIGATOIRE";
    private static final String MESSAGE_ERREUR_CODE_TROP_LONG = "BO_USINESITE_ERREUR_CODE_TROP_LONG";
    private static final String MESSAGE_ERREUR_INTITULE_OBLIGATOIRE = "BO_USINESITE_ERREUR_INTITULE_OBLIGATOIRE";
    private static final String MESSAGE_ERREUR_INTITULE_TROP_LONG = "BO_USINESITE_ERREUR_INTITULE_TROP_LONG";
    private static final String MESSAGE_ERREUR_RUBRIQUE_OBLIGATOIRE = "BO_USINESITE_ERREUR_RUBRIQUE_OBLIGATOIRE";
    private static final String MESSAGE_ERREUR_CODE_RUBRIQUE_INVALIDE = "BO_USINESITE_ERREUR_CODE_RUBRIQUE_INVALIDE";
    private static final String MESSAGE_ERREUR_HOSTNAME_HTTP_TROP_LONG = "BO_USINESITE_ERREUR_HOSTNAME_HTTP_TROP_LONG";
    private static final String MESSAGE_ERREUR_HOSTNAME_HTTPS_TROP_LONG = "BO_USINESITE_ERREUR_HOSTNAME_HTTPS_TROP_LONG";
    private static final String MESSAGE_ERREUR_ACTION_HTTPS_INVALIDE = "BO_USINESITE_ERREUR_ACTION_HTTPS_INVALIDE";
    private static final String MESSAGE_ERREUR_ACTION_HTTP_INVALIDE = "BO_USINESITE_ERREUR_ACTION_HTTP_INVALIDE";
    private static final String MESSAGE_ERREUR_MODE_SSL_BACK_OFFICE_INVALIDE = "BO_USINESITE_ERREUR_MODE_SSL_BACK_OFFICE_INVALIDE";
    private static final String MESSAGE_ERREUR_MODE_SSL_INVALIDE = "BO_USINESITE_ERREUR_MODE_SSL_INVALIDE";
    private static final String MESSAGE_ERREUR_NOM_DONNEE_PORT_HTTPS = "BO_USINESITE_ERREUR_NOM_DONNEE_PORT_HTTPS";
    private static final String MESSAGE_ERREUR_NOM_DONNEE_PORT_HTTP = "BO_USINESITE_ERREUR_NOM_DONNEE_PORT_HTTP";
    private static final String MESSAGE_ERREUR_MODE_REECRITURE_INVALIDE = "BO_USINESITE_ERREUR_MODE_REECRITURE_INVALIDE";
    private static final String MESSAGE_ERREUR_NOM_DONNEE_NIVEAU_MIN = "BO_USINESITE_ERREUR_NOM_DONNEE_NIVEAU_MIN";
    private static final String MESSAGE_ERREUR_NOM_DONNEE_NIVEAU_MAX = "BO_USINESITE_ERREUR_NOM_DONNEE_NIVEAU_MAX";
    private static final String MESSAGE_ERREUR_INT_INFERIEUR_ZERO = "BO_USINESITE_ERREUR_INT_INFERIEUR_ZERO";
    private static final String MESSAGE_ERREUR_TEMPLATE = "BO_USINESITE_ERREUR_TEMPLATE";
    private static final String INFOBEAN_BOOLEAN_STRING_TRUE = "1";
    private static final String INFOBEAN_BOOLEAN_ON = "on";
    private static final String UNDERSCORE = "_";

    public static void peuplerInfosSiteDepuisInfoBean(InfoBean infoBean, InfosSiteImpl infosSite, TemplateSite template) throws Exception {
        ArrayList<String> fluxMessagesErreurs = new ArrayList<String>();
        SaisieInfosSiteInfoBeanHelper.gestionDonneesSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.gestionDonneesTemplate(infosSite, template, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.gestionDesErreurs(infosSite, template, fluxMessagesErreurs);
    }

    private static void gestionDonneesSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        SaisieInfosSiteInfoBeanHelper.setCodeInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setIntituleInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setRubriqueInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setHostnameHttpInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setHostnameHttpsInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        infosSite.setSitePrincipal(SaisieInfosSiteInfoBeanHelper.getSitePrincipal(infoBean, infosSite));
        infosSite.setUrlAccueil(infoBean.getString("PAGE_ACCUEIL"));
        infosSite.setSso(SaisieInfosSiteInfoBeanHelper.getBoolean(infoBean, "SSO"));
        infosSite.setActif(SaisieInfosSiteInfoBeanHelper.getBoolean(infoBean, "ACTIF"));
        SaisieInfosSiteInfoBeanHelper.setHttpPortInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setHttpsPortInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setSslModetInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setBoSslModetInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setHttpActionsInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setHttpsActionsInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setListeHostAliasInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setModeReecritureRubriqueInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setNiveauMaxReecritureRubriqueInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setNiveauMinReecritureRubriqueInfosSite(infosSite, infoBean, fluxMessagesErreurs);
        SaisieInfosSiteInfoBeanHelper.setRestrictionInfosSite(infosSite, infoBean, fluxMessagesErreurs);
    }

    private static boolean getSitePrincipal(InfoBean infoBean, InfosSite site) {
        boolean sitePrincipal = site.isSitePrincipal();
        String valeurSitePrincipal = StringUtils.defaultString((String)infoBean.getString("PRINCIPAL"));
        if (StringUtils.isNotBlank((CharSequence)valeurSitePrincipal)) {
            sitePrincipal = StringUtils.equals((CharSequence)valeurSitePrincipal, (CharSequence)INFOBEAN_BOOLEAN_STRING_TRUE);
        }
        return sitePrincipal;
    }

    public static void setRestrictionInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        if (SaisieInfosSiteInfoBeanHelper.getBoolean(infoBean, "RESTREINT")) {
            infosSite.setRestriction(1);
        } else {
            infosSite.setRestriction(0);
        }
    }

    public static void setNiveauMinReecritureRubriqueInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        int niveauMin = SaisieInfosSiteInfoBeanHelper.getIntSuperieurEgalZero(infoBean, "NIVEAU_REECRITURE_MIN", 100, MessageHelper.getCoreMessage(MESSAGE_ERREUR_NOM_DONNEE_NIVEAU_MIN), fluxMessagesErreurs);
        infosSite.setNiveauMinReecritureRubrique(niveauMin);
    }

    public static void setNiveauMaxReecritureRubriqueInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        int niveauMax = SaisieInfosSiteInfoBeanHelper.getIntSuperieurEgalZero(infoBean, "NIVEAU_REECRITURE_MAX", 100, MessageHelper.getCoreMessage(MESSAGE_ERREUR_NOM_DONNEE_NIVEAU_MAX), fluxMessagesErreurs);
        infosSite.setNiveauMaxReecritureRubrique(niveauMax);
    }

    public static void setModeReecritureRubriqueInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String modeReecriture = infoBean.getString("MODE_REECRITURE");
        if (StringUtils.isEmpty((CharSequence)modeReecriture)) {
            infosSite.setModeReecritureRubrique(0);
        } else if (!StringUtils.isNumeric((CharSequence)modeReecriture)) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_REECRITURE_INVALIDE));
            infosSite.setModeReecritureRubrique(0);
        } else {
            int valeuModeReecriture = Integer.parseInt(modeReecriture);
            if (!InfosSiteHelper.isModeReecritureValide(valeuModeReecriture)) {
                fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_REECRITURE_INVALIDE));
            }
            infosSite.setModeReecritureRubrique(valeuModeReecriture);
        }
    }

    public static void setListeHostAliasInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String[] alias = StringUtils.split((String)infoBean.getString("ALIAS"), (String)",");
        infosSite.setListeHostAlias(new TreeSet<String>(Arrays.asList(alias)));
    }

    public static void setHttpsActionsInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        Map<String, String> mapActionsHTTPS = SaisieInfosSiteInfoBeanHelper.getListeValeurs(infoBean, "ACTIONS_HTTPS");
        TreeSet<Integer> setHttpsActions = new TreeSet<Integer>();
        for (Map.Entry<String, String> valeur : mapActionsHTTPS.entrySet()) {
            String actionString = valeur.getValue();
            if (StringUtils.isEmpty((CharSequence)actionString)) continue;
            try {
                int valeurHttpAction = SaisieInfosSiteInfoBeanHelper.getHttpsAction(actionString);
                setHttpsActions.add(valeurHttpAction);
            }
            catch (ErreurApplicative e) {
                fluxMessagesErreurs.add(e.getMessage());
            }
        }
        infosSite.setHttpsActions(setHttpsActions);
    }

    public static int getHttpsAction(String actionString) throws ErreurApplicative {
        if (!StringUtils.isNumeric((CharSequence)actionString)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(MESSAGE_ERREUR_ACTION_HTTPS_INVALIDE));
        }
        int valeuHttpsAction = Integer.parseInt(actionString);
        if (!InfosSiteHelper.isHttpsActionValide(valeuHttpsAction)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(MESSAGE_ERREUR_ACTION_HTTPS_INVALIDE));
        }
        return valeuHttpsAction;
    }

    public static void setHttpActionsInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        Map<String, String> mapActionsHTTP = SaisieInfosSiteInfoBeanHelper.getListeValeurs(infoBean, "ACTIONS_HTTP");
        TreeSet<Integer> setHttpActions = new TreeSet<Integer>();
        for (Map.Entry<String, String> valeur : mapActionsHTTP.entrySet()) {
            String actionString = valeur.getValue();
            if (StringUtils.isEmpty((CharSequence)actionString)) continue;
            try {
                int valeurHttpAction = SaisieInfosSiteInfoBeanHelper.getHttpAction(actionString);
                setHttpActions.add(valeurHttpAction);
            }
            catch (ErreurApplicative e) {
                fluxMessagesErreurs.add(e.getMessage());
            }
        }
        infosSite.setHttpActions(setHttpActions);
    }

    public static int getHttpAction(String actionString) throws ErreurApplicative {
        if (!StringUtils.isNumeric((CharSequence)actionString)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(MESSAGE_ERREUR_ACTION_HTTP_INVALIDE));
        }
        int valeuHttpAction = Integer.parseInt(actionString);
        if (!InfosSiteHelper.isHttpActionValide(valeuHttpAction)) {
            throw new ErreurApplicative(MessageHelper.getCoreMessage(MESSAGE_ERREUR_ACTION_HTTP_INVALIDE));
        }
        return valeuHttpAction;
    }

    public static void setBoSslModetInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String boSslMode = infoBean.getString("BO_MODE_SSL");
        if (StringUtils.isEmpty((CharSequence)boSslMode)) {
            infosSite.setBoSslMode(0);
        } else if (!StringUtils.isNumeric((CharSequence)boSslMode)) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_SSL_BACK_OFFICE_INVALIDE));
            infosSite.setBoSslMode(0);
        } else {
            int valeuBoSslMode = Integer.parseInt(boSslMode);
            if (!InfosSiteHelper.isBoSslModeValide(valeuBoSslMode)) {
                fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_SSL_BACK_OFFICE_INVALIDE));
            }
            infosSite.setBoSslMode(valeuBoSslMode);
        }
    }

    public static void setSslModetInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String modeSSL = infoBean.getString("MODE_SSL");
        if (StringUtils.isEmpty((CharSequence)modeSSL)) {
            infosSite.setSslMode(0);
        } else if (!StringUtils.isNumeric((CharSequence)modeSSL)) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_SSL_INVALIDE));
            infosSite.setSslMode(0);
        } else {
            int valeuModeSSL = Integer.parseInt(modeSSL);
            if (!InfosSiteHelper.isSslModeValide(valeuModeSSL)) {
                fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_MODE_SSL_INVALIDE));
            }
            infosSite.setSslMode(valeuModeSSL);
        }
    }

    public static void setHttpPortInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        int valeurPort = SaisieInfosSiteInfoBeanHelper.getIntSuperieurEgalZero(infoBean, "HTTP_PORT", -1, MessageHelper.getCoreMessage(MESSAGE_ERREUR_NOM_DONNEE_PORT_HTTP), fluxMessagesErreurs);
        infosSite.setHttpPort(valeurPort);
    }

    public static void setHttpsPortInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        int valeurPort = SaisieInfosSiteInfoBeanHelper.getIntSuperieurEgalZero(infoBean, "HTTPS_PORT", -1, MessageHelper.getCoreMessage(MESSAGE_ERREUR_NOM_DONNEE_PORT_HTTPS), fluxMessagesErreurs);
        infosSite.setHttpsPort(valeurPort);
    }

    public static void setHostnameHttpsInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String hostNameHttps = infoBean.getString("HTTPS_HOSTNAME");
        if ((hostNameHttps = StringUtils.trimToEmpty((String)hostNameHttps)).length() > 255) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_HOSTNAME_HTTPS_TROP_LONG));
        }
        infosSite.setHttpsHostname(hostNameHttps);
    }

    public static void setHostnameHttpInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String hostNameHttp = infoBean.getString("HTTP_HOSTNAME");
        if ((hostNameHttp = StringUtils.trimToEmpty((String)hostNameHttp)).length() > 255) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_HOSTNAME_HTTP_TROP_LONG));
        }
        infosSite.setHttpHostname(hostNameHttp);
    }

    public static void setRubriqueInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String codeRubrique = infoBean.getString("CODE_RUBRIQUE");
        if (StringUtils.isEmpty((CharSequence)StringUtils.trimToEmpty((String)(codeRubrique = StringUtils.trimToEmpty((String)codeRubrique))))) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_RUBRIQUE_OBLIGATOIRE));
        } else {
            InfosRubriques rubrique = Rubrique.renvoyerItemRubrique(codeRubrique);
            if (rubrique == null || StringUtils.isEmpty((CharSequence)rubrique.getCode())) {
                fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_CODE_RUBRIQUE_INVALIDE));
            }
        }
        infosSite.setCodeRubrique(codeRubrique);
    }

    public static void setIntituleInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String intitule = infoBean.getString("INTITULE");
        if (StringUtils.isEmpty((CharSequence)(intitule = StringUtils.trimToEmpty((String)intitule)))) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_INTITULE_OBLIGATOIRE));
        } else if (intitule.length() > 255) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_INTITULE_TROP_LONG));
        }
        infosSite.setIntitule(intitule);
    }

    public static void setCodeInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) {
        String code = infoBean.getString("CODE");
        if (StringUtils.isEmpty((CharSequence)(code = StringUtils.trimToEmpty((String)code)))) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_CODE_OBLIGATOIRE));
        } else if (code.length() > 64) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_CODE_TROP_LONG));
        } else {
            try {
                InfosSiteHelper.controlerCode(code);
            }
            catch (ErreurApplicative e) {
                fluxMessagesErreurs.add(e.getMessage());
            }
        }
        infosSite.setAlias(code);
    }

    public static void gestionDonneesTemplate(InfosSiteImpl infosSite, TemplateSite template, InfoBean infoBean, ArrayList<String> fluxMessagesErreurs) throws Exception {
        if (template == null) {
            fluxMessagesErreurs.add(MessageHelper.getCoreMessage(MESSAGE_ERREUR_TEMPLATE));
            return;
        }
        infosSite.setCodeTemplate(template.getCode());
        infosSite.setJspFo(template.getDossierJSP());
        ServiceTemplateSiteProperty service = ServiceTemplateSitePropertyFactory.getServiceTemplateSite();
        for (TemplateSiteProperty property : template.getListeProprietesComplementaires()) {
            SaisieInfosSiteInfoBeanHelper.validerDonneeTemplateDansInfosSite(infosSite, infoBean, template, property, service, fluxMessagesErreurs);
            SaisieInfosSiteInfoBeanHelper.injecterDonneeTemplateDansInfosSite(infosSite, infoBean, template, property, service);
        }
    }

    private static void validerDonneeTemplateDansInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, TemplateSite template, TemplateSiteProperty property, ServiceTemplateSiteProperty service, ArrayList<String> fluxMessagesErreurs) throws Exception {
        try {
            TemplateSitePropertyValidateur<TemplateSiteProperty> validateur = service.getTemplateSitePropertyValidateur(property);
            validateur.valider(infosSite, template, property, infoBean);
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.debug("pas de validteur trouv\u00e9 ", (Throwable)e);
        }
        catch (ErreursSaisieInfosSite e) {
            fluxMessagesErreurs.addAll(e.getListeMessagesErreur());
        }
    }

    private static void injecterDonneeTemplateDansInfosSite(InfosSiteImpl infosSite, InfoBean infoBean, TemplateSite template, TemplateSiteProperty property, ServiceTemplateSiteProperty service) throws Exception {
        try {
            TemplateSitePropertyExtracteur<TemplateSiteProperty, Object> extracteur = service.getTemplateSitePropertyExtracteur(property);
            Object valeur = extracteur.extraire(infosSite, template, property, infoBean);
            if (valeur != null) {
                infosSite.putProperty(property.getCode(), valeur);
            }
        }
        catch (ErreurDonneeNonTrouve e) {
            LOG.debug("pas d'extracteur trouv\u00e9", (Throwable)e);
        }
    }

    private static void gestionDesErreurs(InfosSiteImpl infosSite, TemplateSite template, ArrayList<String> fluxMessagesErreurs) throws ErreursSaisieInfosSite {
        if (!fluxMessagesErreurs.isEmpty()) {
            throw new ErreursSaisieInfosSite(fluxMessagesErreurs, (InfosSite)infosSite, template);
        }
    }

    public static boolean getInfosSiteActif(InfoBean infoBean) {
        return SaisieInfosSiteInfoBeanHelper.getBoolean(infoBean, "ACTIF");
    }

    private static int getIntSuperieurEgalZero(InfoBean infoBean, String cle, int valeurDefaut, String intituleDonnee, ArrayList<String> fluxMessagesErreurs) {
        String niveauMin = infoBean.getString(cle);
        if (StringUtils.isEmpty((CharSequence)niveauMin)) {
            return valeurDefaut;
        }
        if (!StringUtils.isNumeric((CharSequence)niveauMin)) {
            fluxMessagesErreurs.add(intituleDonnee + MessageHelper.getCoreMessage(MESSAGE_ERREUR_INT_INFERIEUR_ZERO));
            return valeurDefaut;
        }
        int valeurNiveauMin = Integer.parseInt(niveauMin);
        if (valeurNiveauMin < 0) {
            fluxMessagesErreurs.add(intituleDonnee + MessageHelper.getCoreMessage(MESSAGE_ERREUR_INT_INFERIEUR_ZERO));
        }
        return valeurNiveauMin;
    }

    public static List<String> getListeText(InfoBean data, String nomComposant) {
        String valeurs = data.getString(nomComposant);
        if (StringUtils.isEmpty((CharSequence)valeurs)) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)valeurs, (String)","));
    }

    public static Map<String, String> getListeValeurs(InfoBean infoBean, String prefixeCleInfoBean) {
        prefixeCleInfoBean = prefixeCleInfoBean + UNDERSCORE;
        TreeMap<String, String> mapListeValeurs = new TreeMap<String, String>();
        for (String cleInfoBean : infoBean.getDataKeys()) {
            Object valeur;
            if (!StringUtils.startsWith((CharSequence)cleInfoBean, (CharSequence)prefixeCleInfoBean) || (valeur = infoBean.get(cleInfoBean)) == null || !(valeur instanceof String) || !StringUtils.isNotEmpty((CharSequence)((String)valeur))) continue;
            mapListeValeurs.put(cleInfoBean, (String)valeur);
        }
        return mapListeValeurs;
    }

    public static boolean getBoolean(InfoBean infoBean, String cleInfoBean) {
        String actif = infoBean.getString(cleInfoBean);
        return StringUtils.equals((CharSequence)actif, (CharSequence)INFOBEAN_BOOLEAN_STRING_TRUE);
    }

    public static boolean isChecked(InfoBean infoBean, String cleInfoBean) {
        String actif = infoBean.getString(cleInfoBean);
        return StringUtils.equals((CharSequence)actif, (CharSequence)INFOBEAN_BOOLEAN_ON);
    }
}

